/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.suggestion.CustomIdentifierNamespaceSuggestions;
import de.markusbordihn.easynpc.commands.suggestion.CustomIdentifierSuggestions;
import de.markusbordihn.easynpc.commands.suggestion.DimensionSuggestions;
import de.markusbordihn.easynpc.commands.suggestion.NPCEntityTypeSuggestions;
import de.markusbordihn.easynpc.data.npc.SavedNPCEntityEntry;
import de.markusbordihn.easynpc.data.saveddata.NPCEntityData;
import java.util.Collection;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ListCommand
extends Command {
    private static final String OWNER_ARG = "owner";
    private static final String ENTITY_TYPE_ARG = "entity_type";
    private static final String DIMENSION_ARG = "dimension";
    private static final String CUSTOM_IDENTIFIER_ARG = "custom_identifier";
    private static final String NAMESPACE_ARG = "namespace";

    private ListCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(cs -> cs.method_9259(2))).executes(context -> ListCommand.listAllNPCs((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)OWNER_ARG).executes(context -> ListCommand.listNPCsByOwner((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)OWNER_ARG, (ArgumentType)class_2186.method_9305()).executes(context -> ListCommand.listNPCsByOwner((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)OWNER_ARG)))))).then(class_2170.method_9247((String)"type").then(class_2170.method_9244((String)ENTITY_TYPE_ARG, (ArgumentType)class_2232.method_9441()).suggests(NPCEntityTypeSuggestions::suggest).executes(context -> ListCommand.listNPCsByType((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)ENTITY_TYPE_ARG)))))).then(class_2170.method_9247((String)DIMENSION_ARG).then(class_2170.method_9244((String)DIMENSION_ARG, (ArgumentType)class_2232.method_9441()).suggests(DimensionSuggestions::suggest).executes(context -> ListCommand.listNPCsByDimension((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)DIMENSION_ARG)))))).then(class_2170.method_9247((String)"identifier").then(class_2170.method_9244((String)CUSTOM_IDENTIFIER_ARG, (ArgumentType)class_2232.method_9441()).suggests(CustomIdentifierSuggestions::suggest).executes(context -> ListCommand.listNPCsByCustomIdentifier((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)CUSTOM_IDENTIFIER_ARG)))))).then(class_2170.method_9247((String)NAMESPACE_ARG).then(class_2170.method_9244((String)NAMESPACE_ARG, (ArgumentType)StringArgumentType.word()).suggests(CustomIdentifierNamespaceSuggestions::suggest).executes(context -> ListCommand.listNPCsByNamespace((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)NAMESPACE_ARG)))));
    }

    private static int listAllNPCs(class_2168 context) {
        NPCEntityData npcData = NPCEntityData.get(context.method_9211());
        int count = npcData.getCount();
        ListCommand.sendSuccessMessage(context, "Total NPCs: " + count, class_124.field_1060);
        Collection<SavedNPCEntityEntry> entries = npcData.getAllEntries();
        int displayed = 0;
        for (SavedNPCEntityEntry entry : entries) {
            if (displayed >= 10) {
                ListCommand.sendSuccessMessage(context, "... and " + (count - displayed) + " more NPCs", class_124.field_1080);
                break;
            }
            ListCommand.sendEntryInfo(context, entry, true, true, false);
            ++displayed;
        }
        return 1;
    }

    private static int listNPCsByOwner(class_2168 context, class_3222 player) {
        class_3222 self;
        NPCEntityData npcData = NPCEntityData.get(context.method_9211());
        Collection<SavedNPCEntityEntry> entries = npcData.getEntriesByOwner(player.method_5667());
        class_1297 class_12972 = context.method_9228();
        boolean isSelf = class_12972 instanceof class_3222 && (self = (class_3222)class_12972).method_5667().equals(player.method_5667());
        String ownerName = isSelf ? "Your" : player.method_5477().getString() + "'s";
        ListCommand.sendSuccessMessage(context, ownerName + " NPCs: " + entries.size(), class_124.field_1060);
        entries.forEach(entry -> ListCommand.sendEntryInfo(context, entry, false, true, true));
        return 1;
    }

    private static int listNPCsByType(class_2168 context, class_2960 entityType) {
        NPCEntityData npcData = NPCEntityData.get(context.method_9211());
        Collection<SavedNPCEntityEntry> entries = npcData.getEntriesByType(entityType.toString());
        ListCommand.sendSuccessMessage(context, "NPCs of type " + String.valueOf(entityType) + ": " + entries.size(), class_124.field_1060);
        entries.forEach(entry -> ListCommand.sendEntryInfo(context, entry, true, false, true));
        return 1;
    }

    private static int listNPCsByDimension(class_2168 context, class_2960 dimension) {
        NPCEntityData npcData = NPCEntityData.get(context.method_9211());
        Collection<SavedNPCEntityEntry> entries = npcData.getEntriesByDimension(dimension.toString());
        ListCommand.sendSuccessMessage(context, "NPCs in dimension " + String.valueOf(dimension) + ": " + entries.size(), class_124.field_1060);
        entries.forEach(entry -> ListCommand.sendEntryInfo(context, entry, true, true, false));
        return 1;
    }

    private static int listNPCsByCustomIdentifier(class_2168 context, class_2960 customIdentifier) {
        NPCEntityData npcData = NPCEntityData.get(context.method_9211());
        Collection<SavedNPCEntityEntry> entries = npcData.getEntriesByCustomIdentifier(customIdentifier);
        ListCommand.sendSuccessMessage(context, "NPCs with custom identifier " + String.valueOf(customIdentifier) + ": " + entries.size(), class_124.field_1060);
        entries.forEach(entry -> ListCommand.sendEntryInfo(context, entry, true, true, true));
        return 1;
    }

    private static int listNPCsByNamespace(class_2168 context, String namespace) {
        NPCEntityData npcData = NPCEntityData.get(context.method_9211());
        Collection<SavedNPCEntityEntry> entries = npcData.getEntriesByCustomIdentifierNamespace(namespace);
        ListCommand.sendSuccessMessage(context, "NPCs with custom identifier namespace '" + namespace + "': " + entries.size(), class_124.field_1060);
        for (SavedNPCEntityEntry entry : entries) {
            StringBuilder info = new StringBuilder("- " + String.valueOf(entry.entityUUID()));
            if (entry.metadata().hasOwner()) {
                info.append(" Owner: ").append(entry.metadata().ownerUUID());
            } else {
                info.append(" (No owner)");
            }
            if (entry.metadata().hasEntityType()) {
                info.append(" Type: ").append(entry.metadata().entityType());
            }
            if (entry.metadata().hasCustomIdentifier()) {
                info.append(" ID: ").append(entry.metadata().customIdentifier());
            }
            ListCommand.sendSuccessMessage(context, info.toString(), class_124.field_1068);
        }
        return 1;
    }

    private static void sendEntryInfo(class_2168 context, SavedNPCEntityEntry entry, boolean showOwner, boolean showType, boolean showDimension) {
        StringBuilder info = new StringBuilder("- " + String.valueOf(entry.entityUUID()));
        if (showOwner) {
            if (entry.metadata().hasOwner()) {
                info.append(" Owner: ").append(entry.metadata().ownerUUID());
            } else {
                info.append(" (No owner)");
            }
        }
        if (showType && entry.metadata().hasEntityType()) {
            info.append(" Type: ").append(entry.metadata().entityType());
        }
        if (showDimension && entry.metadata().hasDimension()) {
            info.append(" Dimension: ").append(entry.metadata().dimension());
        }
        ListCommand.sendSuccessMessage(context, info.toString(), class_124.field_1068);
    }
}

