/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.suggestion.ColorSuggestions;
import de.markusbordihn.easynpc.commands.suggestion.NameVisibilitySuggestions;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.NameHandler;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class NameCommand
extends Command {
    private NameCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"name").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> NameCommand.setName((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"name")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)ColorSuggestions.INSTANCE).executes(context -> NameCommand.setNameWithColor((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"color")))).then(class_2170.method_9244((String)"visibility", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)NameVisibilitySuggestions.INSTANCE).executes(context -> NameCommand.setNameWithColorAndVisibility((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"color"), StringArgumentType.getString((CommandContext)context, (String)"visibility"))))))))).then(class_2170.method_9247((String)"color").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)ColorSuggestions.INSTANCE).executes(context -> NameCommand.setNameColor((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"color"))))))).then(class_2170.method_9247((String)"visibility").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)"visibility", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)NameVisibilitySuggestions.INSTANCE).executes(context -> NameCommand.setNameVisibility((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"visibility"))))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> NameCommand.clearName((class_2168)context.getSource(), EasyNPCArgument.getEntity((CommandContext<class_2168>)context, "npc_target")))));
    }

    private static int setName(class_2168 context, EasyNPC<?> easyNPC, String name) {
        if (easyNPC == null || name == null) {
            return 0;
        }
        if (NameHandler.setCustomName(easyNPC, name, -1, NameVisibilityType.ALWAYS)) {
            return NameCommand.sendSuccessMessage(context, "Set name of " + String.valueOf(easyNPC) + " to " + name);
        }
        return 0;
    }

    private static int setNameWithColor(class_2168 context, EasyNPC<?> easyNPC, String name, String colorName) {
        int color;
        if (easyNPC == null || name == null || colorName == null) {
            return 0;
        }
        class_124 chatFormatting = NameCommand.parseChatFormatting(colorName);
        if (chatFormatting == null) {
            return NameCommand.sendFailureMessage(context, "Invalid color: " + colorName);
        }
        int n = color = chatFormatting.method_532() != null ? chatFormatting.method_532() : -1;
        if (NameHandler.setCustomName(easyNPC, name, color, NameVisibilityType.ALWAYS)) {
            return NameCommand.sendSuccessMessage(context, "Set name of " + String.valueOf(easyNPC) + " to " + name + " with color " + chatFormatting.name().toLowerCase());
        }
        return 0;
    }

    private static int setNameWithColorAndVisibility(class_2168 context, EasyNPC<?> easyNPC, String name, String colorName, String visibilityName) {
        int color;
        if (easyNPC == null || name == null || colorName == null || visibilityName == null) {
            return 0;
        }
        class_124 chatFormatting = NameCommand.parseChatFormatting(colorName);
        if (chatFormatting == null) {
            return NameCommand.sendFailureMessage(context, "Invalid color: " + colorName);
        }
        NameVisibilityType visibility = NameCommand.parseNameVisibilityType(visibilityName);
        if (visibility == null) {
            return NameCommand.sendFailureMessage(context, "Invalid visibility: " + visibilityName);
        }
        int n = color = chatFormatting.method_532() != null ? chatFormatting.method_532() : -1;
        if (NameHandler.setCustomName(easyNPC, name, color, visibility)) {
            return NameCommand.sendSuccessMessage(context, "Set name of " + String.valueOf(easyNPC) + " to " + name + " with color " + chatFormatting.name().toLowerCase() + " and visibility " + visibility.name().toLowerCase());
        }
        return 0;
    }

    private static int setNameColor(class_2168 context, EasyNPC<?> easyNPC, String colorName) {
        int color;
        if (easyNPC == null || colorName == null) {
            return 0;
        }
        class_2561 currentName = easyNPC.getEntity().method_5797();
        if (currentName == null) {
            return NameCommand.sendFailureMessage(context, "NPC has no custom name set. Use 'name set' first.");
        }
        class_124 chatFormatting = NameCommand.parseChatFormatting(colorName);
        if (chatFormatting == null) {
            return NameCommand.sendFailureMessage(context, "Invalid color: " + colorName);
        }
        String nameText = currentName.getString();
        boolean isVisible = easyNPC.getEntity().method_5807();
        NameVisibilityType visibility = isVisible ? NameVisibilityType.ALWAYS : NameVisibilityType.NEVER;
        int n = color = chatFormatting.method_532() != null ? chatFormatting.method_532() : -1;
        if (NameHandler.setCustomName(easyNPC, nameText, color, visibility)) {
            return NameCommand.sendSuccessMessage(context, "Set color of " + String.valueOf(easyNPC) + " name to " + chatFormatting.name().toLowerCase());
        }
        return 0;
    }

    private static int setNameVisibility(class_2168 context, EasyNPC<?> easyNPC, String visibilityName) {
        if (easyNPC == null || visibilityName == null) {
            return 0;
        }
        class_2561 currentName = easyNPC.getEntity().method_5797();
        if (currentName == null) {
            return NameCommand.sendFailureMessage(context, "NPC has no custom name set. Use 'name set' first.");
        }
        NameVisibilityType visibility = NameCommand.parseNameVisibilityType(visibilityName);
        if (visibility == null) {
            return NameCommand.sendFailureMessage(context, "Invalid visibility: " + visibilityName);
        }
        String nameText = currentName.getString();
        if (NameHandler.setCustomName(easyNPC, nameText, -1, visibility)) {
            return NameCommand.sendSuccessMessage(context, "Set visibility of " + String.valueOf(easyNPC) + " name to " + visibility.name().toLowerCase());
        }
        return 0;
    }

    private static int clearName(class_2168 context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        if (NameHandler.setCustomName(easyNPC, "", -1, NameVisibilityType.NEVER)) {
            return NameCommand.sendSuccessMessage(context, "Cleared name of " + String.valueOf(easyNPC));
        }
        return 0;
    }

    private static class_124 parseChatFormatting(String colorName) {
        try {
            return class_124.valueOf((String)colorName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static NameVisibilityType parseNameVisibilityType(String visibilityName) {
        try {
            return NameVisibilityType.valueOf(visibilityName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

