/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ProgressionDataCapable;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class ProgressionCommand
extends Command {
    private static final String LEVEL_ARG = "level";
    private static final String XP_ARG = "xp";
    private static final String ENABLED_ARG = "enabled";

    private ProgressionCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"progression").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> ProgressionCommand.getProgression((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target")))))).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9247((String)LEVEL_ARG).then(class_2170.method_9244((String)LEVEL_ARG, (ArgumentType)IntegerArgumentType.integer((int)1, (int)60)).executes(context -> ProgressionCommand.setLevel((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), IntegerArgumentType.getInteger((CommandContext)context, (String)LEVEL_ARG)))))).then(class_2170.method_9247((String)XP_ARG).then(class_2170.method_9244((String)XP_ARG, (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ProgressionCommand.setExperience((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), IntegerArgumentType.getInteger((CommandContext)context, (String)XP_ARG)))))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9247((String)XP_ARG).then(class_2170.method_9244((String)XP_ARG, (ArgumentType)IntegerArgumentType.integer()).executes(context -> ProgressionCommand.addExperience((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), IntegerArgumentType.getInteger((CommandContext)context, (String)XP_ARG)))))))).then(class_2170.method_9247((String)"scaling").then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)ENABLED_ARG, (ArgumentType)BoolArgumentType.bool()).executes(context -> ProgressionCommand.setAttributeScaling((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), BoolArgumentType.getBool((CommandContext)context, (String)ENABLED_ARG))))));
    }

    private static int getProgression(class_2168 context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        ProgressionDataCapable progressionData = easyNPC.getEasyNPCProgressionData();
        if (progressionData == null) {
            return ProgressionCommand.sendFailureMessage(context, "No progression data available for " + String.valueOf(easyNPC));
        }
        return ProgressionCommand.sendSuccessMessage(context, String.format("%s: Level %d | XP: %d/%d (%d, %.1f%%) | Attribute Scaling: %s", easyNPC, progressionData.getExperienceLevel(), progressionData.getExperience(), progressionData.getExperienceForNextLevel(), progressionData.getExperienceProgressToNextLevel(), Float.valueOf(progressionData.getProgressPercentageToNextLevel()), progressionData.isAttributeScalingEnabled() ? "Enabled" : "Disabled"));
    }

    private static int setLevel(class_2168 context, EasyNPC<?> easyNPC, int level) {
        if (easyNPC == null) {
            return 0;
        }
        ProgressionDataCapable progressionData = easyNPC.getEasyNPCProgressionData();
        if (progressionData == null) {
            return ProgressionCommand.sendFailureMessage(context, "No progression data available for " + String.valueOf(easyNPC));
        }
        int oldLevel = progressionData.getExperienceLevel();
        progressionData.setExperienceLevel(level);
        return ProgressionCommand.sendSuccessMessage(context, String.format("%s level changed from %d to %d (XP: %d)", easyNPC, oldLevel, level, progressionData.getExperience()));
    }

    private static int setExperience(class_2168 context, EasyNPC<?> easyNPC, int xp) {
        if (easyNPC == null) {
            return ProgressionCommand.sendFailureMessage(context, "No NPC found for the given target");
        }
        ProgressionDataCapable progressionData = easyNPC.getEasyNPCProgressionData();
        if (progressionData == null) {
            return ProgressionCommand.sendFailureMessage(context, "No progression data available for " + String.valueOf(easyNPC));
        }
        int oldXp = progressionData.getExperience();
        int oldLevel = progressionData.getExperienceLevel();
        progressionData.setExperience(xp);
        int newLevel = progressionData.getExperienceLevel();
        Object message = String.format("%s XP changed from %d to %d", easyNPC, oldXp, xp);
        if (oldLevel != newLevel) {
            message = (String)message + String.format(" (Level: %d \u2192 %d)", oldLevel, newLevel);
        }
        return ProgressionCommand.sendSuccessMessage(context, (String)message);
    }

    private static int addExperience(class_2168 context, EasyNPC<?> easyNPC, int xpAmount) {
        if (easyNPC == null) {
            return 0;
        }
        ProgressionDataCapable progressionData = easyNPC.getEasyNPCProgressionData();
        if (progressionData == null) {
            return ProgressionCommand.sendFailureMessage(context, "No progression data available for " + String.valueOf(easyNPC));
        }
        int oldXp = progressionData.getExperience();
        int oldLevel = progressionData.getExperienceLevel();
        progressionData.addExperience(xpAmount);
        Object message = String.format("%s %d XP to %s (%d \u2192 %d)", xpAmount >= 0 ? "Added" : "Removed", Math.abs(xpAmount), easyNPC, oldXp, progressionData.getExperience());
        int newLevel = progressionData.getExperienceLevel();
        if (oldLevel != newLevel) {
            message = (String)message + String.format(" | Level: %d \u2192 %d", oldLevel, newLevel);
        }
        return ProgressionCommand.sendSuccessMessage(context, (String)message);
    }

    private static int setAttributeScaling(class_2168 context, EasyNPC<?> easyNPC, boolean enabled) {
        if (easyNPC == null) {
            return 0;
        }
        ProgressionDataCapable progressionData = easyNPC.getEasyNPCProgressionData();
        if (progressionData == null) {
            return ProgressionCommand.sendFailureMessage(context, "No progression data available for " + String.valueOf(easyNPC));
        }
        progressionData.setAttributeScalingEnabled(enabled);
        return ProgressionCommand.sendSuccessMessage(context, String.format("%s attribute scaling %s (Level: %d)", easyNPC, enabled ? ENABLED_ARG : "disabled", progressionData.getExperienceLevel()));
    }
}

