/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.ReloadHandler;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class ReloadCommand
extends Command {
    private ReloadCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(cs -> cs.method_9259(0))).then(class_2170.method_9244((String)"npc_targets", (ArgumentType)EasyNPCArgument.npc()).executes(context -> ReloadCommand.reload((class_2168)context.getSource(), EasyNPCArgument.getEntitiesWithAccess((CommandContext<class_2168>)context, "npc_targets"))));
    }

    private static int reload(class_2168 context, Collection<? extends EasyNPC<?>> easyNPCs) {
        int reloadedEntities = 0;
        for (EasyNPC<?> easyNPC : easyNPCs) {
            UUID uuid = easyNPC.getEntityUUID();
            if (AccessManager.hasAccess(context, uuid)) {
                if (!ReloadHandler.reloadNPC(easyNPC, context.method_9225())) continue;
                ++reloadedEntities;
                continue;
            }
            ReloadCommand.sendFailureMessage(context, "You are not allowed to reload the Easy NPC " + String.valueOf(uuid) + " !");
        }
        if (reloadedEntities == 1) {
            EasyNPC<?> easyNPC = easyNPCs.iterator().next();
            return ReloadCommand.sendSuccessMessage(context, "Reloaded Easy NPC " + easyNPC.getEntity().method_5476().getString() + " !");
        }
        if (reloadedEntities > 1) {
            return ReloadCommand.sendSuccessMessage(context, "Reloaded " + reloadedEntities + " of " + easyNPCs.size() + " selected Easy NPCs!");
        }
        return ReloadCommand.sendFailureMessage(context, "Nothing to reload!");
    }
}

