/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.handler.SkinHandler;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class SkinCommand
extends Command {
    private SkinCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skin").requires(cs -> cs.method_9259(0))).then(class_2170.method_9247((String)"set").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"variant").requires(commandSourceStack -> commandSourceStack.method_9259(0))).then(class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)"variant", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            EasyNPC<?> easyNPC = EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target");
            if (easyNPC instanceof EasyNPCBase) {
                Enum[] variants;
                EasyNPCBase easyNPCBase = (EasyNPCBase)easyNPC;
                for (Enum variant : variants = easyNPCBase.getSkinVariantTypes()) {
                    builder.suggest(variant.name());
                }
            }
            return builder.buildFuture();
        }).executes(context -> SkinCommand.setDefaultSkinVariant((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"variant")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"layer").requires(commandSourceStack -> commandSourceStack.method_9259(0))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> SkinCommand.getLayerStatus((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target")))).then(class_2170.method_9247((String)"disable").executes(context -> SkinCommand.disableLayers((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"))))).then(class_2170.method_9247((String)"enable").executes(context -> SkinCommand.enableLayers((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"))))));
    }

    private static int setDefaultSkinVariant(class_2168 context, EasyNPC<?> easyNPC, String variant) {
        if (easyNPC == null || variant == null || variant.isEmpty()) {
            return 0;
        }
        if (!SkinHandler.setSkin(easyNPC, SkinDataEntry.createDefaultSkin(variant))) {
            return SkinCommand.sendFailureMessage(context, "Failed to set skin variant " + variant + " for EasyNPC " + String.valueOf(easyNPC));
        }
        return SkinCommand.sendSuccessMessage(context, "Successfully set skin variant " + variant + " for EasyNPC " + String.valueOf(easyNPC));
    }

    private static int setLayers(class_2168 context, EasyNPC<?> easyNPC, boolean enabled) {
        if (easyNPC == null) {
            return SkinCommand.sendFailureMessage(context, "Invalid EasyNPC target");
        }
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            return SkinCommand.sendFailureMessage(context, "Invalid EasyNPC skin data");
        }
        if (!SkinHandler.setSkin(easyNPC, skinData.getSkinDataEntry().withDisableLayers(!enabled))) {
            return SkinCommand.sendFailureMessage(context, "Failed to update layers for EasyNPC");
        }
        String action = enabled ? "enabled" : "disabled";
        String entityName = easyNPC.getEntity().method_5476().getString();
        return SkinCommand.sendSuccessMessage(context, "Successfully " + action + " layers for EasyNPC " + entityName);
    }

    private static int disableLayers(class_2168 context, EasyNPC<?> easyNPC) {
        return SkinCommand.setLayers(context, easyNPC, false);
    }

    private static int enableLayers(class_2168 context, EasyNPC<?> easyNPC) {
        return SkinCommand.setLayers(context, easyNPC, true);
    }

    private static int getLayerStatus(class_2168 context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return SkinCommand.sendFailureMessage(context, "Invalid EasyNPC target");
        }
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            return SkinCommand.sendFailureMessage(context, "EasyNPC has no skin data");
        }
        boolean layersDisabled = skinData.getSkinDataEntry().disableLayers();
        String status = layersDisabled ? "disabled" : "enabled";
        String entityName = easyNPC.getEntity().method_5476().getString();
        return SkinCommand.sendSuccessMessage(context, "Layers are currently " + status + " for EasyNPC " + entityName);
    }
}

