/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.access.SpawnerAccessHelper;
import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.commands.Command;
import java.util.List;
import net.minecraft.class_1917;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2636;

public class SpawnerCommand
extends Command {
    private SpawnerCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return class_2170.method_9247((String)"spawner").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(cs -> cs.method_9259(2))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"parameter", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(List.of("Delay", "MinSpawnDelay", "MaxSpawnDelay", "SpawnCount", "MaxNearbyEntities", "RequiredPlayerRange", "SpawnRange"), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> SpawnerCommand.setSpawnerValue((class_2168)context.getSource(), class_2262.method_9696((CommandContext)context, (String)"target"), StringArgumentType.getString((CommandContext)context, (String)"parameter"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))));
    }

    private static int setSpawnerValue(class_2168 context, class_2338 blockPos, String parameter, int value) {
        class_2586 blockEntity = context.method_9225().method_8321(blockPos);
        class_1917 spawner = null;
        if (blockEntity instanceof class_2636) {
            class_2636 spawnerBlockEntity = (class_2636)blockEntity;
            spawner = spawnerBlockEntity.method_11390();
        } else if (blockEntity instanceof EasyNPCSpawnerBlockEntity) {
            EasyNPCSpawnerBlockEntity easyNPCSpawnerBlockEntity = (EasyNPCSpawnerBlockEntity)blockEntity;
            spawner = easyNPCSpawnerBlockEntity.getSpawner();
        }
        if (spawner == null) {
            return SpawnerCommand.sendFailureMessage(context, "No valid spawner found at " + String.valueOf(blockPos));
        }
        if (!(spawner instanceof SpawnerAccessHelper)) {
            return SpawnerCommand.sendFailureMessage(context, "Spawner does not support direct access (mixin not applied?)");
        }
        SpawnerAccessHelper spawnerAccess = (SpawnerAccessHelper)spawner;
        switch (parameter) {
            case "Delay": {
                spawnerAccess.setSpawnDelay(value);
                break;
            }
            case "MinSpawnDelay": {
                spawnerAccess.setMinSpawnDelay(value);
                break;
            }
            case "MaxSpawnDelay": {
                spawnerAccess.setMaxSpawnDelay(value);
                break;
            }
            case "SpawnCount": {
                spawnerAccess.setSpawnCount(value);
                break;
            }
            case "MaxNearbyEntities": {
                spawnerAccess.setMaxNearbyEntities(value);
                break;
            }
            case "RequiredPlayerRange": {
                spawnerAccess.setRequiredPlayerRange(value);
                break;
            }
            case "SpawnRange": {
                spawnerAccess.setSpawnRange(value);
                break;
            }
            default: {
                return SpawnerCommand.sendFailureMessage(context, "Invalid parameter " + parameter + " for spawner at " + String.valueOf(blockPos));
            }
        }
        blockEntity.method_5431();
        return SpawnerCommand.sendSuccessMessage(context, "Set " + parameter + " to " + value + " for spawner at " + String.valueOf(blockPos));
    }
}

