/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands.objectives;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveDataCapable;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;

public class AttackObjective
extends Command {
    private static final String OBJECTIVE_NAME = "attack";
    private static final String TARGET_ARGUMENT = "target";
    private static final SuggestionProvider<class_2168> SUGGEST_ATTACK_TARGETS = (context, builder) -> class_2172.method_9265((Iterable)Arrays.stream(ObjectiveType.values()).filter(objectiveType -> objectiveType.name().startsWith("ATTACK_") || objectiveType == ObjectiveType.HURT_BY_TARGET || objectiveType == ObjectiveType.OWNER_HURT_BY_TARGET).map(AttackObjective::getFriendlyTargetName).collect(Collectors.toList()), (SuggestionsBuilder)builder);

    private AttackObjective() {
    }

    public static ArgumentBuilder<class_2168, ?> registerRemove() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)OBJECTIVE_NAME).then(class_2170.method_9247((String)TARGET_ARGUMENT).then(class_2170.method_9244((String)TARGET_ARGUMENT, (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ATTACK_TARGETS).executes(context -> AttackObjective.removeAttackTargetObjective((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)TARGET_ARGUMENT)))))).executes(context -> AttackObjective.remove((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target")));
    }

    public static ArgumentBuilder<class_2168, ?> registerList() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)OBJECTIVE_NAME).then(class_2170.method_9247((String)TARGET_ARGUMENT).executes(context -> AttackObjective.list((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"))))).executes(context -> AttackObjective.list((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target")));
    }

    public static ArgumentBuilder<class_2168, ?> registerSet() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)OBJECTIVE_NAME).then(class_2170.method_9247((String)TARGET_ARGUMENT).then(class_2170.method_9244((String)TARGET_ARGUMENT, (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ATTACK_TARGETS).executes(context -> AttackObjective.setAttackTargetObjective((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)TARGET_ARGUMENT)))))).executes(context -> AttackObjective.set((class_2168)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_target")));
    }

    public static int remove(class_2168 context, EasyNPC<?> easyNPC) {
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData == null || !objectiveData.hasObjectives()) {
            return AttackObjective.sendFailureMessageNoObjectiveData(context, easyNPC);
        }
        boolean removedAny = false;
        for (ObjectiveType objectiveType : ObjectiveType.values()) {
            if (!objectiveType.name().startsWith("ATTACK_") && objectiveType != ObjectiveType.HURT_BY_TARGET && objectiveType != ObjectiveType.OWNER_HURT_BY_TARGET || !objectiveData.removeCustomObjective(objectiveType)) continue;
            removedAny = true;
        }
        if (removedAny) {
            return AttackObjective.sendSuccessMessage(context, "Removed all attack objectives for " + String.valueOf(easyNPC));
        }
        return AttackObjective.sendFailureMessage(context, "No attack objectives found for " + String.valueOf(easyNPC));
    }

    public static int removeAttackTargetObjective(class_2168 context, EasyNPC<?> easyNPC, String targetName) {
        ObjectiveType objectiveType = AttackObjective.getObjectiveTypeFromFriendlyName(targetName);
        if (objectiveType == null) {
            return AttackObjective.sendFailureMessage(context, "Unknown attack target type: " + targetName);
        }
        ObjectiveDataCapable<?> objectiveData = AttackObjective.getAttackObjectiveData(context, easyNPC);
        if (objectiveData == null) {
            return 0;
        }
        if (!objectiveData.removeCustomObjective(objectiveType)) {
            return AttackObjective.sendFailureMessage(context, "Error removing attack target " + targetName + " for " + String.valueOf(easyNPC));
        }
        return AttackObjective.sendSuccessMessage(context, "Removed attack target " + targetName + " for " + String.valueOf(easyNPC));
    }

    public static int list(class_2168 context, EasyNPC<?> easyNPC) {
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData == null || !objectiveData.hasObjectives()) {
            return AttackObjective.sendFailureMessageNoObjectiveData(context, easyNPC);
        }
        AttackObjective.sendSuccessMessage(context, "Attack targets for " + String.valueOf(easyNPC) + ":");
        for (ObjectiveType objectiveType : ObjectiveType.values()) {
            if (!objectiveType.name().startsWith("ATTACK_")) continue;
            objectiveData.getObjectiveEntry(objectiveType).ifPresent(objective -> AttackObjective.sendSuccessMessage(context, "> " + AttackObjective.getFriendlyTargetName(objective.getType())));
        }
        objectiveData.getObjectiveEntry(ObjectiveType.OWNER_HURT_BY_TARGET).ifPresent(objective -> AttackObjective.sendSuccessMessage(context, "> " + AttackObjective.getFriendlyTargetName(objective.getType()) + " (Protect Owner)"));
        objectiveData.getObjectiveEntry(ObjectiveType.HURT_BY_TARGET).ifPresent(objective -> AttackObjective.sendSuccessMessage(context, "> " + AttackObjective.getFriendlyTargetName(objective.getType()) + " (Defend Self)"));
        return 1;
    }

    public static int set(class_2168 context, EasyNPC<?> easyNPC) {
        return AttackObjective.sendSuccessMessage(context, "Usage: /objective set attack target <target_type>");
    }

    public static int setAttackTargetObjective(class_2168 context, EasyNPC<?> easyNPC, String targetName) {
        ObjectiveType objectiveType = AttackObjective.getObjectiveTypeFromFriendlyName(targetName);
        if (objectiveType == null) {
            return AttackObjective.sendFailureMessage(context, "Unknown attack target type: " + targetName);
        }
        ObjectiveDataCapable<?> objectiveData = AttackObjective.getObjectiveData(context, easyNPC);
        if (objectiveData == null) {
            return 0;
        }
        ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(objectiveType);
        if (!objectiveData.addOrUpdateCustomObjective(objectiveDataEntry)) {
            return AttackObjective.sendFailureMessage(context, "Error adding or updating attack target!");
        }
        return AttackObjective.sendSuccessMessage(context, "Attack target " + targetName + " added for " + String.valueOf(easyNPC));
    }

    private static ObjectiveDataCapable<?> getObjectiveData(class_2168 context, EasyNPC<?> easyNPC) {
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData == null || !objectiveData.hasObjectives()) {
            AttackObjective.sendFailureMessageNoObjectiveData(context, easyNPC);
            return null;
        }
        return objectiveData;
    }

    private static ObjectiveDataCapable<?> getAttackObjectiveData(class_2168 context, EasyNPC<?> easyNPC) {
        ObjectiveDataCapable<?> objectiveData = AttackObjective.getObjectiveData(context, easyNPC);
        if (objectiveData == null) {
            return null;
        }
        boolean hasAnyAttackObjective = false;
        for (ObjectiveType objectiveType : ObjectiveType.values()) {
            if (!objectiveType.name().startsWith("ATTACK_") && objectiveType != ObjectiveType.HURT_BY_TARGET && objectiveType != ObjectiveType.OWNER_HURT_BY_TARGET || !objectiveData.hasObjective(objectiveType)) continue;
            hasAnyAttackObjective = true;
            break;
        }
        if (!hasAnyAttackObjective) {
            AttackObjective.sendFailureMessageNoObjectiveData(context, easyNPC, OBJECTIVE_NAME);
            return null;
        }
        return objectiveData;
    }

    private static String getFriendlyTargetName(ObjectiveType objectiveType) {
        if (objectiveType == null) {
            return "";
        }
        if (objectiveType == ObjectiveType.HURT_BY_TARGET) {
            return "defend_self";
        }
        if (objectiveType == ObjectiveType.OWNER_HURT_BY_TARGET) {
            return "protect_owner";
        }
        if (objectiveType.name().startsWith("ATTACK_")) {
            return objectiveType.name().substring(7).toLowerCase();
        }
        return objectiveType.name().toLowerCase();
    }

    private static ObjectiveType getObjectiveTypeFromFriendlyName(String targetName) {
        if (targetName == null || targetName.isEmpty()) {
            return null;
        }
        if ("defend_self".equals(targetName = targetName.toLowerCase())) {
            return ObjectiveType.HURT_BY_TARGET;
        }
        if ("protect_owner".equals(targetName)) {
            return ObjectiveType.OWNER_HURT_BY_TARGET;
        }
        try {
            return ObjectiveType.valueOf("ATTACK_" + targetName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

