/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import de.markusbordihn.easynpc.validator.NameValidator;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3312;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayersUtils {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String TEXTURES_STRING = "textures";
    private static final String SESSION_PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s";
    private static final String API_PROFILE_URL = "https://api.mojang.com/users/profiles/minecraft/%s";
    private static final Map<String, UUID> userUUIDCache = new ConcurrentHashMap<String, UUID>();
    private static final Map<UUID, Long> sessionServerRequestProtection = new ConcurrentHashMap<UUID, Long>();
    private static final long SESSION_REQUEST_COOLDOWN = 1000L;

    protected PlayersUtils() {
    }

    public static UUID getUserUUID(MinecraftServer server, String username) {
        if (username == null || username.isEmpty() || !NameValidator.isValidPlayerName(username)) {
            log.error("Unable to get user UUID with invalid username: {}", (Object)username);
            return null;
        }
        UUID uuid = PlayersUtils.getUUIDfromString(username);
        if (uuid != null) {
            return uuid;
        }
        if (server != null) {
            try {
                class_3312 gameProfileCache = server.method_3793();
                Optional optionalGameProfile = gameProfileCache.method_14515(username);
                if (optionalGameProfile.isPresent()) {
                    UUID serverUUID = ((GameProfile)optionalGameProfile.get()).getId();
                    log.debug("Found user {} with UUID {} from server cache", (Object)username, (Object)serverUUID);
                    userUUIDCache.put(username, serverUUID);
                    return serverUUID;
                }
            }
            catch (Exception e) {
                log.debug("Unable to get UUID from server cache for {}: {}", (Object)username, (Object)e.getMessage());
            }
        }
        if (userUUIDCache.containsKey(username)) {
            UUID cachedUUID = userUUIDCache.get(username);
            if (cachedUUID != null) {
                log.debug("Found user {} with UUID {} from local cache", (Object)username, (Object)cachedUUID);
            }
            return cachedUUID;
        }
        try {
            String url = String.format(API_PROFILE_URL, username);
            String json = IOUtils.toString((URL)new URL(url), (Charset)StandardCharsets.UTF_8);
            JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
            String uuidString = jsonObject.get("id").getAsString();
            if (uuidString == null || uuidString.isEmpty()) {
                log.error("Unable to get user UUID with invalid response: {}", (Object)json);
                userUUIDCache.put(username, null);
                return null;
            }
            String formattedUUID = uuidString.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
            UUID userUUID = UUID.fromString(formattedUUID);
            log.debug("Found user {} with UUID {} from online API", (Object)username, (Object)userUUID);
            userUUIDCache.put(username, userUUID);
            return userUUID;
        }
        catch (IOException e) {
            log.error("Unable to get UUID from user {}: {}", (Object)username, (Object)e.getMessage());
            userUUIDCache.put(username, null);
            return null;
        }
    }

    public static UUID getUUIDfromString(String uuidString) {
        if (uuidString == null || uuidString.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    public static UUID getUserUUID(String username) {
        return PlayersUtils.getUserUUID(null, username);
    }

    public static String getUserTexture(UUID userUUID) {
        long currentTime = System.currentTimeMillis();
        Long lastRequest = sessionServerRequestProtection.get(userUUID);
        if (lastRequest != null && currentTime - lastRequest < 1000L) {
            log.debug("Ignoring duplicate session server request for {} (within cooldown period)", (Object)userUUID);
            return null;
        }
        Long existingRequest = sessionServerRequestProtection.putIfAbsent(userUUID, currentTime);
        if (existingRequest != null && currentTime - existingRequest < 1000L) {
            log.debug("Ignoring duplicate session server request for {} (another thread is handling it)", (Object)userUUID);
            return null;
        }
        String sessionURL = String.format(SESSION_PROFILE_URL, userUUID);
        try {
            String data = IOUtils.toString((URL)new URL(sessionURL), (Charset)StandardCharsets.UTF_8);
            if (data == null || data.isEmpty()) {
                log.error("Unable to get user texture with {}", (Object)sessionURL);
                return null;
            }
            return PlayersUtils.getUserTextureFromSessionResponse(data);
        }
        catch (IOException ioException) {
            log.error("Unable to get user texture with {}:", (Object)sessionURL, (Object)ioException);
            return null;
        }
    }

    public static String getUserTextureFromSessionResponse(String data) {
        JsonObject jsonObject = PlayersUtils.getJsonObject(data);
        if (jsonObject == null || !jsonObject.has("properties")) {
            log.error("Unable to get valid JSON data from session response: {}", (Object)data);
            return "";
        }
        JsonArray properties = jsonObject.getAsJsonArray("properties");
        log.debug("getUserTextureFromSessionRequest: {}", (Object)properties);
        for (JsonElement property : properties) {
            JsonObject propertyObject = property.getAsJsonObject();
            if (!propertyObject.has("name") || !TEXTURES_STRING.equals(propertyObject.get("name").getAsString()) || !propertyObject.has("value")) continue;
            try {
                String textureData = new String(Base64.getDecoder().decode(propertyObject.get("value").getAsString()));
                JsonObject textureDataObject = PlayersUtils.getJsonObject(textureData);
                log.debug("getUserTextureFromTextureData: {}", (Object)textureDataObject);
                String userTexture = PlayersUtils.extractUserTextureUrl(textureDataObject);
                String userTextureModel = PlayersUtils.extractUserTextureModel(textureDataObject);
                log.debug("Found user texture {} with model {} ...", (Object)userTexture, (Object)userTextureModel);
                return userTexture;
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to decode Base64 texture data: {}", (Object)e.getMessage());
                return "";
            }
        }
        log.error("Unable to get user texture from session response: {}", (Object)data);
        return "";
    }

    private static String extractUserTextureUrl(JsonObject textureDataObject) {
        JsonObject skinObject;
        JsonObject textureObject;
        if (textureDataObject != null && textureDataObject.has(TEXTURES_STRING) && (textureObject = textureDataObject.getAsJsonObject(TEXTURES_STRING)).has("SKIN") && (skinObject = textureObject.getAsJsonObject("SKIN")).has("url")) {
            return skinObject.get("url").getAsString();
        }
        log.error("Unable to get user texture from texture data: {}", (Object)textureDataObject);
        return "";
    }

    private static String extractUserTextureModel(JsonObject textureDataObject) {
        JsonObject metaDataObject;
        JsonObject skinObject;
        JsonObject textureObject;
        if (textureDataObject != null && textureDataObject.has(TEXTURES_STRING) && (textureObject = textureDataObject.getAsJsonObject(TEXTURES_STRING)).has("SKIN") && (skinObject = textureObject.getAsJsonObject("SKIN")).has("metadata") && (metaDataObject = skinObject.getAsJsonObject("metadata")).has("model")) {
            return metaDataObject.get("model").getAsString();
        }
        log.debug("Unable to get user texture model from texture data, will use default: {}", (Object)textureDataObject);
        return "default";
    }

    public static JsonObject getJsonObject(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            JsonElement jsonElement = JsonParser.parseString((String)data);
            if (jsonElement != null && jsonElement.isJsonObject()) {
                return jsonElement.getAsJsonObject();
            }
        }
        catch (JsonParseException jsonParseException) {
            log.error("ERROR: Unable to parse json data: {}", (Object)data);
        }
        return null;
    }
}

