/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

public class SnbtFormatter {
    private static final String INDENT = "  ";
    private static final int MAX_DEPTH = 20;

    private SnbtFormatter() {
    }

    public static String format(String snbt) {
        String formatted;
        if (snbt == null || snbt.isEmpty()) {
            return snbt;
        }
        for (int depth = 0; depth < 20 && !(formatted = SnbtFormatter.formatSinglePass(snbt, depth)).equals(snbt); ++depth) {
            snbt = formatted;
        }
        return snbt;
    }

    private static String formatSinglePass(String snbt, int targetDepth) {
        FormattingContext context = new FormattingContext(snbt, targetDepth);
        int length = snbt.length();
        for (int index = 0; index < length; ++index) {
            context.updateCurrentPosition(index);
            if (context.handleStringCharacters()) continue;
            context.processStructureCharacter();
        }
        return context.getFormattedOutput();
    }

    private static boolean shouldToggleStringMode(char currentChar, char previousChar, boolean isInsideString, char activeQuoteChar) {
        if (previousChar == '\\') {
            return false;
        }
        if (!isInsideString) {
            return currentChar == '\"' || currentChar == '\'';
        }
        return currentChar == activeQuoteChar;
    }

    private static class FormattingContext {
        private final String inputSnbt;
        private final int inputLength;
        private final int targetDepth;
        private final StringBuilder formattedOutput;
        private final StringParsingState state;
        private char currentChar;
        private char nextChar;
        private char previousChar;
        private int currentIndex;

        public FormattingContext(String snbt, int targetDepth) {
            this.inputSnbt = snbt;
            this.inputLength = snbt.length();
            this.targetDepth = targetDepth;
            this.formattedOutput = new StringBuilder(snbt.length() * 2);
            this.state = new StringParsingState();
        }

        public void updateCurrentPosition(int index) {
            this.currentIndex = index;
            this.currentChar = this.inputSnbt.charAt(index);
            this.nextChar = this.getCharAtOrDefault(index + 1);
            this.previousChar = this.getCharAtOrDefault(index - 1);
        }

        public boolean handleStringCharacters() {
            if (this.state.handleQuoteCharacter(this.currentChar, this.previousChar)) {
                this.formattedOutput.append(this.currentChar);
                return true;
            }
            if (this.state.isInsideString()) {
                this.formattedOutput.append(this.currentChar);
                return true;
            }
            return false;
        }

        public void processStructureCharacter() {
            switch (this.currentChar) {
                case '{': {
                    this.handleOpenBrace();
                    break;
                }
                case '}': {
                    this.handleCloseBrace();
                    break;
                }
                case ',': {
                    this.handleComma();
                    break;
                }
                default: {
                    this.formattedOutput.append(this.currentChar);
                }
            }
        }

        private void handleOpenBrace() {
            this.formattedOutput.append(this.currentChar);
            this.state.increaseDepth();
            if (this.state.getCurrentDepth() == this.targetDepth + 1 && this.nextChar != '}') {
                this.formattedOutput.append('\n');
                this.appendIndent(this.state.getCurrentDepth());
            }
        }

        private void handleCloseBrace() {
            if (this.state.getCurrentDepth() == this.targetDepth + 1 && this.previousChar != '{') {
                this.formattedOutput.append('\n');
                this.appendIndent(this.state.getCurrentDepth() - 1);
            }
            this.formattedOutput.append(this.currentChar);
            this.state.decreaseDepth();
        }

        private void handleComma() {
            this.formattedOutput.append(this.currentChar);
            if (this.state.getCurrentDepth() == this.targetDepth + 1 && !this.isInsideArray(this.currentIndex)) {
                this.formattedOutput.append('\n');
                this.appendIndent(this.state.getCurrentDepth());
            }
        }

        private void appendIndent(int depth) {
            this.formattedOutput.append(SnbtFormatter.INDENT.repeat(Math.max(0, depth)));
        }

        private boolean isInsideArray(int position) {
            int arrayBracketDepth = 0;
            boolean isInsideString = false;
            char activeQuoteChar = '\u0000';
            for (int index = 0; index < position; ++index) {
                char charBeforeIndex;
                char charAtIndex = this.inputSnbt.charAt(index);
                if (SnbtFormatter.shouldToggleStringMode(charAtIndex, charBeforeIndex = this.getCharAtOrDefault(index - 1), isInsideString, activeQuoteChar)) {
                    isInsideString = !isInsideString;
                    activeQuoteChar = isInsideString ? charAtIndex : (char)'\u0000';
                    continue;
                }
                if (isInsideString) continue;
                if (charAtIndex == '[') {
                    ++arrayBracketDepth;
                    continue;
                }
                if (charAtIndex != 93) continue;
                --arrayBracketDepth;
            }
            return arrayBracketDepth > 0;
        }

        private char getCharAtOrDefault(int index) {
            return index >= 0 && index < this.inputLength ? this.inputSnbt.charAt(index) : (char)'\u0000';
        }

        public String getFormattedOutput() {
            return this.formattedOutput.toString();
        }
    }

    private static class StringParsingState {
        private int currentDepth = 0;
        private boolean isInsideString = false;
        private char activeQuoteChar = '\u0000';

        private StringParsingState() {
        }

        public boolean handleQuoteCharacter(char currentChar, char previousChar) {
            if (!SnbtFormatter.shouldToggleStringMode(currentChar, previousChar, this.isInsideString, this.activeQuoteChar)) {
                return false;
            }
            this.isInsideString = !this.isInsideString;
            this.activeQuoteChar = this.isInsideString ? currentChar : (char)'\u0000';
            return true;
        }

        public boolean isInsideString() {
            return this.isInsideString;
        }

        public int getCurrentDepth() {
            return this.currentDepth;
        }

        public void increaseDepth() {
            ++this.currentDepth;
        }

        public void decreaseDepth() {
            --this.currentDepth;
        }
    }
}

