/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class TextUtils {
    private static final String TRANSLATION_KEY_REGEXP = "^[\\w-]+(?:\\.[\\w-]+)*\\.[\\w-]+$";
    private static final Pattern TRANSLATION_KEY_PATTERN = Pattern.compile("^[\\w-]+(?:\\.[\\w-]+)*\\.[\\w-]+$");

    private TextUtils() {
    }

    public static boolean isTranslationKey(String text) {
        return text != null && !text.isEmpty() && TRANSLATION_KEY_PATTERN.matcher(text).matches();
    }

    public static class_2561 normalizeName(String name) {
        return TextComponent.getText(TextUtils.normalizeString(name));
    }

    public static String normalizeString(String string) {
        Object normalizedString = string.toLowerCase(Locale.ROOT).replace("_", " ").replace("-", " ");
        normalizedString = ((String)normalizedString).substring(0, 1).toUpperCase(Locale.ROOT) + ((String)normalizedString).substring(1);
        return normalizedString;
    }

    public static String normalizeString(String string, int maxSize) {
        return TextUtils.limitString(TextUtils.normalizeString(string), maxSize);
    }

    public static String limitString(String string, int maxSize) {
        if (string == null || string.isBlank()) {
            return string;
        }
        String trimmedString = string.trim();
        int stringLength = trimmedString.length();
        if (stringLength <= maxSize) {
            return trimmedString;
        }
        return trimmedString.substring(0, maxSize) + "\u2026";
    }

    public static class_2561 removeAction(class_2561 component) {
        class_5250 mutableComponent = component.method_27662().method_10862(component.method_10866().method_10958(null));
        for (class_2561 componentSibling : component.method_10855()) {
            mutableComponent.method_10852(TextUtils.removeAction(componentSibling));
        }
        return mutableComponent;
    }

    public static String convertToPascalCase(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.substring(0, 1).toUpperCase(Locale.ROOT) + TextUtils.convertToCamelCase(text.substring(1));
    }

    public static String convertToCamelCase(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean nextUpperCase = false;
        for (char character : text.toCharArray()) {
            if (character == '_' || character == ' ' || character == '-') {
                nextUpperCase = true;
                continue;
            }
            if (nextUpperCase) {
                stringBuilder.append(Character.toUpperCase(character));
                nextUpperCase = false;
                continue;
            }
            stringBuilder.append(Character.toLowerCase(character));
        }
        return stringBuilder.toString();
    }
}

