/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.block.entity;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import io.strikeknight57.bca.CobblemonAdditions;
import io.strikeknight57.bca.block.PokemonTrialSpawnerBlock;
import io.strikeknight57.bca.registry.CobblemonAdditionsBlockEntities;
import io.strikeknight57.bca.util.PokemonSpawnUtils;
import io.strikeknight57.bca.util.json.JSONReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public class PokemonTrialSpawnerBlockEntity
extends class_2586 {
    private static final int spawnTime = 40;
    private static final int spawnRange = 4;
    private static final int spawnCap = 6;
    private static final int cooldown = 72000;
    private int playerAvgLvl;
    private int spawnCount;
    private int ticksSinceLast;
    private long cooldownWorldTime;
    private boolean bricked = false;
    public String spawnerFile;
    public int verticalOffset = 0;
    private static int maxSpawnAtOnce = 2;
    private static boolean onCooldown = false;
    private class_3222 closestPlayer;
    private List<PokemonEntity> spawnedPokemon = new ArrayList<PokemonEntity>();

    public PokemonTrialSpawnerBlockEntity(class_2338 pos, class_2680 state) {
        super(CobblemonAdditionsBlockEntities.POKEMON_TRIAL_SPAWNER_ENTITY, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10582("spawner", this.spawnerFile);
        nbt.method_10569("vert_offset", this.verticalOffset);
        super.method_11007(nbt, registryLookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.spawnerFile = nbt.method_10558("spawner");
        this.verticalOffset = nbt.method_10550("vert_offset");
    }

    private static void checkTicks(class_1937 world, class_2338 blockPos, class_2680 blockState, PokemonTrialSpawnerBlockEntity entity) {
        int l;
        int k;
        int j;
        int c;
        int b;
        if (entity.ticksSinceLast <= 40) {
            return;
        }
        int detectionRange = 8;
        int a = blockPos.method_10263() - detectionRange;
        List nearbyMon = world.method_18023((class_5575)CobblemonEntities.POKEMON, new class_238(new class_243((double)a, (double)(b = blockPos.method_10264() - detectionRange), (double)(c = blockPos.method_10260() - detectionRange)), new class_243((double)(j = blockPos.method_10263() + detectionRange), (double)(k = blockPos.method_10264() + detectionRange), (double)(l = blockPos.method_10260() + detectionRange))), pokemonEntity -> pokemonEntity.method_35057() == null);
        if (nearbyMon.size() >= maxSpawnAtOnce) {
            return;
        }
        List<String> pokemonToSpawn = JSONReader.parseStrings("spawner/" + entity.spawnerFile, "id");
        if (pokemonToSpawn == null) {
            CobblemonAdditions.LOGGER.error("File or directory not found: '{}' for spawner at {}", (Object)entity.spawnerFile, (Object)blockPos);
            entity.bricked = true;
            return;
        }
        List<Integer> lvlsMin = JSONReader.parseIntegers("spawner/" + entity.spawnerFile, "levels.min");
        List<Integer> lvlsRange = JSONReader.parseIntegers("spawner/" + entity.spawnerFile, "levels.range");
        class_5819 random = world.method_8409();
        int randX = class_3532.method_32751((class_5819)random, (int)-4, (int)4);
        int randZ = class_3532.method_32751((class_5819)random, (int)-4, (int)4);
        int randPkmnID = PokemonSpawnUtils.weightSpawnID(world, pokemonToSpawn, JSONReader.parseIntegers("spawner/" + entity.spawnerFile, "weight"));
        class_2338 spawnPos = new class_2338(blockPos.method_10263() + randX, blockPos.method_10264() + entity.verticalOffset, blockPos.method_10260() + randZ);
        String pkmnName = pokemonToSpawn.get(randPkmnID).toLowerCase();
        int randLvl = class_3532.method_32751((class_5819)random, (int)lvlsMin.get(randPkmnID), (int)(entity.playerAvgLvl >= lvlsMin.get(randPkmnID) ? entity.playerAvgLvl + lvlsRange.get(randPkmnID) : lvlsMin.get(randPkmnID)));
        PokemonProperties properties = PokemonProperties.Companion.parse(pkmnName + " uncatchable=true");
        properties.setLevel(Integer.valueOf(randLvl));
        properties.setNature("rash");
        PokemonEntity pokemonEntity2 = properties.createEntity(world);
        pokemonEntity2.method_23327((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260());
        Pokemon pokemon = pokemonEntity2.getPokemon();
        pokemon.sendOut((class_3218)world, spawnPos.method_46558(), null, pkmnE -> null);
        ++entity.spawnCount;
        entity.spawnedPokemon.add(pokemonEntity2);
        entity.ticksSinceLast = 0;
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 blockState, PokemonTrialSpawnerBlockEntity entity) {
        if (!world.field_9236 && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (!entity.bricked && serverWorld.method_8510() % 20L == 0L) {
                for (int i = 0; i < entity.spawnedPokemon.size(); ++i) {
                    if (entity.spawnedPokemon.get(i).getPokemon().getCurrentHealth() > 0) continue;
                    entity.spawnedPokemon.remove(i);
                }
                if (onCooldown && world.method_8510() >= entity.cooldownWorldTime) {
                    onCooldown = false;
                    entity.spawnCount = 0;
                }
                if (entity.spawnCount >= 6 && entity.spawnedPokemon.isEmpty()) {
                    if (!onCooldown) {
                        entity.closestPlayer.method_7353(class_2561.method_30163((String)"Cleared all pokemon"), true);
                        PokemonTrialSpawnerBlock block = (PokemonTrialSpawnerBlock)world.method_8320(blockPos).method_26204();
                        block.togglePower(blockState, world, blockPos, null);
                        entity.cooldownWorldTime = world.method_8510() + 72000L;
                        onCooldown = true;
                    }
                    return;
                }
                double x = blockPos.method_10263();
                double y = blockPos.method_10264();
                double z = blockPos.method_10260();
                class_3222 player = null;
                if (serverWorld.method_18459(x, y, z, 16.0, true) == null) {
                    return;
                }
                player = (class_3222)serverWorld.method_18459(x, y, z, 16.0, true);
                if (entity.closestPlayer != player) {
                    PokemonTrialSpawnerBlockEntity.setClosestPlayer(player, entity);
                }
                PokemonTrialSpawnerBlockEntity.getPlayerAvgLvl(entity);
                PokemonTrialSpawnerBlockEntity.checkTicks(world, blockPos, blockState, entity);
                entity.ticksSinceLast += 10;
            }
        }
    }

    private static void getPlayerAvgLvl(PokemonTrialSpawnerBlockEntity entity) {
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(entity.closestPlayer);
        int partySize = 0;
        for (int i = 0; i < party.size(); ++i) {
            if (party.get(i) == null) continue;
            entity.playerAvgLvl += party.get(i).getLevel();
            ++partySize;
        }
        if (partySize != 0) {
            entity.playerAvgLvl = Math.round((float)entity.playerAvgLvl / (float)partySize);
        }
    }

    private static void setClosestPlayer(class_3222 player, PokemonTrialSpawnerBlockEntity entity) {
        entity.closestPlayer = player;
    }
}

