/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.fixers;

import io.strikeknight57.bca.fixers.PaintingOffsetFixer;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;

public class NBTScanner {
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_CYAN = "\u001b[36m";
    private static final String ANSI_BOLD = "\u001b[1m";

    public static void main(String[] args) {
        Path directory;
        if (args.length < 1) {
            NBTScanner.printUsage();
            System.exit(1);
        }
        String directoryPath = args[0];
        Boolean fixFlag = null;
        if (args.length >= 2) {
            if ("--fix".equals(args[1])) {
                fixFlag = true;
            } else if ("--no-fix".equals(args[1])) {
                fixFlag = false;
            } else {
                System.err.println("\u001b[31mError: Invalid flag. Use --fix or --no-fix (or omit to be prompted)\u001b[0m");
                NBTScanner.printUsage();
                System.exit(1);
            }
        }
        if (!Files.exists(directory = Paths.get(directoryPath, new String[0]), new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            System.err.println("\u001b[31mError: Directory does not exist: " + directoryPath + ANSI_RESET);
            System.exit(1);
        }
        try {
            NBTScanner.run(directory, fixFlag);
        }
        catch (IOException e) {
            System.err.println("\u001b[31mError: " + e.getMessage() + ANSI_RESET);
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void run(Path directory, Boolean fixFlag) throws IOException {
        void var7_14;
        List issues;
        System.out.println("\u001b[1m\u001b[36mScanning structure NBT files for painting offset issues...\u001b[0m");
        System.out.println("\u001b[36mDirectory: " + String.valueOf(directory.toAbsolutePath()) + ANSI_RESET);
        System.out.println();
        List<Path> nbtFiles = NBTScanner.findNBTFiles(directory);
        System.out.println("Found " + nbtFiles.size() + " NBT files");
        System.out.println();
        int totalFilesWithIssues = 0;
        int totalPaintingsWithIssues = 0;
        LinkedHashMap<Path, List> issuesByFile = new LinkedHashMap<Path, List>();
        for (Path path : nbtFiles) {
            try {
                class_2487 root = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
                issues = PaintingOffsetFixer.scanStructure(root);
                if (issues.isEmpty()) continue;
                ++totalFilesWithIssues;
                totalPaintingsWithIssues += issues.size();
                issuesByFile.put(path, issues);
            }
            catch (IOException e) {
                System.err.println("\u001b[31mError reading " + String.valueOf(path.getFileName()) + ": " + e.getMessage() + ANSI_RESET);
            }
        }
        if (totalFilesWithIssues == 0) {
            System.out.println("\u001b[32m\u001b[1m\u2713 No painting offset issues found!\u001b[0m");
            System.exit(0);
        }
        System.out.println("\u001b[31m\u001b[1m\u2717 Found painting offset issues:\u001b[0m");
        System.out.println();
        for (Map.Entry entry : issuesByFile.entrySet()) {
            Path file = (Path)entry.getKey();
            issues = (List)entry.getValue();
            String relativePath = directory.relativize(file).toString();
            System.out.println("\u001b[33m\u001b[1mFile: " + relativePath + ANSI_RESET);
            System.out.println("\u001b[33m  Paintings with issues: " + issues.size() + ANSI_RESET);
            for (PaintingOffsetFixer.PaintingAnalysis analysis : issues) {
                System.out.println("  \u2022 " + analysis.variant + " (facing " + analysis.facing + ")");
                System.out.println("    Issues: " + analysis.getIssueDescription());
                System.out.println("    Position: " + analysis.getPositionDescription());
            }
            System.out.println();
        }
        System.out.println("\u001b[31m\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u001b[0m");
        System.out.println("\u001b[31m\u001b[1mSummary:\u001b[0m");
        System.out.println("\u001b[31m  Files with issues: " + totalFilesWithIssues + ANSI_RESET);
        System.out.println("\u001b[31m  Paintings with issues: " + totalPaintingsWithIssues + ANSI_RESET);
        System.out.println("\u001b[31m\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u001b[0m");
        System.out.println();
        boolean shouldFix = false;
        if (fixFlag == null) {
            System.out.print("\u001b[33mWould you like to fix these issues? (y/N): \u001b[0m");
            Scanner scanner = new Scanner(System.in);
            String response = scanner.nextLine().trim().toLowerCase();
            shouldFix = response.equals("y") || response.equals("yes");
            scanner.close();
        } else {
            shouldFix = fixFlag;
        }
        if (!shouldFix) {
            System.out.println();
            System.out.println("\u001b[33mNo changes made. To fix these issues automatically, run: \u001b[1m./gradlew fixNBT\u001b[0m");
            System.exit(1);
        }
        System.out.println();
        System.out.println("\u001b[36mApplying fixes...\u001b[0m");
        System.out.println();
        boolean bl = false;
        int totalPaintingsFixed = 0;
        LinkedHashMap<Path, List<PaintingOffsetFixer.PaintingAnalysis>> fixesByFile = new LinkedHashMap<Path, List<PaintingOffsetFixer.PaintingAnalysis>>();
        for (Path nbtFile : issuesByFile.keySet()) {
            try {
                class_2487 root;
                List<PaintingOffsetFixer.PaintingAnalysis> fixes;
                Path backupFile = Paths.get(nbtFile.toString() + ".backup", new String[0]);
                if (!Files.exists(backupFile, new LinkOption[0])) {
                    Files.copy(nbtFile, backupFile, StandardCopyOption.REPLACE_EXISTING);
                }
                if ((fixes = PaintingOffsetFixer.fixStructure(root = class_2507.method_30613((Path)nbtFile, (class_2505)class_2505.method_53898()))).isEmpty()) continue;
                class_2507.method_30614((class_2487)root, (Path)nbtFile);
                ++var7_14;
                totalPaintingsFixed += fixes.size();
                fixesByFile.put(nbtFile, fixes);
                String relativePath = directory.relativize(nbtFile).toString();
                System.out.println("\u001b[32m\u2713 Fixed " + relativePath + " (" + fixes.size() + " paintings)\u001b[0m");
            }
            catch (IOException e) {
                System.err.println("\u001b[31mError processing " + String.valueOf(nbtFile.getFileName()) + ": " + e.getMessage() + ANSI_RESET);
            }
        }
        System.out.println();
        System.out.println("\u001b[32m\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u001b[0m");
        System.out.println("\u001b[32m\u001b[1m\u2713 Successfully fixed painting offsets!\u001b[0m");
        System.out.println("\u001b[32m  Files fixed: " + (int)var7_14 + ANSI_RESET);
        System.out.println("\u001b[32m  Paintings fixed: " + totalPaintingsFixed + ANSI_RESET);
        System.out.println("\u001b[32m  Backups created: .nbt.backup files\u001b[0m");
        System.out.println("\u001b[32m\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u001b[0m");
    }

    private static List<Path> findNBTFiles(Path directory) throws IOException {
        final ArrayList nbtFiles = new ArrayList();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.toString().endsWith(".nbt") && !file.toString().endsWith(".backup")) {
                    nbtFiles.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return nbtFiles.stream().sorted().collect(Collectors.toList());
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("  java NBTScanner <directory> [--fix|--no-fix]");
        System.out.println();
        System.out.println("Flags:");
        System.out.println("  --fix      Automatically fix issues without prompting");
        System.out.println("  --no-fix   Scan only, don't fix (useful for CI/CD)");
        System.out.println("  (none)     Scan and prompt user to fix");
        System.out.println();
        System.out.println("Gradle tasks:");
        System.out.println("  ./gradlew scanNBT  - Scan only (no fix)");
        System.out.println("  ./gradlew fixNBT   - Scan and fix automatically");
    }
}

