/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.fixers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class PaintingOffsetFixer {
    private static final double TOLERANCE = 0.01;
    private static final double CENTERING_THRESHOLD = 0.4;

    public static PaintingAnalysis identifyIssues(class_2487 entity) {
        if (!entity.method_10573("nbt", 10)) {
            return null;
        }
        class_2487 nbt = entity.method_10562("nbt");
        String entityId = nbt.method_10558("id");
        if (!"minecraft:painting".equals(entityId)) {
            return null;
        }
        if (!(entity.method_10573("blockPos", 9) && entity.method_10573("pos", 9) && nbt.method_10573("facing", 1))) {
            return null;
        }
        class_2499 blockPosList = entity.method_10554("blockPos", 3);
        class_2499 posList = entity.method_10554("pos", 6);
        byte facing = nbt.method_10571("facing");
        String variant = nbt.method_10558("variant");
        if (blockPosList.size() != 3 || posList.size() != 3) {
            return null;
        }
        int blockX = blockPosList.method_10600(0);
        int blockY = blockPosList.method_10600(1);
        int blockZ = blockPosList.method_10600(2);
        double x = posList.method_10611(0);
        double y = posList.method_10611(1);
        double z = posList.method_10611(2);
        double xOffset = x - (double)blockX;
        double yOffset = y - (double)blockY;
        double zOffset = z - (double)blockZ;
        boolean yIncorrect = Math.abs(yOffset - 0.5) > 0.01;
        boolean centeringIncorrect = false;
        switch (facing) {
            case 0: 
            case 2: {
                centeringIncorrect = Math.abs(xOffset - 0.5) > 0.4;
                break;
            }
            case 1: 
            case 3: {
                centeringIncorrect = Math.abs(zOffset - 0.5) > 0.4;
            }
        }
        double correctedX = x;
        double correctedY = yIncorrect ? (double)blockY + 0.5 : y;
        double correctedZ = z;
        if (centeringIncorrect) {
            switch (facing) {
                case 0: 
                case 2: {
                    correctedX = (double)blockX + 0.5;
                    break;
                }
                case 1: 
                case 3: {
                    correctedZ = (double)blockZ + 0.5;
                }
            }
        }
        boolean hasIssues = yIncorrect || centeringIncorrect;
        String facingName = PaintingOffsetFixer.getFacingName(facing);
        return new PaintingAnalysis(hasIssues, yIncorrect, centeringIncorrect, facingName, x, y, z, correctedX, correctedY, correctedZ, variant);
    }

    public static PaintingAnalysis fixOffsets(class_2487 entity) {
        PaintingAnalysis analysis = PaintingOffsetFixer.identifyIssues(entity);
        if (analysis == null || !analysis.hasIssues) {
            return analysis;
        }
        class_2499 newPosList = new class_2499();
        newPosList.add((Object)class_2489.method_23241((double)analysis.correctedX));
        newPosList.add((Object)class_2489.method_23241((double)analysis.correctedY));
        newPosList.add((Object)class_2489.method_23241((double)analysis.correctedZ));
        entity.method_10566("pos", (class_2520)newPosList);
        return analysis;
    }

    public static List<PaintingAnalysis> scanStructure(class_2487 root) {
        ArrayList<PaintingAnalysis> issues = new ArrayList<PaintingAnalysis>();
        if (!root.method_10573("entities", 9)) {
            return issues;
        }
        class_2499 entities = root.method_10554("entities", 10);
        for (int i = 0; i < entities.size(); ++i) {
            class_2487 entity = entities.method_10602(i);
            PaintingAnalysis analysis = PaintingOffsetFixer.identifyIssues(entity);
            if (analysis == null || !analysis.hasIssues) continue;
            issues.add(analysis);
        }
        return issues;
    }

    public static List<PaintingAnalysis> fixStructure(class_2487 root) {
        ArrayList<PaintingAnalysis> fixes = new ArrayList<PaintingAnalysis>();
        if (!root.method_10573("entities", 9)) {
            return fixes;
        }
        class_2499 entities = root.method_10554("entities", 10);
        for (int i = 0; i < entities.size(); ++i) {
            class_2487 entity = entities.method_10602(i);
            PaintingAnalysis analysis = PaintingOffsetFixer.fixOffsets(entity);
            if (analysis == null || !analysis.hasIssues) continue;
            fixes.add(analysis);
        }
        return fixes;
    }

    private static String getFacingName(byte facing) {
        switch (facing) {
            case 0: {
                return "South";
            }
            case 1: {
                return "West";
            }
            case 2: {
                return "North";
            }
            case 3: {
                return "East";
            }
        }
        return "Unknown(" + facing + ")";
    }

    public static class PaintingAnalysis {
        public final boolean hasIssues;
        public final boolean yOffsetIncorrect;
        public final boolean centeringIncorrect;
        public final String facing;
        public final double currentX;
        public final double currentY;
        public final double currentZ;
        public final double correctedX;
        public final double correctedY;
        public final double correctedZ;
        public final String variant;

        public PaintingAnalysis(boolean hasIssues, boolean yOffsetIncorrect, boolean centeringIncorrect, String facing, double currentX, double currentY, double currentZ, double correctedX, double correctedY, double correctedZ, String variant) {
            this.hasIssues = hasIssues;
            this.yOffsetIncorrect = yOffsetIncorrect;
            this.centeringIncorrect = centeringIncorrect;
            this.facing = facing;
            this.currentX = currentX;
            this.currentY = currentY;
            this.currentZ = currentZ;
            this.correctedX = correctedX;
            this.correctedY = correctedY;
            this.correctedZ = correctedZ;
            this.variant = variant;
        }

        public String getIssueDescription() {
            ArrayList<String> issues = new ArrayList<String>();
            if (this.yOffsetIncorrect) {
                issues.add("Y-offset incorrect");
            }
            if (this.centeringIncorrect) {
                issues.add("Centering axis incorrect");
            }
            return String.join((CharSequence)", ", issues);
        }

        public String getPositionDescription() {
            return String.format("[%.3f, %.3f, %.3f] \u2192 [%.3f, %.3f, %.3f]", this.currentX, this.currentY, this.currentZ, this.correctedX, this.correctedY, this.correctedZ);
        }
    }
}

