/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.fixers;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class StructureScanner {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: java StructureScanner <directory>");
            System.exit(1);
        }
        Path directory = Paths.get(args[0], new String[0]);
        final ArrayList nbtFiles = new ArrayList();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.toString().endsWith(".nbt")) {
                    nbtFiles.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        System.out.println("Scanning " + nbtFiles.size() + " structure files...\n");
        HashMap<String, List> modReferences = new HashMap<String, List>();
        for (Path path : nbtFiles) {
            try {
                class_2487 root = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
                Set<String> mods = StructureScanner.findModReferences((class_2520)root);
                if (mods.isEmpty()) continue;
                String relativePath = directory.relativize(path).toString();
                for (String mod : mods) {
                    modReferences.computeIfAbsent(mod, k -> new ArrayList()).add(relativePath);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading " + String.valueOf(path.getFileName()) + ": " + e.getMessage());
            }
        }
        if (modReferences.isEmpty()) {
            System.out.println("No external mod references found.");
        } else {
            System.out.println("Found references to external mods:\n");
            for (Map.Entry entry : modReferences.entrySet()) {
                System.out.println("Mod: " + (String)entry.getKey() + " (" + ((List)entry.getValue()).size() + " structures)");
                for (String file : (List)entry.getValue()) {
                    System.out.println("  - " + file);
                }
                System.out.println();
            }
        }
    }

    private static Set<String> findModReferences(class_2520 element) {
        HashSet<String> mods = new HashSet<String>();
        StructureScanner.scanElement(element, mods);
        return mods;
    }

    private static void scanElement(class_2520 element, Set<String> mods) {
        block4: {
            block3: {
                if (!(element instanceof class_2487)) break block3;
                class_2487 compound = (class_2487)element;
                for (String key : compound.method_10541()) {
                    int colonIndex;
                    String namespace;
                    class_2519 string;
                    String str;
                    class_2520 value = compound.method_10580(key);
                    if (value instanceof class_2519 && (str = (string = (class_2519)value).method_10714()).contains(":") && !str.startsWith("minecraft:") && !str.startsWith("bca:") && !str.startsWith("cobblemon:") && (namespace = str.substring(0, colonIndex = str.indexOf(":"))).matches("[a-z0-9_-]+")) {
                        mods.add(namespace);
                    }
                    if (value == null) continue;
                    StructureScanner.scanElement(value, mods);
                }
                break block4;
            }
            if (!(element instanceof class_2499)) break block4;
            class_2499 list = (class_2499)element;
            for (int i = 0; i < list.size(); ++i) {
                StructureScanner.scanElement(list.method_10534(i), mods);
            }
        }
    }
}

