/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.loot;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.strikeknight57.bca.CobblemonAdditions;
import io.strikeknight57.bca.config.Config;
import io.strikeknight57.bca.loot.LootRollScaler;
import io.strikeknight57.bca.mixin.LootPoolAccessor;
import io.strikeknight57.bca.mixin.LootTableBuilderAccessor;
import io.strikeknight57.bca.util.ModCompat;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;

public final class LootWeightsManager {
    private static final Map<class_2960, List<LootEntryConfig>> LOOT_TABLE_CONFIG = new HashMap<class_2960, List<LootEntryConfig>>();
    private static final float DEFAULT_ROLL = 1.0f;

    public static void init() {
        LootWeightsManager.loadFromConfig();
        LootTableEvents.MODIFY.register(LootWeightsManager::modifyLootTable);
        CobblemonAdditions.LOGGER.info("ModifyLootTables initialized; loaded {} configured tables", (Object)LOOT_TABLE_CONFIG.size());
        LootRollScaler.init();
    }

    private static Object readRollsField(class_55 pool) {
        String[] candidates;
        for (String name : candidates = new String[]{"rolls", "rollsProvider", "roll", "numberProvider"}) {
            try {
                Field f = class_55.class.getDeclaredField(name);
                f.setAccessible(true);
                return f.get(pool);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            }
        }
        return null;
    }

    private static boolean hasRollsConfigured(class_55.class_56 builder) {
        try {
            Field f = builder.getClass().getDeclaredField("rolls");
            f.setAccessible(true);
            return f.get(builder) != null;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return false;
        }
    }

    private static List<class_55> getExistingPools(class_52.class_53 tableBuilder) {
        ImmutableList.Builder<class_55> poolsBuilder = ((LootTableBuilderAccessor)tableBuilder).getPoolsBuilder();
        return poolsBuilder.build();
    }

    private static void addNewPool(class_52.class_53 tableBuilder, List<LootEntryConfig> configs, class_7225<class_1792> itemRegistry, class_2960 tableId) {
        class_55.class_56 newPool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f));
        LootWeightsManager.appendConfiguredEntriesToPool(newPool, configs, itemRegistry, tableId);
        tableBuilder.method_336(newPool);
        CobblemonAdditions.LOGGER.info("Added new pool to loot table {}", (Object)tableId);
    }

    private static void mergeIntoFirstPool(class_52.class_53 tableBuilder, List<class_55> existingPools, List<LootEntryConfig> configs, class_7225<class_1792> itemRegistry, class_2960 tableId) {
        class_55 firstPool = existingPools.get(0);
        class_55.class_56 merged = class_55.method_347();
        Object rollsObj = LootWeightsManager.readRollsField(firstPool);
        if (rollsObj != null) {
            try {
                Method rollsMethod = class_55.class_56.class.getMethod("rolls", rollsObj.getClass());
                rollsMethod.invoke((Object)merged, rollsObj);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException rollsMethod) {
                // empty catch block
            }
        }
        if (!LootWeightsManager.hasRollsConfigured(merged)) {
            merged.method_352((class_5658)class_44.method_32448((float)1.0f));
        }
        try {
            List<class_79> existingEntries = ((LootPoolAccessor)firstPool).getEntries();
            if (existingEntries != null) {
                for (class_79 e : existingEntries) {
                    merged.with(e);
                }
            }
        }
        catch (Throwable existingEntries) {
            // empty catch block
        }
        LootWeightsManager.appendConfiguredEntriesToPool(merged, configs, itemRegistry, tableId);
        ImmutableList.Builder newPoolsBuilder = ImmutableList.builder();
        newPoolsBuilder.add((Object)merged.method_355());
        for (int i = 1; i < existingPools.size(); ++i) {
            newPoolsBuilder.add((Object)existingPools.get(i));
        }
        try {
            ((LootTableBuilderAccessor)tableBuilder).setPoolsBuilder((ImmutableList.Builder<class_55>)newPoolsBuilder);
        }
        catch (Throwable t) {
            CobblemonAdditions.LOGGER.warn("Failed to replace pools builder; falling back to adding a new pool for {}", (Object)tableId);
            tableBuilder.method_336(merged);
        }
    }

    private static void appendConfiguredEntriesToPool(class_55.class_56 poolBuilder, List<LootEntryConfig> configs, class_7225<class_1792> itemRegistry, class_2960 tableId) {
        if (configs == null || configs.isEmpty()) {
            return;
        }
        for (LootEntryConfig cfg : configs) {
            if (!cfg.shouldAdd()) continue;
            if (cfg.itemId == null) {
                poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8162).method_437(cfg.weight));
                continue;
            }
            class_2960 itemId = class_2960.method_12829((String)cfg.itemId);
            if (itemId == null) {
                CobblemonAdditions.LOGGER.warn("Skipping malformed item ID '{}' for loot table {}", (Object)cfg.itemId, (Object)tableId);
                continue;
            }
            class_5321 itemKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)itemId);
            Optional ref = itemRegistry.method_46746(itemKey);
            if (ref.isEmpty()) {
                CobblemonAdditions.LOGGER.info("Skipping missing item '{}' for loot table {}", (Object)cfg.itemId, (Object)tableId);
                continue;
            }
            poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)((class_6880.class_6883)ref.get()).comp_349())).method_437(cfg.weight));
        }
    }

    private static void modifyLootTable(class_5321<class_52> key, class_52.class_53 tableBuilder, LootTableSource source, class_7225.class_7874 registries) {
        class_2960 tableId = key.method_29177();
        List<LootEntryConfig> configs = LOOT_TABLE_CONFIG.get(tableId);
        if (configs == null || configs.isEmpty()) {
            return;
        }
        class_7225.class_7226 itemRegistry = registries.method_46762(class_7924.field_41197);
        List<class_55> existingPools = LootWeightsManager.getExistingPools(tableBuilder);
        if (existingPools.isEmpty()) {
            LootWeightsManager.addNewPool(tableBuilder, configs, (class_7225<class_1792>)itemRegistry, tableId);
        } else {
            LootWeightsManager.mergeIntoFirstPool(tableBuilder, existingPools, configs, (class_7225<class_1792>)itemRegistry, tableId);
        }
    }

    private static void loadFromConfig() {
        LOOT_TABLE_CONFIG.clear();
        for (Map.Entry<String, JsonArray> entry : Config.lootWeights.entrySet()) {
            class_2960 id = class_2960.method_60655((String)"bca", (String)entry.getKey());
            ArrayList<LootEntryConfig> entries = new ArrayList<LootEntryConfig>();
            for (JsonElement el : entry.getValue()) {
                JsonObject obj = el.getAsJsonObject();
                int weight = obj.get("weight").getAsInt();
                if (obj.has("air") && obj.get("air").getAsBoolean()) {
                    entries.add(new LootEntryConfig(() -> true, null, weight));
                    continue;
                }
                String mod = obj.get("mod").getAsString();
                String item = obj.get("item").getAsString();
                entries.add(new LootEntryConfig(() -> ModCompat.isEnabled(mod), item, weight));
            }
            LOOT_TABLE_CONFIG.put(id, entries);
        }
    }

    private LootWeightsManager() {
    }

    private record LootEntryConfig(Supplier<Boolean> condition, String itemId, int weight) {
        boolean shouldAdd() {
            return this.condition.get();
        }
    }
}

