/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.ai.tasks;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Arrays;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.ai.tasks.FOFPokemonAttackTask;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_7894;
import net.minecraft.class_7898;

public class FOFPokemonMeleeTask {
    public static class_7894<class_1309> create(int cooldownBetweenAttacks) {
        return class_7898.method_47224(context -> context.group((App)context.method_47235(class_4140.field_18446), (App)context.method_47244(class_4140.field_22355), (App)context.method_47245(class_4140.field_22475), (App)context.method_47244(class_4140.field_18442)).apply((Applicative)context, (lookTargetAccessor, attackTargetAccessor, attackCooldownAccessor, visibleMobsAccessor) -> (serverLevel, livingEntity, l) -> {
            class_1309 target = (class_1309)context.method_47243(attackTargetAccessor);
            if (livingEntity instanceof PokemonEntity) {
                PokemonEntity pokemonEntity = (PokemonEntity)livingEntity;
                pokemonEntity.method_5980(target);
                int attackTime = FOFPokemonAttackTask.getAttackTime(pokemonEntity);
                if (PokemonUtils.shouldMelee(pokemonEntity) && FOFPokemonAttackTask.sharedStartCondition(pokemonEntity)) {
                    FOFPokemonMeleeTask.tryQuickApproach(pokemonEntity, target);
                    if (FOFPokemonMeleeTask.canPerformAttack(pokemonEntity, target) && attackTime <= 0) {
                        lookTargetAccessor.method_47249((Object)new class_4102((class_1297)target, true));
                        FOFPokemonAttackTask.resetAttackTime(pokemonEntity, 0.0);
                        pokemonEntity.method_6104(class_1268.field_5808);
                        FOFPokemonMeleeTask.pokemonDoHurtTarget(pokemonEntity, target);
                        ((PokemonInterface)pokemonEntity).setAttackTime(cooldownBetweenAttacks);
                        attackCooldownAccessor.method_47250((Object)true, (long)cooldownBetweenAttacks);
                        return true;
                    }
                }
            }
            return false;
        }));
    }

    protected static boolean canPerformAttack(PokemonEntity pokemonEntity, class_1309 entity) {
        return pokemonEntity.method_42150(entity) && pokemonEntity.method_5985().method_6369((class_1297)entity);
    }

    protected static boolean pokemonDoHurtTarget(PokemonEntity pokemonEntity, class_1309 hurtTarget) {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_attack_in_battle && FOFPokemonAttackTask.isTargetInBattle(pokemonEntity)) {
            return false;
        }
        if (!PokemonUtils.pokemonTryForceEncounter(pokemonEntity, (class_1297)hurtTarget)) {
            Move move = PokemonUtils.getMove(pokemonEntity);
            if (move != null && Arrays.stream(CobblemonFightOrFlight.moveConfig().self_centered_aoe_moves).toList().contains(move.getName())) {
                PokemonAttackEffect.dealAoEDamage(pokemonEntity, (class_1297)pokemonEntity, true, PokemonUtils.isMeleeAttackMove(move));
                if (PokemonUtils.isPhysicalMove(move)) {
                    PokemonUtils.sendAnimationPacket(pokemonEntity, "physical");
                } else {
                    PokemonUtils.sendAnimationPacket(pokemonEntity, "special");
                }
                return true;
            }
            PokemonUtils.sendAnimationPacket(pokemonEntity, "physical");
            return PokemonAttackEffect.pokemonAttack(pokemonEntity, (class_1297)hurtTarget);
        }
        return false;
    }

    protected static void tryQuickApproach(PokemonEntity pokemonEntity, class_1309 target) {
        Move move;
        if (target != null && FOFPokemonAttackTask.getAttackTime(pokemonEntity) == 0 && (move = PokemonUtils.getMove(pokemonEntity)) != null) {
            float distance;
            String moveName = move.getName();
            if (Arrays.stream(CobblemonFightOrFlight.moveConfig().quick_attack_like_move).toList().contains(moveName) && (distance = pokemonEntity.method_5739((class_1297)target)) >= 1.5f && distance <= 10.0f) {
                class_2338 targetBlockPos = target.method_24515();
                if (FOFUtils.multiSamplingCollisionCheckBlock((class_1309)pokemonEntity, target, 5, 3)) {
                    PokemonUtils.makeParticle(4, (class_1297)pokemonEntity, class_2398.field_46911);
                    pokemonEntity.method_5859((double)targetBlockPos.method_10263(), (double)targetBlockPos.method_10264(), (double)targetBlockPos.method_10260());
                    PokemonUtils.makeParticle(4, (class_1297)target, class_2398.field_46911);
                }
            }
        }
    }
}

