/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.ai.tasks;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.ai.tasks.FOFPokemonAttackTask;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class FOFPokemonRangeTask
extends class_4097<class_1309> {
    public FOFPokemonRangeTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456, (Object)class_4140.field_22475, (Object)class_4141.field_18457));
    }

    protected boolean method_18919(class_3218 level, class_1309 pokemon) {
        PokemonEntity pokemonEntity;
        class_1309 target;
        if (pokemon instanceof PokemonEntity && (target = FOFPokemonAttackTask.getTarget(pokemonEntity = (PokemonEntity)pokemon)) != null && target.method_5805()) {
            return PokemonUtils.shouldShoot(pokemonEntity) && class_4215.method_24565((class_1309)pokemonEntity, (class_1309)target) && this.isWithinAttackRange((class_1309)pokemonEntity, target);
        }
        return false;
    }

    protected boolean method_18927(class_3218 level, class_1309 pokemon, long gameTime) {
        if (pokemon instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)pokemon;
            return pokemonEntity.method_18868().method_18896(class_4140.field_22355) && this.method_18919(level, (class_1309)pokemonEntity);
        }
        return false;
    }

    protected void method_18926(class_3218 level, class_1309 pokemon, long gameTime) {
    }

    protected void method_18924(class_3218 level, class_1309 pokemon, long gameTime) {
        PokemonEntity pokemonEntity;
        class_1309 target;
        if (pokemon instanceof PokemonEntity && (target = FOFPokemonAttackTask.getTarget(pokemonEntity = (PokemonEntity)pokemon)) != null) {
            pokemonEntity.method_5980(target);
            boolean canSee = pokemonEntity.method_5985().method_6369((class_1297)target);
            int attackTime = FOFPokemonAttackTask.getAttackTime(pokemonEntity);
            if (FOFPokemonAttackTask.sharedStartCondition(pokemonEntity)) {
                if (attackTime == 7 && ((PokemonInterface)pokemonEntity).usingSound()) {
                    PokemonUtils.createSonicBoomParticle(pokemonEntity, target);
                }
                if ((attackTime + 1) % 5 == 0 && ((PokemonInterface)pokemonEntity).usingMagic()) {
                    PokemonAttackEffect.makeMagicAttackParticle(pokemonEntity, (class_1297)target);
                }
                if (attackTime == 0) {
                    if (!canSee) {
                        return;
                    }
                    this.performRangedAttack(pokemonEntity, target);
                } else if (attackTime < 0) {
                    FOFPokemonAttackTask.refreshAttackTime(pokemonEntity, 10);
                }
            }
        }
    }

    protected boolean isWithinAttackRange(class_1309 pokemon, class_1309 target) {
        if (pokemon instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)pokemon;
            double d = pokemonEntity.method_5739((class_1297)target);
            return d < (double)PokemonUtils.getAttackRadius();
        }
        return false;
    }

    protected void performRangedAttack(PokemonEntity pokemonEntity, class_1309 target) {
        double d = pokemonEntity.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        PokemonAttackEffect.pokemonPerformRangedAttack(pokemonEntity, target);
        FOFPokemonAttackTask.resetAttackTime(pokemonEntity, d);
        pokemonEntity.method_18868().method_24525(class_4140.field_22475, (Object)true, (long)FOFPokemonAttackTask.getAttackTime(pokemonEntity));
    }
}

