/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.utils.RayTrace;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5819;

public class FOFUtils {
    public static class_2382 stringToVec3i(String data) {
        Pattern p;
        Matcher m;
        if (data.startsWith("VEC3i_") && (m = (p = Pattern.compile("VEC3i_([-\\d]*)_([-\\d]*)_([-\\d]*)")).matcher(data)).find()) {
            try {
                int x = Integer.parseInt(m.group(1));
                int y = Integer.parseInt(m.group(2));
                int z = Integer.parseInt(m.group(3));
                return new class_2382(x, y, z);
            }
            catch (NumberFormatException e) {
                CobblemonFightOrFlight.LOGGER.warn("Failed to converse the vec");
            }
        }
        return null;
    }

    public static String createCommandData(class_1657 player, PokeStaffComponent.CMDMODE cmdmode) {
        String cmdData = "";
        switch (cmdmode) {
            case MOVE: 
            case ATTACK_POSITION: 
            case MOVE_ATTACK: {
                class_3965 result = RayTrace.rayTraceBlock((class_1309)player, 16.0);
                class_2338 blockPos = result.method_17777();
                cmdData = "VEC3i_%s_%s_%s".formatted(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
                break;
            }
            case ATTACK: {
                class_1309 livingEntity = RayTrace.rayTraceEntity((class_1309)player, 16.0);
                if (livingEntity == null) break;
                cmdData = "ENTITY_%s".formatted(livingEntity.method_5845());
                break;
            }
            case STAY: {
                cmdData = "POS_SELF";
                break;
            }
            default: {
                cmdData = "";
            }
        }
        return cmdData;
    }

    public static boolean chanceTest(List<Boolean> conditions, List<Float> chances, class_5819 source) {
        if (conditions.size() != chances.size()) {
            CobblemonFightOrFlight.LOGGER.info("The size of the two arrays are not the same");
            return false;
        }
        float chance = source.method_43057();
        for (int i = 0; i < conditions.size(); ++i) {
            if (!conditions.get(i).booleanValue()) continue;
            return chances.get(i).floatValue() > chance;
        }
        return false;
    }

    public static float toAngle(double num) {
        return (float)(num * 57.2957763671875);
    }

    public static float toRad(double num) {
        return (float)(num / 180.0 * 3.1415927410125732);
    }

    public static void registerMoveData(String moveName, MoveData data) {
        if (MoveData.moveData.containsKey(moveName)) {
            if (MoveData.moveData.get(moveName) != null) {
                MoveData.moveData.get(moveName).add(data);
            }
        } else {
            MoveData.moveData.put(moveName, new ArrayList());
            MoveData.moveData.get(moveName).add(data);
        }
    }

    public static boolean teamCheck(class_1309 entity1, class_1309 entity2) {
        class_1321 animal2;
        class_1321 animal1;
        if (entity1 instanceof class_1321 && (animal1 = (class_1321)entity1).method_35057() != null && entity2 instanceof class_1321 && (animal2 = (class_1321)entity2).method_35057() != null) {
            class_1309 owner1 = animal1.method_35057();
            class_1309 owner2 = animal2.method_35057();
            if (owner1.method_5781() != null || owner2.method_5781() != null) {
                return owner1.method_5781() == owner2.method_5781() || owner1.method_5781() == animal2.method_5781() && owner1.method_5781() != null || animal1.method_5781() == owner2.method_5781() && owner2.method_5781() != null;
            }
        }
        if (entity1.method_5781() != null || entity2.method_5781() != null) {
            return entity1.method_5781() == entity2.method_5781();
        }
        return false;
    }

    public static boolean multiSamplingCollisionCheckBlock(class_1309 viewer, class_1309 target, int verticalSampleCount, int horizontalSampleCount, int allowedHit) {
        class_1937 level = viewer.method_37908();
        class_243 viewerPos = viewer.method_19538();
        class_243 targetPos = target.method_19538();
        float viewerHeight = viewer.method_17682();
        float targetHeight = target.method_17682();
        float viewerWidth = viewer.method_17681();
        int hit = 0;
        for (int i = 0; i < verticalSampleCount; ++i) {
            for (int j = 0; j < horizontalSampleCount; ++j) {
                for (int k = 0; k < horizontalSampleCount; ++k) {
                    class_243 v = viewerPos.method_1031((double)(-viewerWidth / 2.0f + viewerWidth * (float)(j + 1) / (float)horizontalSampleCount), (double)(viewerHeight * (float)i / (float)verticalSampleCount), (double)(-viewerWidth / 2.0f + viewerWidth * (float)(k + 1) / (float)horizontalSampleCount));
                    class_3959 context = new class_3959(v, targetPos.method_1031(0.0, (double)(targetHeight / 2.0f), 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)viewer);
                    class_3965 result = level.method_17742(context);
                    if (result.method_17783().equals((Object)class_239.class_240.field_1333)) continue;
                    ++hit;
                }
            }
        }
        return hit <= allowedHit;
    }

    public static boolean multiSamplingCollisionCheckBlock(class_1309 viewer, class_1309 target, int verticalSampleCount, int horizontalSampleCount) {
        return FOFUtils.multiSamplingCollisionCheckBlock(viewer, target, verticalSampleCount, horizontalSampleCount, 0);
    }
}

