/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.service;

import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.data.pack.SeriesMetaData;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.LangKeys;
import com.gitlab.srcmc.rctmod.api.utils.PathUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SeriesManager
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final String EMPTY_SERIES_ID = "empty";
    public static final String FREEROAM_SERIES_ID = "freeroam";
    public final transient SeriesGraph UNKNOWN_SERIES = new SeriesGraph(new SeriesMetaData(Text.empty()));
    public final transient SeriesGraph EMPTY_SERIES = new SeriesGraph(new SeriesMetaData(Text.translatable((String)LangKeys.SERIES_TITLE("empty")), Text.translatable((String)LangKeys.SERIES_DESCRIPTION("empty")), 0));
    public final transient SeriesGraph FREEROAM_SERIES = new SeriesGraph(new SeriesMetaData(Text.translatable((String)LangKeys.SERIES_TITLE("freeroam")), Text.translatable((String)LangKeys.SERIES_DESCRIPTION("freeroam")), 0));
    private Map<String, SeriesGraph> seriesGraphs = new HashMap<String, SeriesGraph>();

    public void copyFrom(SeriesManager sm) {
        this.seriesGraphs = sm.seriesGraphs;
    }

    public Set<String> getSeriesIds() {
        return this.seriesGraphs.keySet();
    }

    public SeriesGraph getGraph(String seriesId) {
        return seriesId == null || seriesId.isBlank() || seriesId.equals(EMPTY_SERIES_ID) ? this.EMPTY_SERIES : (FREEROAM_SERIES_ID.equals(seriesId) ? this.FREEROAM_SERIES : this.seriesGraphs.getOrDefault(seriesId, this.UNKNOWN_SERIES));
    }

    void onLoad(TrainerManager tm) {
        this.EMPTY_SERIES.clear();
        this.FREEROAM_SERIES.clear();
        HashMap<String, SeriesGraph> seriesGraphs = new HashMap<String, SeriesGraph>();
        seriesGraphs.put(EMPTY_SERIES_ID, this.EMPTY_SERIES);
        seriesGraphs.put(FREEROAM_SERIES_ID, this.FREEROAM_SERIES);
        tm.listSeries((rl, io) -> {
            String sid = PathUtils.filename(rl.method_12832());
            if (sid.equals(EMPTY_SERIES_ID)) {
                throw new IllegalStateException(String.format("series id '%s' already occupied by empty series", EMPTY_SERIES_ID));
            }
            if (sid.equals(FREEROAM_SERIES_ID)) {
                throw new IllegalStateException(String.format("series id '%s' already occupied by freeroam series", FREEROAM_SERIES_ID));
            }
            if (seriesGraphs.put(sid, new SeriesGraph(tm.loadSeries(sid).get())) != null) {
                ModCommon.LOG.warn(String.format("duplicate series '%s'", sid));
            }
        });
        tm.getAllData(new String[0]).forEach(e -> ((TrainerMobData)e.getValue()).getSeries().forEach(sid -> {
            SeriesGraph sg = seriesGraphs.computeIfAbsent((String)sid, x$0 -> new SeriesGraph((String)x$0));
            sg.map.put((String)e.getKey(), new TrainerNode((String)e.getKey(), ((TrainerMobData)e.getValue()).isOptional()));
        }));
        tm.getAllData(new String[0]).filter(e -> ((TrainerMobData)e.getValue()).getSeries().findFirst().isEmpty()).forEach(e -> seriesGraphs.values().stream().forEach(sd -> sd.map.put((String)e.getKey(), new TrainerNode((String)e.getKey(), ((TrainerMobData)e.getValue()).isOptional()))));
        tm.getAllData(new String[0]).forEach(e -> {
            Stream<Object> seriesIds = ((TrainerMobData)e.getValue()).getSeries().findFirst().isPresent() ? ((TrainerMobData)e.getValue()).getSeries() : seriesGraphs.keySet().stream();
            seriesIds.forEach(sid -> {
                SeriesGraph sg = (SeriesGraph)seriesGraphs.get(sid);
                Set<String> st = ((TrainerMobData)e.getValue()).getSubstitutes();
                List<Set<String>> rd = ((TrainerMobData)e.getValue()).getRequiredDefeats((String)sid);
                TrainerNode nd = sg.map.get(e.getKey());
                st.forEach(tid -> {
                    TrainerNode other = sg.map.get(tid);
                    if (other != null) {
                        nd.siblings.add(other);
                    }
                });
                rd.forEach(tids -> tids.forEach(tid -> {
                    TrainerNode other = sg.map.get(tid);
                    if (other != null) {
                        nd.successors.add(other);
                        other.ancestors.add(nd);
                        tids.stream().filter(tid2 -> tid2 != tid).map(tid2 -> sg.map.get(tid2)).forEach(other.siblings::add);
                    }
                }));
            });
        });
        this.seriesGraphs = Collections.unmodifiableMap(seriesGraphs);
        this.seriesGraphs.values().forEach(SeriesGraph::sortGraph);
    }

    public class SeriesGraph
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private Map<String, TrainerNode> map = new HashMap<String, TrainerNode>();
        private List<TrainerNode> list = new ArrayList<TrainerNode>();
        private SeriesMetaData metaData;

        SeriesGraph(String seriesId) {
            this(new SeriesMetaData(Text.translatable((String)LangKeys.SERIES_TITLE(seriesId)), Text.translatable((String)LangKeys.SERIES_DESCRIPTION(seriesId))));
        }

        SeriesGraph(SeriesMetaData metaData) {
            this.metaData = metaData;
        }

        SeriesGraph(SeriesGraph origin) {
            this.metaData = origin.metaData;
        }

        void clear() {
            this.map = new HashMap<String, TrainerNode>();
            this.list = new ArrayList<TrainerNode>();
        }

        public SeriesMetaData getMetaData() {
            return this.metaData;
        }

        public Stream<TrainerNode> stream() {
            return this.list.stream();
        }

        public TrainerNode get(String trainerId) {
            return this.map.get(trainerId);
        }

        public boolean contains(String trainerId) {
            return this.map.containsKey(trainerId);
        }

        public int size() {
            return this.list.size();
        }

        public SeriesGraph getNext(Set<String> defeats) {
            return this.getNext(defeats, false, false);
        }

        public SeriesGraph getNext(boolean includeOptionals) {
            return this.getNext(includeOptionals, false);
        }

        public SeriesGraph getNext(boolean includeOptionals, boolean includeSingles) {
            return this.getNext(Set.of(), includeOptionals, includeSingles);
        }

        public SeriesGraph getNext(Set<String> defeats, boolean includeOptionals) {
            return this.getNext(defeats, includeOptionals, false);
        }

        public SeriesGraph getNext(Set<String> defeats, boolean includeOptionals, boolean includeSingles) {
            SeriesGraph copy = new SeriesGraph(this);
            this.list.stream().filter(tn -> !(!includeSingles && tn.isAlone() || !includeOptionals && tn.isOptional() || tn.isDefeated(defeats) || !tn.successors.stream().allMatch(suc -> suc.isDefeated(defeats)))).forEach(tn -> {
                copy.list.add((TrainerNode)tn);
                copy.map.put(tn.trainerId, (TrainerNode)tn);
            });
            return copy;
        }

        public SeriesGraph getRemaining(Set<String> defeats) {
            return this.getRemaining(defeats, false);
        }

        public SeriesGraph getRemaining(boolean includeOptionals) {
            return this.getRemaining(includeOptionals, false);
        }

        public SeriesGraph getRemaining(boolean includeOptionals, boolean includeSingles) {
            return this.getRemaining(Set.of(), includeOptionals, includeSingles);
        }

        public SeriesGraph getRemaining(Set<String> defeats, boolean includeOptionals) {
            return this.getRemaining(defeats, includeOptionals, false);
        }

        public SeriesGraph getRemaining(Set<String> defeats, boolean includeOptionals, boolean includeSingles) {
            SeriesGraph copy = new SeriesGraph(this);
            this.list.stream().filter(tn -> !(!includeSingles && tn.isAlone() || !includeOptionals && tn.isOptional() || tn.isDefeated(defeats))).forEach(tn -> {
                copy.list.add((TrainerNode)tn);
                copy.map.put(tn.trainerId, (TrainerNode)tn);
            });
            return copy;
        }

        private void sortGraph() {
            List<TrainerNode> list = List.copyOf(this.map.values());
            HashMap<TrainerNode, Integer> succ = new HashMap<TrainerNode, Integer>();
            List<TrainerNode> alone = list.stream().filter(TrainerNode::isAlone).sorted((tn1, tn2) -> tn1.trainerId.compareTo(tn2.trainerId)).toList();
            list = list.stream().filter(tn -> !tn.isAlone()).collect(Collectors.toList());
            list.stream().filter(tn -> tn.ancestors.isEmpty()).forEach(tn -> this.initCount((TrainerNode)tn, (Map<TrainerNode, Integer>)succ));
            ArrayList sorted = new ArrayList();
            ArrayList<TrainerNode> batch = new ArrayList<TrainerNode>();
            while (list.size() > 0) {
                Iterator<TrainerNode> it = list.iterator();
                while (it.hasNext()) {
                    TrainerNode next = it.next();
                    if (succ.compute(next, (k, v) -> v - 1) >= 0) continue;
                    batch.add(next);
                    it.remove();
                }
                batch.sort((tn1, tn2) -> tn1.trainerId.compareTo(tn2.trainerId));
                sorted.addAll(batch);
                batch.clear();
            }
            list.addAll(sorted);
            list.addAll(alone);
            this.list = List.copyOf(list);
        }

        private void initCount(TrainerNode start, Map<TrainerNode, Integer> succ) {
            Integer c = succ.computeIfAbsent(start, k -> 0);
            start.successors.forEach(stn -> {
                succ.compute((TrainerNode)stn, (k, v) -> v == null ? c + 1 : Math.max(c + 1, v));
                this.initCount((TrainerNode)stn, succ);
            });
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.list.stream().forEach(tn -> sb.append(" -> ").append(tn.trainerId));
            return sb.toString();
        }
    }

    public class TrainerNode
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private List<TrainerNode> ancestors = new ArrayList<TrainerNode>();
        private List<TrainerNode> successors = new ArrayList<TrainerNode>();
        private List<TrainerNode> siblings = new ArrayList<TrainerNode>();
        private String trainerId;
        private boolean optional;

        public TrainerNode(String trainerId, boolean optional) {
            this.trainerId = trainerId;
            this.optional = optional;
        }

        public String id() {
            return this.trainerId;
        }

        public Stream<TrainerNode> successors() {
            return this.successors.stream();
        }

        public Stream<TrainerNode> ancestors() {
            return this.ancestors.stream();
        }

        public Stream<TrainerNode> siblings() {
            return this.siblings.stream();
        }

        public boolean isAlone() {
            return this.isAlone(new HashSet<TrainerNode>());
        }

        public boolean isOptional() {
            return this.isOptional(new HashSet<TrainerNode>());
        }

        public boolean isDefeated(Set<String> trainerIds) {
            return this.isDefeated(trainerIds, new HashSet<TrainerNode>());
        }

        private boolean isAlone(Set<TrainerNode> visited) {
            visited.add(this);
            return this.ancestors.isEmpty() && this.successors.isEmpty() && this.siblings.stream().filter(sib -> !visited.contains(sib)).allMatch(sib -> sib.isAlone(visited));
        }

        private boolean isOptional(Set<TrainerNode> visited) {
            return visited.add(this) && (this.optional || this.siblings.stream().anyMatch(sib -> sib.isOptional(visited)) || this.successors.stream().anyMatch(suc -> suc.isOptional(visited)));
        }

        private boolean isDefeated(Set<String> trainerIds, Set<TrainerNode> visited) {
            return visited.add(this) && (trainerIds.contains(this.trainerId) || this.siblings.stream().anyMatch(sib -> sib.isDefeated(trainerIds, visited)) || this.ancestors.stream().anyMatch(anc -> anc.isDefeated(trainerIds, visited)));
        }
    }
}

