/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.utils.collections;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.Supplier;

public class Collection2dDeserializer<T, CInner extends Collection<T>, COuter extends Collection<CInner>>
implements JsonDeserializer<COuter> {
    private static final Gson GSON = new Gson();
    private final TypeToken<T> TT = new TypeToken<T>(this){};
    private Supplier<CInner> ctorInner;
    private Supplier<COuter> ctorOuter;

    public Collection2dDeserializer(Supplier<CInner> ctorInner, Supplier<COuter> ctorOuter) {
        this.ctorInner = ctorInner;
        this.ctorOuter = ctorOuter;
    }

    private void add(CInner cInner, JsonElement json) {
        if (!json.isJsonNull()) {
            cInner.add((Object)GSON.fromJson(json, this.TT));
        }
    }

    public COuter deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Collection cOuter = (Collection)this.ctorOuter.get();
        if (json.isJsonArray()) {
            json.getAsJsonArray().forEach(e -> {
                Collection cInner = (Collection)this.ctorInner.get();
                if (e.isJsonArray()) {
                    e.getAsJsonArray().forEach(e2 -> this.add((CInner)cInner, (JsonElement)e2));
                } else {
                    this.add((CInner)cInner, (JsonElement)e);
                }
                if (!cInner.isEmpty()) {
                    cOuter.add(cInner);
                }
            });
        } else {
            Collection cInner = (Collection)this.ctorInner.get();
            this.add(cInner, json);
            if (!cInner.isEmpty()) {
                cOuter.add(cInner);
            }
        }
        return (COuter)cOuter;
    }
}

