/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.blocks;

import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.world.blocks.entities.TrainerSpawnerBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class TrainerSpawnerBlock
extends class_2237 {
    public static final MapCodec<TrainerSpawnerBlock> CODEC = TrainerSpawnerBlock.method_54094(TrainerSpawnerBlock::new);
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 INVERTED = class_2741.field_12501;
    public static final class_2746 LOOTABLE = class_2746.method_11825((String)"lootable");
    public static final class_2746 LOCKED = class_2746.method_11825((String)"locked");

    public static boolean isPowered(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)POWERED);
    }

    static class_2680 setPowered(class_2680 blockState, boolean value) {
        return (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(value));
    }

    public static boolean isInverted(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)INVERTED);
    }

    static class_2680 setInverted(class_2680 blockState, boolean value) {
        return (class_2680)blockState.method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(value));
    }

    public static boolean isBoosted(class_2680 blockState) {
        return TrainerSpawnerBlock.isInverted(blockState) ? !TrainerSpawnerBlock.isPowered(blockState) : TrainerSpawnerBlock.isPowered(blockState);
    }

    public static boolean isLootable(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)LOOTABLE);
    }

    static class_2680 setLootable(class_2680 blockState, boolean value) {
        return (class_2680)blockState.method_11657((class_2769)LOOTABLE, (Comparable)Boolean.valueOf(value));
    }

    public static boolean isLocked(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)LOCKED);
    }

    public static class_2680 setLocked(class_2680 blockState, boolean value) {
        return (class_2680)blockState.method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(value));
    }

    public TrainerSpawnerBlock() {
        this(class_4970.class_2251.method_9630((class_4970)class_2246.field_10056).method_22488());
    }

    public TrainerSpawnerBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LOOTABLE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9615(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        TrainerSpawnerBlock.checkNeighbour(blockState, level, blockPos);
        super.method_9615(blockState, level, blockPos, blockState2, bl);
    }

    protected void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        if (!blockState.method_27852(blockState2.method_26204())) {
            level.method_35230(blockPos, (class_2591)ModRegistries.BlockEntityTypes.TRAINER_SPAWNER.get()).ifPresent(be -> be.setOwner(null));
        }
        super.method_9536(blockState, level, blockPos, blockState2, bl);
    }

    protected List<class_1799> method_9560(class_2680 blockState, class_8567.class_8568 builder) {
        class_2586 be;
        if (TrainerSpawnerBlock.isLootable(blockState) && (be = (class_2586)builder.method_51876(class_181.field_1228)) instanceof TrainerSpawnerBlockEntity) {
            TrainerSpawnerBlockEntity sbe = (TrainerSpawnerBlockEntity)be;
            ArrayList<class_1799> drops = new ArrayList<class_1799>(super.method_9560(blockState, builder));
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            class_7922 reg = class_7923.field_41178;
            sbe.getTrainerIds().stream().map(tm::getData).filter(t -> t.getSignatureItem() != null && !t.getSignatureItem().isBlank()).map(t -> (class_1792)reg.method_10223(class_2960.method_60654((String)t.getSignatureItem()))).distinct().filter(i -> i != null && i != class_1802.field_8162).map(i -> i.method_7854()).forEach(drops::add);
            return drops;
        }
        return super.method_9560(blockState, builder);
    }

    protected void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_2338 blockPos2, boolean bl) {
        TrainerSpawnerBlock.checkNeighbour(blockState, level, blockPos);
        super.method_9612(blockState, level, blockPos, block, blockPos2, bl);
    }

    private static void checkNeighbour(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        boolean neigh = level.method_49803(blockPos);
        if (neigh != TrainerSpawnerBlock.isPowered(blockState)) {
            level.method_8652(blockPos, TrainerSpawnerBlock.setPowered(blockState, neigh), 2);
        }
    }

    public void method_9496(class_2680 blockState, class_1937 level, class_2338 blockPos, class_5819 randomSource) {
        if (TrainerSpawnerBlock.isBoosted(blockState)) {
            double d = (double)blockPos.method_10263() + 0.5 + (randomSource.method_43058() - 0.5) * 0.2;
            double e = (double)blockPos.method_10264() + 0.7 + (randomSource.method_43058() - 0.5) * 0.2;
            double f = (double)blockPos.method_10260() + 0.5 + (randomSource.method_43058() - 0.5) * 0.2;
            level.method_8406((class_2394)class_2390.field_11188, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POWERED, INVERTED, LOOTABLE, LOCKED});
    }

    public class_9062 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        class_9062 result = class_9062.field_47733;
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof TrainerSpawnerBlockEntity) {
            TrainerSpawnerBlockEntity be = (TrainerSpawnerBlockEntity)class_25862;
            if (!TrainerSpawnerBlock.isLocked(blockState) && be.addTrainerIdsFromItem(RCTMod.getInstance().getTrainerManager(), itemStack)) {
                if (!level.field_9236) {
                    itemStack.method_57008(1, (class_1309)player);
                }
                result = class_9062.field_47728;
            }
        }
        return result;
    }

    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new TrainerSpawnerBlockEntity(blockPos, blockState);
    }

    protected class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return TrainerSpawnerBlock.method_31618(blockEntityType, (class_2591)((class_2591)ModRegistries.BlockEntityTypes.TRAINER_SPAWNER.get()), (class_5558)(level.field_9236 ? TrainerSpawnerBlockEntity::clientTick : TrainerSpawnerBlockEntity::serverTick));
    }
}

