/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.blocks.entities;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerSpawner;
import com.gitlab.srcmc.rctmod.world.blocks.TrainerSpawnerBlock;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4051;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class TrainerSpawnerBlockEntity
extends class_2586 {
    private static final int OWNER_UPDATE_INTERVAL_TICKS = 40;
    private static final int SPAWN_INTERVAL_TICKS = 80;
    private static final int SCAN_INTERVAL_TICKS = 200;
    private static final double HOME_SWITCH_CHANCE = 0.1;
    public final RenderState renderState = new RenderState(this);
    private Set<String> trainerIds = new HashSet<String>();
    private TrainerMob ownerTrainer;
    private UUID ownerUUID;
    private double minPlayerDistance;
    private double maxPlayerDistance;
    private Queue<Consumer<TrainerManager>> updateQueue = new LinkedList<Consumer<TrainerManager>>();
    private Set<class_1792> renderItems = new HashSet<class_1792>();
    private Timer ownerUpdateTimer = new Timer(this);
    private Timer spawnTimer = new Timer(this);
    private Timer scanTimer = new Timer(this);
    private class_238 aabb;

    public TrainerSpawnerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModRegistries.BlockEntityTypes.TRAINER_SPAWNER.get(), blockPos, blockState);
        this.setPlayerDistanceThreshold(2.0, (double)RCTMod.getInstance().getServerConfig().maxHorizontalDistanceToPlayers() * 0.6666666666666666);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = super.method_16887(provider);
        this.method_11007(tag, provider);
        return tag;
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        if (this.ownerUUID != null) {
            tag.method_25927("OwnerUUID", this.ownerUUID);
        }
        class_2499 tids = new class_2499();
        tids.addAll(this.trainerIds.stream().map(class_2519::method_23256).toList());
        tag.method_10566("TrainerIds", (class_2520)tids);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.trainerIds.clear();
        UUID uUID = this.ownerUUID = tag.method_10545("OwnerUUID") ? tag.method_25926("OwnerUUID") : null;
        if (tag.method_10545("renderItemKey")) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)tag.method_10558("renderItemKey")));
            this.addTrainerIdsFromItem(item.method_7854());
        }
        if (tag.method_10545("TrainerIds")) {
            this.trainerIds.addAll(tag.method_10562("TrainerIds").method_10541());
            this.trainerIds.addAll(tag.method_10554("TrainerIds", 8).stream().map(class_2520::method_10714).toList());
        }
        this.updateOwner();
        this.updateRenderItems();
    }

    private void update() {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        if (!tm.isLoading()) {
            while (!this.updateQueue.isEmpty()) {
                this.updateQueue.poll().accept(tm);
            }
        }
    }

    private void updateRenderItems() {
        this.updateQueue.add(tm -> {
            this.renderItems.clear();
            this.trainerIds.forEach(tid -> {
                String renderItemKey = tm.getData((String)tid).getSignatureItem();
                if (renderItemKey != null && !renderItemKey.isBlank()) {
                    class_2960 rl = class_2960.method_60654((String)renderItemKey);
                    if (!class_7923.field_41178.method_10250(rl)) {
                        ModCommon.LOG.warn(String.format("Invalid Trainer Spawner item for '%s': %s", tid, rl.toString()));
                    } else {
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(rl);
                        this.renderItems.add(item);
                    }
                }
            });
        });
    }

    private void syncToClients() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    public void setOwner(TrainerMob ownerTrainer) {
        if (ownerTrainer != this.ownerTrainer) {
            if (this.ownerTrainer != null) {
                this.ownerTrainer.setHomeSpawner(null);
            }
            this.ownerTrainer = ownerTrainer;
            if (this.ownerTrainer != null) {
                TrainerSpawnerBlockEntity oldSpawner = this.ownerTrainer.getHomeSpawner();
                if (oldSpawner != this && oldSpawner != null) {
                    oldSpawner.setOwner(null);
                }
                this.ownerTrainer.setHomeSpawner(this);
                this.setOwnerUUID(this.ownerTrainer.method_5667());
            }
        }
        if (this.ownerTrainer == null) {
            this.setOwnerUUID(null);
        }
    }

    protected void setOwnerUUID(UUID ownerUUID) {
        if (!Objects.equals(this.ownerUUID, ownerUUID)) {
            this.ownerUUID = ownerUUID;
            this.method_5431();
            this.syncToClients();
        }
    }

    public TrainerMob getOwner() {
        return this.ownerTrainer;
    }

    protected void updateOwner() {
        if (this.ownerUUID != null) {
            if (this.ownerTrainer == null) {
                RCTMod.getInstance().getTrainerSpawner().getSpawns().stream().filter(tm -> tm.method_5667().equals(this.ownerUUID)).findAny().ifPresent(tm -> {
                    this.ownerTrainer = tm;
                });
            }
            if (this.ownerTrainer == null || !this.ownerTrainer.method_5805()) {
                this.setOwner(null);
            } else {
                this.setOwner(this.ownerTrainer);
            }
        }
    }

    private void addTrainerIdsFromItem(class_1799 item) {
        this.updateQueue.add(tm -> this.addTrainerIdsFromItem((TrainerManager)tm, item));
    }

    public boolean addTrainerIdsFromItem(TrainerManager tm, class_1799 item) {
        boolean[] added = new boolean[]{false};
        if (!tm.isLoading()) {
            String itemId = item.method_7909().arch$registryName().toString();
            tm.getAllData(new String[0]).filter(e -> itemId.equals(((TrainerMobData)e.getValue()).getSignatureItem())).forEach(e -> {
                if (this.trainerIds.add((String)e.getKey())) {
                    added[0] = true;
                }
            });
            if (added[0]) {
                this.method_5431();
                this.syncToClients();
            }
        }
        return added[0];
    }

    public Set<String> getTrainerIds() {
        return this.trainerIds;
    }

    public Set<class_1792> getRenderItems() {
        return this.renderItems;
    }

    public double getMinPlayerDistance() {
        return this.minPlayerDistance;
    }

    public double getMaxPlayerDistance() {
        return this.maxPlayerDistance;
    }

    protected void setPlayerDistanceThreshold(double min, double max) {
        this.minPlayerDistance = Math.min(min, max);
        this.maxPlayerDistance = max;
        this.aabb = new class_238(this.method_11016()).method_1014(max);
    }

    private void attemptSpawn(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        class_243 pos = blockPos.method_46558();
        class_1657 nearest = level.method_18463(class_4051.method_36626(), null, pos.field_1352, pos.field_1351, pos.field_1350);
        if (nearest == null || nearest.method_5707(pos) < Math.pow(this.minPlayerDistance, 2.0) / 2.0) {
            return;
        }
        boolean guaruantee = TrainerSpawnerBlock.isBoosted(blockState);
        TrainerSpawner spawner = RCTMod.getInstance().getTrainerSpawner();
        ArrayList<String> trainerIds = new ArrayList<String>(this.getTrainerIds());
        Collections.shuffle(trainerIds);
        for (class_1657 player : level.method_18464(class_4051.method_36626(), null, this.aabb)) {
            for (String trainerId : trainerIds) {
                TrainerMob m = spawner.attemptSpawnFor(player, trainerId, this.method_11016().method_10084(), true, true, guaruantee, 1.0, 1.0);
                if (m == null) continue;
                this.setOwner(m);
                return;
            }
        }
    }

    private void scanForTrainerNearby(class_1937 level) {
        Set<String> trainerIds = this.getTrainerIds();
        level.method_18466(TrainerMob.class, class_4051.method_36626(), null, this.aabb).stream().filter(t -> trainerIds.contains(t.getTrainerId())).filter(t -> t.getHomePos() == null || t.method_59922().method_43058() < 0.1).findAny().ifPresent(t -> this.setOwner((TrainerMob)((Object)t)));
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, TrainerSpawnerBlockEntity be) {
        be.update();
        if (be.ownerUpdateTimer.passed(level.method_8510()) >= 40L) {
            be.updateOwner();
            be.ownerUpdateTimer.reset(level.method_8510());
        }
        if (be.getTrainerIds().size() > 0) {
            if (be.ownerUUID == null && be.spawnTimer.passed(level.method_8510()) >= 80L) {
                be.attemptSpawn(level, blockPos, blockState);
                be.spawnTimer.reset(level.method_8510());
            }
            if (be.ownerUUID == null && be.scanTimer.passed(level.method_8510()) >= 200L) {
                be.scanForTrainerNearby(level);
                be.scanTimer.reset(level.method_8510());
            }
        }
    }

    public static void clientTick(class_1937 level, class_2338 blockPos, class_2680 blockState, TrainerSpawnerBlockEntity be) {
        be.update();
    }

    public class RenderState {
        public double p;
        public double targetP;

        public RenderState(TrainerSpawnerBlockEntity this$0) {
        }
    }

    class Timer {
        private long prev;
        private long total;

        Timer(TrainerSpawnerBlockEntity this$0) {
        }

        public void reset(long now) {
            this.prev = now;
            this.total = 0L;
        }

        public long passed(long now) {
            this.total += now - this.prev;
            this.prev = now;
            return this.total;
        }
    }
}

