/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities;

import com.cobblemon.mod.common.api.apricorn.Apricorn;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.SeriesMetaData;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerSpawner;
import com.gitlab.srcmc.rctmod.api.utils.ChatUtils;
import com.gitlab.srcmc.rctmod.world.entities.goals.RandomStrollThroughVillageGoal;
import com.gitlab.srcmc.rctmod.world.items.TrainerCard;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3989;
import net.minecraft.class_4051;
import net.minecraft.class_4153;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7477;
import net.minecraft.class_9290;
import net.minecraft.class_9306;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class TrainerAssociation
extends class_3989 {
    public static final int SPAWN_INTERVAL_TICKS = 400;
    public static final int UPDATE_INTERVAL_TICKS = 4;
    public static final int POI_SCAN_RANGE = 48;
    public static final List<Supplier<OfferBuilder>> OFFER_CANDIDATES = List.of(() -> new OfferBuilder(class_1802.field_8687, (class_1792)ModRegistries.Items.TRAINER_CARD.get()));
    public static final int MIN_ITEM_OFFERS = 1;
    public static final int MAX_ITEM_OFFERS = 1;
    public static final int MIN_TRADE_USES = 2;
    public static final int MAX_TRADE_USES = 4;
    public static final int MIN_EMERALD_PRIZE = 1;
    public static final int MAX_EMERALD_PRIZE = 8;
    public static final int MIN_SECONDARY_PRIZE = 1;
    public static final int MAX_SECONDARY_PRIZE = 5;
    public static final int MAX_RESTOCK_DELAY_TICKS = 24000;
    public static final int MIN_RESTOCK_DELAY_TICKS = 6000;
    public static final Supplier<List<? extends class_1792>> SECONDARY_OPTIONS = () -> Streams.concat((Stream[])new Stream[]{Stream.of(Apricorn.values()).map(Apricorn::item)}).toList();
    private static final class_1299<TrainerAssociation> TYPE = class_1299.class_1300.method_5903(TrainerAssociation::new, (class_1311)class_1311.field_17715).method_20815().method_17687(0.6f, 1.95f).method_5905("trainer_association");
    private static Set<UUID> playerSpawns = new HashSet<UUID>();
    private Map.Entry<String, class_1799> offer;
    private class_1916 itemOffers;
    private class_1657 playerTarget;
    private int despawnTicks;
    private int lastRestock;

    public static class_1299<TrainerAssociation> getEntityType() {
        return TYPE;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23717, 48.0).method_26868(class_5134.field_23716, 20.0);
    }

    public static void init(class_1937 level) {
        playerSpawns = new HashSet<UUID>();
    }

    public static boolean trySpawnFor(class_1657 player) {
        if (TrainerAssociation.canSpawnNearby(player)) {
            if (TrainerAssociation.shouldSpawnNearby(player)) {
                return TrainerAssociation.spawnFor(player, false);
            }
            if (TrainerAssociation.shouldSpawnFor(player)) {
                return TrainerAssociation.spawnFor(player, true);
            }
        }
        return false;
    }

    public static boolean spawnFor(class_1657 player, boolean target) {
        class_2338 pos = RCTMod.getInstance().getTrainerSpawner().nextPos(player);
        if (pos != null) {
            class_1937 level = player.method_37908();
            TrainerAssociation ta = (TrainerAssociation)TYPE.method_5883(level);
            if (target) {
                ta.setPlayerTarget(player);
            }
            ta.method_33574(pos.method_46558());
            level.method_8649((class_1297)ta);
            return true;
        }
        return false;
    }

    protected static boolean canSpawnNearby(class_1657 player) {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        String dim = player.method_37908().method_27983().method_29177().toString();
        return cfg.spawnTrainerAssociation() && (cfg.dimensionWhitelist().isEmpty() || cfg.dimensionWhitelist().contains(dim)) && !cfg.dimensionBlacklist().contains(dim) && player.method_37908().method_21726(TrainerAssociation.class, class_4051.method_36625(), (class_1309)player, player.method_23317(), player.method_23318(), player.method_23321(), player.method_5829().method_1014((double)cfg.maxHorizontalDistanceToPlayers())) == null;
    }

    protected static boolean shouldSpawnNearby(class_1657 player) {
        class_4153 poim = ((class_3218)player.method_37908()).method_19494();
        Optional bell = poim.method_43985(poit -> poit.method_40225(class_7477.field_39292), player.method_24515(), 48, class_4153.class_4155.field_18489);
        Stream beds = poim.method_43983(poit -> poit.method_40225(class_7477.field_39291), bp -> true, player.method_24515(), 48, class_4153.class_4155.field_18488);
        return bell.isPresent() && beds.skip(2L).findFirst().isPresent();
    }

    protected static boolean shouldSpawnFor(class_1657 player) {
        TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
        return !playerSpawns.contains(player.method_5667()) && TrainerCard.has(player) && (tpd.isSeriesCompleted() || tpd.isInEmptySeries());
    }

    public TrainerAssociation(class_1299<? extends class_3989> entityType, class_1937 level) {
        super(entityType, level);
    }

    public class_1657 getPlayerTarget() {
        return this.playerTarget;
    }

    public void setPlayerTarget(class_1657 player) {
        if (player != this.playerTarget) {
            if (this.playerTarget != null) {
                playerSpawns.remove(this.playerTarget.method_5667());
            }
            this.playerTarget = player;
            if (this.playerTarget != null) {
                playerSpawns.add(this.playerTarget.method_5667());
            }
            this.method_5980((class_1309)this.playerTarget);
        }
    }

    public void method_5773() {
        if (!this.method_37908().field_9236 && this.field_6012 % 4 == 0) {
            RCTMod.getInstance().getTrainerSpawner().register(this);
        }
        super.method_5773();
    }

    public void method_5650(class_1297.class_5529 reason) {
        RCTMod.getInstance().getTrainerSpawner().unregister(this);
        this.setPlayerTarget(null);
        super.method_5650(reason);
    }

    public boolean method_31746() {
        return this.method_5947();
    }

    public boolean shouldDespawn() {
        if (++this.despawnTicks % 20 == 0) {
            if (this.method_37908().method_18460((class_1297)this, (double)Math.max(128, RCTMod.getInstance().getServerConfig().maxHorizontalDistanceToPlayers())) == null) {
                return this.despawnTicks >= 600;
            }
            this.despawnTicks = 0;
        }
        return false;
    }

    public void method_5971() {
        if (!this.method_5947()) {
            super.method_5971();
            this.setPlayerTarget(null);
            TrainerSpawner ts = RCTMod.getInstance().getTrainerSpawner();
            ts.unregister(this);
            ts.register(this);
        }
    }

    public boolean method_5974(double d) {
        return false;
    }

    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(5, (class_1352)new RandomStrollThroughVillageGoal((class_1314)this, 0.35));
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (!itemStack.method_31574(class_1802.field_8086) && this.method_5805() && !this.method_18009() && !this.method_6109()) {
            if (!this.method_37908().field_9236) {
                if (this.itemOffers == null) {
                    this.method_7237();
                }
                this.attemptRestock();
                this.updateOffersFor(player);
                this.offer = null;
                if (this.method_8264().isEmpty()) {
                    ChatUtils.reply((class_1309)this, player, "missing_beaten_champ");
                }
            }
            return super.method_5992(player, interactionHand);
        }
        return super.method_5992(player, interactionHand);
    }

    public void attemptRestock() {
        if (this.itemOffers != null && !this.method_18009() && this.field_6012 - this.lastRestock > this.field_5974.method_43051(6000, 24000)) {
            for (class_1914 offer : this.itemOffers) {
                offer.method_19274();
                offer.method_19275();
            }
            this.lastRestock = this.field_6012;
        }
    }

    protected void method_7237() {
        this.itemOffers = new class_1916();
        this.addRandomOffers(this.itemOffers, OFFER_CANDIDATES.stream().map(Supplier::get).toList(), 1, 1);
        this.field_17721 = new class_1916();
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.itemOffers = this.field_17721;
        this.field_17721 = new class_1916();
    }

    public void method_5652(class_2487 tag) {
        class_1916 offers = this.field_17721;
        this.field_17721 = this.itemOffers;
        super.method_5652(tag);
        this.field_17721 = offers;
    }

    protected void addRandomOffers(class_1916 target, Collection<OfferBuilder> candidates, int min, int max) {
        LinkedList<OfferBuilder> list = new LinkedList<OfferBuilder>(candidates);
        List<? extends class_1792> sec = SECONDARY_OPTIONS.get();
        block0: for (int m = this.field_5974.method_43051(min, max + 1); m > 0 && !list.isEmpty(); --m) {
            Iterator it = list.iterator();
            float n = list.size();
            int i = 0;
            while (it.hasNext()) {
                OfferBuilder ob = (OfferBuilder)it.next();
                if (!((float)(++i) / n > this.field_5974.method_43057())) continue;
                target.add((Object)ob.primaryCount(this.field_5974.method_43051(1, 9)).secondaryCount(this.field_5974.method_43051(1, 6)).secondary(sec.isEmpty() ? null : sec.get(this.field_5974.method_43048(sec.size()))).maxUses(this.field_5974.method_43051(2, 5)).build());
                it.remove();
                continue block0;
            }
        }
    }

    public Map.Entry<String, class_1799> takeOffer() {
        Map.Entry<String, class_1799> o = this.offer;
        this.offer = null;
        return o;
    }

    public void updateOffersFor(class_1657 player) {
        RCTMod rct = RCTMod.getInstance();
        TrainerManager tm = rct.getTrainerManager();
        SeriesManager sm = rct.getSeriesManager();
        TrainerPlayerData tpd = tm.getData(player);
        boolean freeroamRequiresCompletedSeries = rct.getServerConfig().freeroamRequiresCompletedSeries();
        this.field_17721 = new class_1916();
        if (this.itemOffers != null) {
            this.itemOffers.forEach(arg_0 -> this.field_17721.add(arg_0));
        }
        sm.getSeriesIds().stream().map(sid -> Map.entry(sid, sm.getGraph((String)sid).getMetaData())).filter(e -> !((String)e.getKey()).equals("empty") && !((String)e.getKey()).equals(tpd.getCurrentSeries())).filter(e -> !"freeroam".equals(e.getKey()) || !freeroamRequiresCompletedSeries || tpd.getCompletedSeries().values().stream().anyMatch(c -> c > 0)).filter(e -> "freeroam".equals(tpd.getCurrentSeries()) ? sm.getGraph(tpd.getPreviousSeries()) == sm.EMPTY_SERIES || sm.getGraph(tpd.getPreviousSeries()) == sm.UNKNOWN_SERIES || ((String)e.getKey()).equals(tpd.getPreviousSeries()) : true).sorted((e1, e2) -> ((SeriesMetaData)e1.getValue()).compareTo((SeriesMetaData)e2.getValue())).forEach(e -> {
            if (((SeriesMetaData)e.getValue()).requiredSeries() != null) {
                for (List reqs : ((SeriesMetaData)e.getValue()).requiredSeries()) {
                    boolean ok = false;
                    for (String s : reqs) {
                        if (!tpd.getCompletedSeries().containsKey(s)) continue;
                        ok = true;
                        break;
                    }
                    if (ok) continue;
                    return;
                }
            }
            this.field_17721.add((Object)new SeriesSwitchOffer((String)e.getKey(), (SeriesMetaData)e.getValue()));
        });
        this.method_19181();
    }

    public static class OfferBuilder {
        private class_1792 primary;
        private class_1792 secondary;
        private class_1792 result;
        private int primaryCount = 1;
        private int secondaryCount = 1;
        private int resultCount = 1;
        private int maxUses = 1;
        private int xp = 2;
        private float priceMultiplier = 0.05f;

        public OfferBuilder(class_1792 primary, class_1792 result) {
            this.primary = primary;
            this.result = result;
        }

        public OfferBuilder secondary(class_1792 item) {
            this.secondary = item;
            return this;
        }

        public OfferBuilder primaryCount(int value) {
            this.primaryCount = value;
            return this;
        }

        public OfferBuilder secondaryCount(int value) {
            this.secondaryCount = value;
            return this;
        }

        public OfferBuilder resultCount(int value) {
            this.resultCount = value;
            return this;
        }

        public OfferBuilder maxUses(int value) {
            this.maxUses = value;
            return this;
        }

        public OfferBuilder xp(int value) {
            this.xp = value;
            return this;
        }

        public OfferBuilder priceMultiplier(float value) {
            this.priceMultiplier = value;
            return this;
        }

        public class_1914 build() {
            return new class_1914(new class_9306((class_1935)this.primary, this.primaryCount), this.secondary != null ? Optional.of(new class_9306((class_1935)this.secondary, this.secondaryCount)) : Optional.empty(), new class_1799((class_1935)this.result, this.resultCount), this.maxUses, this.xp, this.priceMultiplier);
        }
    }

    private class SeriesSwitchOffer
    extends class_1914 {
        private String seriesId;
        private SeriesMetaData seriesData;

        public SeriesSwitchOffer(String seriesId, SeriesMetaData seriesData) {
            super(new class_9306((class_1935)ModRegistries.Items.TRAINER_CARD.get()), SeriesSwitchOffer.createOfferFor(TrainerAssociation.this.method_8257(), seriesId, seriesData), Integer.MAX_VALUE, Integer.MAX_VALUE, 1.0f);
            this.seriesId = seriesId;
            this.seriesData = seriesData;
        }

        private SeriesSwitchOffer(SeriesSwitchOffer origin) {
            this(origin.seriesId, origin.seriesData);
        }

        public boolean method_16952(class_1799 arg1, class_1799 arg2) {
            if (super.method_16952(arg1, arg2)) {
                TrainerAssociation.this.offer = Map.entry(this.seriesId, arg1.method_7972());
                return true;
            }
            return false;
        }

        public SeriesSwitchOffer copy() {
            return new SeriesSwitchOffer(this);
        }

        private static String makeStars(int n, int m) {
            int i;
            n = Math.min(n, m);
            int full = n / 2;
            boolean half = n > 0 && n % 2 != 0;
            int empty = (m - n) / 2;
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < full; ++i) {
                sb.append('\u2605');
            }
            if (half) {
                sb.append('\u2bea');
            }
            for (i = 0; i < empty; ++i) {
                sb.append('\u2606');
            }
            return sb.toString();
        }

        private static class_1799 createOfferFor(class_1657 player, String seriesId, SeriesMetaData seriesData) {
            return player == null ? new class_1799((class_1935)ModRegistries.Items.TRAINER_CARD.get(), 1) : ("freeroam".equals(seriesId) ? SeriesSwitchOffer.createFreeroamOffer(player, seriesId, seriesData) : ("freeroam".equals(RCTMod.getInstance().getTrainerManager().getData(player).getCurrentSeries()) ? SeriesSwitchOffer.createContinueOffer(player, seriesId, seriesData) : SeriesSwitchOffer.createSwitchOffer(player, seriesId, seriesData)));
        }

        private static class_1799 createFreeroamOffer(class_1657 player, String seriesId, SeriesMetaData seriesData) {
            class_1799 card = new class_1799((class_1935)ModRegistries.Items.TRAINER_CARD.get(), 1);
            card.method_57365(class_9323.method_57827().method_57840(class_9334.field_49631, (Object)seriesData.title().getComponent(new Object[0])).method_57840(class_9334.field_49632, (Object)new class_9290(List.of(seriesData.description().getComponent(new Object[0])))).method_57838());
            return card;
        }

        private static class_1799 createSwitchOffer(class_1657 player, String seriesId, SeriesMetaData seriesData) {
            class_1799 card = new class_1799((class_1935)ModRegistries.Items.TRAINER_CARD.get(), 1);
            Integer completions = RCTMod.getInstance().getTrainerManager().getData(player).getCompletedSeries().getOrDefault(seriesId, 0);
            card.method_57365(class_9323.method_57827().method_57840(class_9334.field_49631, (Object)seriesData.title().getComponent(new Object[0])).method_57840(class_9334.field_49632, (Object)new class_9290(List.of(seriesData.description().getComponent(new Object[0]), class_2561.method_43470((String)""), class_2561.method_43470((String)String.format("%s: %s", class_2561.method_43471((String)"gui.rctmod.trainer_association.difficulty").getString(), SeriesSwitchOffer.makeStars(seriesData.difficulty(), 10))), class_2561.method_43470((String)String.format("%s: %d", class_2561.method_43471((String)"gui.rctmod.trainer_association.completed").getString(), completions)), class_2561.method_43470((String)""), class_2561.method_43471((String)"gui.rctmod.trainer_association.important").method_27692(class_124.field_1067).method_27692(class_124.field_1065), class_2561.method_43471((String)"gui.rctmod.trainer_association.series_reset").method_27692(class_124.field_1065)))).method_57838());
            return card;
        }

        private static class_1799 createContinueOffer(class_1657 player, String seriesId, SeriesMetaData seriesData) {
            class_1799 card = new class_1799((class_1935)ModRegistries.Items.TRAINER_CARD.get(), 1);
            Integer completions = RCTMod.getInstance().getTrainerManager().getData(player).getCompletedSeries().getOrDefault(seriesId, 0);
            card.method_57365(class_9323.method_57827().method_57840(class_9334.field_49631, (Object)seriesData.title().getComponent(new Object[0])).method_57840(class_9334.field_49632, (Object)new class_9290(List.of(seriesData.description().getComponent(new Object[0]), class_2561.method_43470((String)""), class_2561.method_43470((String)String.format("%s: %s", class_2561.method_43471((String)"gui.rctmod.trainer_association.difficulty").getString(), SeriesSwitchOffer.makeStars(seriesData.difficulty(), 10))), class_2561.method_43470((String)String.format("%s: %d", class_2561.method_43471((String)"gui.rctmod.trainer_association.completed").getString(), completions)), class_2561.method_43470((String)""), class_2561.method_43471((String)"gui.rctmod.trainer_association.series_continue").method_27692(class_124.field_1065)))).method_57838());
            return card;
        }
    }
}

