/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.command;

import com.cobblemon.mod.common.api.permission.Permission;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.command.arguments.BigIntegerArgumentType;
import fr.harmex.cobbledollars.common.command.permission.CobbleDollarsPermissions;
import fr.harmex.cobbledollars.common.config.BankConfig;
import fr.harmex.cobbledollars.common.config.CommonConfig;
import fr.harmex.cobbledollars.common.config.ShopConfig;
import fr.harmex.cobbledollars.common.network.CobbleDollarsNetwork;
import fr.harmex.cobbledollars.common.network.packets.s2c.SyncShopConfigPacket;
import fr.harmex.cobbledollars.common.utils.MiscUtilsKt;
import fr.harmex.cobbledollars.common.utils.extensions.BigIntegerExtensionsKt;
import fr.harmex.cobbledollars.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobbledollars.common.world.cobbledollars.CobbleDollarsAccount;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J-\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b \u0010\u001c\u00a8\u0006!"}, d2={"Lfr/harmex/cobbledollars/common/command/CobbleDollarsCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "sourceStack", "Lnet/minecraft/class_3222;", "target", "Ljava/math/BigInteger;", "amount", "", "pay", "(Lnet/minecraft/class_2168;Lnet/minecraft/class_3222;Ljava/math/BigInteger;)I", "Lnet/minecraft/class_1657;", "query", "(Lnet/minecraft/class_2168;Lnet/minecraft/class_1657;)I", "", "targets", "give", "(Lnet/minecraft/class_2168;Ljava/util/Collection;Ljava/math/BigInteger;)I", "remove", "set", "reload", "(Lnet/minecraft/class_2168;)I", "page", "displayLeaderboard", "(Lnet/minecraft/class_2168;I)I", "updateLeaderboard", "common"})
@SourceDebugExtension(value={"SMAP\nCobbleDollarsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobbleDollarsCommand.kt\nfr/harmex/cobbledollars/common/command/CobbleDollarsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1557#2:285\n1628#2,3:286\n1062#2:289\n1872#2,3:290\n*S KotlinDebug\n*F\n+ 1 CobbleDollarsCommand.kt\nfr/harmex/cobbledollars/common/command/CobbleDollarsCommand\n*L\n188#1:285\n188#1:286,3\n189#1:289\n216#1:290,3\n*E\n"})
public final class CobbleDollarsCommand {
    @NotNull
    public static final CobbleDollarsCommand INSTANCE = new CobbleDollarsCommand();

    private CobbleDollarsCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = class_2170.method_9247((String)"cobbledollars");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder2 = (LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS(), (boolean)false, (int)2, null);
        LiteralArgumentBuilder literalArgumentBuilder3 = class_2170.method_9247((String)"pay");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder3, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder4 = (LiteralArgumentBuilder)literalArgumentBuilder2.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder3), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_PAY(), (boolean)false, (int)2, null)).then(class_2170.method_9244((String)"target", (ArgumentType)((ArgumentType)class_2186.method_9305())).then(class_2170.method_9244((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$0))));
        LiteralArgumentBuilder literalArgumentBuilder5 = class_2170.method_9247((String)"query");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder5, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder6 = (LiteralArgumentBuilder)literalArgumentBuilder4.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder5), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_QUERY(), (boolean)false, (int)2, null)).then(class_2170.method_9244((String)"target", (ArgumentType)((ArgumentType)class_2186.method_9305())).executes(CobbleDollarsCommand::register$lambda$1)));
        LiteralArgumentBuilder literalArgumentBuilder7 = class_2170.method_9247((String)"give");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder7, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder8 = (LiteralArgumentBuilder)literalArgumentBuilder6.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder7), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_GIVE(), (boolean)false, (int)2, null)).then(class_2170.method_9244((String)"targets", (ArgumentType)((ArgumentType)class_2186.method_9308())).then(class_2170.method_9244((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$2))));
        LiteralArgumentBuilder literalArgumentBuilder9 = class_2170.method_9247((String)"remove");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder9, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder10 = (LiteralArgumentBuilder)literalArgumentBuilder8.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder9), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_REMOVE(), (boolean)false, (int)2, null)).then(class_2170.method_9244((String)"targets", (ArgumentType)((ArgumentType)class_2186.method_9308())).then(class_2170.method_9244((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$3))));
        LiteralArgumentBuilder literalArgumentBuilder11 = class_2170.method_9247((String)"set");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder11, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder12 = (LiteralArgumentBuilder)literalArgumentBuilder10.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder11), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_SET(), (boolean)false, (int)2, null)).then(class_2170.method_9244((String)"targets", (ArgumentType)((ArgumentType)class_2186.method_9308())).then(class_2170.method_9244((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(0)).executes(CobbleDollarsCommand::register$lambda$4))));
        LiteralArgumentBuilder literalArgumentBuilder13 = class_2170.method_9247((String)"reload");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder13, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder14 = (LiteralArgumentBuilder)literalArgumentBuilder12.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder13), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_RELOAD(), (boolean)false, (int)2, null)).executes(CobbleDollarsCommand::register$lambda$5));
        LiteralArgumentBuilder literalArgumentBuilder15 = class_2170.method_9247((String)"leaderboard");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder15, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder16 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder15), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_LEADERBOARD(), (boolean)false, (int)2, null)).executes(CobbleDollarsCommand::register$lambda$6);
        LiteralArgumentBuilder literalArgumentBuilder17 = class_2170.method_9247((String)"update");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder17, (String)"literal(...)");
        LiteralCommandNode mainNode = dispatcher.register((LiteralArgumentBuilder)literalArgumentBuilder14.then(literalArgumentBuilder16.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder17), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_LEADERBOARD_UPDATE(), (boolean)false, (int)2, null)).executes(CobbleDollarsCommand::register$lambda$7))));
        LiteralArgumentBuilder literalArgumentBuilder18 = class_2170.method_9247((String)"cd");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder18, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder18), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS(), (boolean)false, (int)2, null)).redirect((CommandNode)mainNode));
    }

    private final int pay(class_2168 sourceStack, class_3222 target, BigInteger amount) {
        class_3222 class_32222 = sourceStack.method_9207();
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayerOrException(...)");
        if (amount.compareTo(PlayerExtensionKt.getCobbleDollars((class_1657)class_32222)) > 0) {
            sourceStack.method_9213((class_2561)MiscUtilsKt.cobbleDollarsCommand("pay.fail", new Object[0]));
            return 0;
        }
        Object[] objectArray = sourceStack.method_9207();
        Intrinsics.checkNotNull((Object)objectArray);
        class_1657 class_16572 = (class_1657)objectArray;
        BigInteger bigInteger = PlayerExtensionKt.getCobbleDollars((class_1657)objectArray).subtract(amount);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
        PlayerExtensionKt.setCobbleDollars(class_16572, bigInteger);
        class_1657 class_16573 = (class_1657)target;
        BigInteger bigInteger2 = PlayerExtensionKt.getCobbleDollars((class_1657)target).add(amount);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
        PlayerExtensionKt.setCobbleDollars(class_16573, bigInteger2);
        objectArray = new Object[2];
        class_3222 class_32223 = sourceStack.method_44023();
        Intrinsics.checkNotNull((Object)class_32223);
        Intrinsics.checkNotNull((Object)class_32223.method_5476());
        objectArray[1] = TextKt.green((class_5250)BigIntegerExtensionsKt.format$default(amount, false, 1, null));
        target.method_43496((class_2561)MiscUtilsKt.cobbleDollarsCommand("pay.receive", objectArray));
        sourceStack.method_9226(() -> CobbleDollarsCommand.pay$lambda$8(amount, target), true);
        return amount.intValue();
    }

    private final int query(class_2168 sourceStack, class_1657 target) {
        BigInteger cobbleDollars = PlayerExtensionKt.getCobbleDollars(target);
        sourceStack.method_9226(() -> CobbleDollarsCommand.query$lambda$9(target, cobbleDollars), false);
        return cobbleDollars.intValue();
    }

    private final int give(class_2168 sourceStack, Collection<? extends class_3222> targets, BigInteger amount) {
        for (class_3222 class_32222 : targets) {
            class_1657 class_16572 = (class_1657)class_32222;
            BigInteger bigInteger = PlayerExtensionKt.getCobbleDollars((class_1657)class_32222).add(amount);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"add(...)");
            PlayerExtensionKt.setCobbleDollars(class_16572, bigInteger);
        }
        if (targets.size() == 1) {
            sourceStack.method_9226(() -> CobbleDollarsCommand.give$lambda$10(amount, targets), true);
        } else {
            sourceStack.method_9226(() -> CobbleDollarsCommand.give$lambda$11(amount, targets), true);
        }
        return targets.size();
    }

    private final int remove(class_2168 sourceStack, Collection<? extends class_3222> targets, BigInteger amount) {
        for (class_3222 class_32222 : targets) {
            class_1657 class_16572 = (class_1657)class_32222;
            BigInteger bigInteger = PlayerExtensionKt.getCobbleDollars((class_1657)class_32222).subtract((BigInteger)RangesKt.coerceAtMost((Comparable)amount, (Comparable)PlayerExtensionKt.getCobbleDollars((class_1657)class_32222)));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
            PlayerExtensionKt.setCobbleDollars(class_16572, bigInteger);
        }
        if (targets.size() == 1) {
            sourceStack.method_9226(() -> CobbleDollarsCommand.remove$lambda$12(amount, targets), true);
        } else {
            sourceStack.method_9226(() -> CobbleDollarsCommand.remove$lambda$13(amount, targets), true);
        }
        return targets.size();
    }

    private final int set(class_2168 sourceStack, Collection<? extends class_3222> targets, BigInteger amount) {
        for (class_3222 class_32222 : targets) {
            PlayerExtensionKt.setCobbleDollars((class_1657)class_32222, amount);
        }
        if (targets.size() == 1) {
            sourceStack.method_9226(() -> CobbleDollarsCommand.set$lambda$14(amount, targets), true);
        } else {
            sourceStack.method_9226(() -> CobbleDollarsCommand.set$lambda$15(amount, targets), true);
        }
        return targets.size();
    }

    private final int reload(class_2168 sourceStack) {
        CommonConfig.Companion.load();
        ShopConfig.Companion.load();
        BankConfig.Companion.load();
        CobbleDollars.INSTANCE.getSaveExecutor().close();
        MinecraftServer minecraftServer = sourceStack.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        CobbleDollars.INSTANCE.saveSchedule(minecraftServer);
        CobbleDollarsNetwork.INSTANCE.sendToAllPlayers(new SyncShopConfigPacket(CobbleDollars.INSTANCE.getShopConfig().getDefaultShop(), CobbleDollars.INSTANCE.getBankConfig().getBank()));
        sourceStack.method_9226(CobbleDollarsCommand::reload$lambda$16, true);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int displayLeaderboard(class_2168 sourceStack, int page) {
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        sourceStack.method_45068((class_2561)class_2561.method_43473());
        Iterable iterable = CobbleDollars.INSTANCE.getCobbleDollarsAccounts();
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CobbleDollarsAccount cobbleDollarsAccount = (CobbleDollarsAccount)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String playerName = cobbleDollarsAccount.component1();
            BigInteger balance = cobbleDollarsAccount.component2();
            collection.add(new Pair((Object)playerName, (Object)balance));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List leaderboard = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)b;
                boolean bl = false;
                BigInteger balance = (BigInteger)pair.component2();
                pair = (Pair)a;
                Comparable comparable = balance;
                bl = false;
                balance = (BigInteger)pair.component2();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)balance);
            }
        });
        int pageAmount = leaderboard.size() / 10 + 1;
        Duration nextSaveDuration = Duration.between(LocalDateTime.now(), CobbleDollars.INSTANCE.getNextSaveDateTime());
        class_5250 class_52502 = class_2561.method_43470((String)"CobbleDollars Leaderboard");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        class_5250 headerComponent = TextKt.green((class_5250)class_52502);
        if (pageAmount > 1) {
            headerComponent.method_27693(" ").method_10852((class_2561)TextKt.green((String)"(")).method_10852((class_2561)TextKt.darkGreen((String)String.valueOf(page + 1))).method_10852((class_2561)TextKt.green((String)("/" + pageAmount + ")")));
        }
        if (nextSaveDuration.getSeconds() >= 0L) {
            headerComponent.method_27693(" ").method_10852((class_2561)TextKt.darkGray((String)("(" + nextSaveDuration.getSeconds() + "s)")));
        }
        headerComponent.method_10852((class_2561)TextKt.green((String)":"));
        sourceStack.method_45068((class_2561)headerComponent);
        int startIndex = page * 10;
        int endIndex = Math.min(startIndex + 10, leaderboard.size());
        Iterable $this$forEachIndexed$iv = leaderboard.subList(startIndex, endIndex);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            class_5250 class_52503;
            class_5250 rankComponent;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int index = n;
            boolean bl = false;
            String playerName = (String)pair.component1();
            BigInteger balance = (BigInteger)pair.component2();
            int rank = startIndex + index + 1;
            boolean isOdd = rank % 2 == 1;
            class_3222 class_32222 = sourceStack.method_44023();
            boolean isCurrentPlayer = Intrinsics.areEqual((Object)playerName, class_32222 != null && (class_32222 = class_32222.method_5477()) != null ? class_32222.getString() : null);
            if (isCurrentPlayer) {
                class_5250 class_52504 = class_2561.method_43470((String)(rank + ". "));
                Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
                v3 = TextKt.gold((class_5250)class_52504);
            } else if (isOdd) {
                v3 = class_2561.method_43470((String)(rank + ". "));
            } else {
                class_5250 class_52505 = class_2561.method_43470((String)(rank + ". "));
                Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"literal(...)");
                v3 = rankComponent = TextKt.gray((class_5250)class_52505);
            }
            if (isCurrentPlayer) {
                class_5250 class_52506 = class_2561.method_43470((String)playerName);
                Intrinsics.checkNotNullExpressionValue((Object)class_52506, (String)"literal(...)");
                class_52503 = TextKt.gold((class_5250)class_52506);
            } else if (isOdd) {
                class_52503 = class_2561.method_43470((String)playerName);
            } else {
                class_5250 class_52507 = class_2561.method_43470((String)playerName);
                Intrinsics.checkNotNullExpressionValue((Object)class_52507, (String)"literal(...)");
                class_52503 = TextKt.gray((class_5250)class_52507);
            }
            class_5250 nameComponent = class_52503;
            class_5250 balanceComponent = isOdd ? TextKt.green((class_5250)BigIntegerExtensionsKt.format$default(balance, false, 1, null)) : TextKt.darkGreen((class_5250)BigIntegerExtensionsKt.format$default(balance, false, 1, null));
            class_5250 message = rankComponent.method_10852((class_2561)nameComponent).method_27693(" ").method_10852((class_2561)balanceComponent);
            sourceStack.method_45068((class_2561)message);
        }
        boolean hasPreviousPage = page > 0;
        boolean hasNextPage = (page + 1) * 10 < leaderboard.size();
        class_5250 pageSelector = class_2561.method_43473();
        if (hasPreviousPage) {
            class_5250 class_52508 = class_2561.method_43470((String)"<<-");
            Intrinsics.checkNotNullExpressionValue((Object)class_52508, (String)"literal(...)");
            pageSelector.method_10852((class_2561)TextKt.onClick$default((class_5250)TextKt.onHover((class_5250)class_52508, (String)("Page " + page)), (boolean)false, arg_0 -> CobbleDollarsCommand.displayLeaderboard$lambda$20(sourceStack, page, arg_0), (int)1, null));
        }
        if (hasPreviousPage && hasNextPage) {
            pageSelector.method_10852((class_2561)class_2561.method_43470((String)" | "));
        }
        if (hasNextPage) {
            class_5250 class_52509 = class_2561.method_43470((String)"->>");
            Intrinsics.checkNotNullExpressionValue((Object)class_52509, (String)"literal(...)");
            pageSelector.method_10852((class_2561)TextKt.onClick$default((class_5250)TextKt.onHover((class_5250)class_52509, (String)("Page " + (page + 2))), (boolean)false, arg_0 -> CobbleDollarsCommand.displayLeaderboard$lambda$21(sourceStack, page, arg_0), (int)1, null));
        }
        sourceStack.method_45068((class_2561)pageSelector);
        return 1;
    }

    static /* synthetic */ int displayLeaderboard$default(CobbleDollarsCommand cobbleDollarsCommand, class_2168 class_21682, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return cobbleDollarsCommand.displayLeaderboard(class_21682, n);
    }

    private final int updateLeaderboard(class_2168 sourceStack) {
        CobbleDollars.INSTANCE.getSaveExecutor().close();
        MinecraftServer minecraftServer = sourceStack.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        CobbleDollars.INSTANCE.saveSchedule(minecraftServer);
        sourceStack.method_9226(CobbleDollarsCommand::updateLeaderboard$lambda$22, true);
        return 1;
    }

    private static final int register$lambda$0(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        class_3222 class_32222 = class_2186.method_9315((CommandContext)context, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.pay(class_21682, class_32222, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final int register$lambda$1(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        class_3222 class_32222 = class_2186.method_9315((CommandContext)context, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
        return INSTANCE.query(class_21682, (class_1657)class_32222);
    }

    private static final int register$lambda$2(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        Collection collection = class_2186.method_9312((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.give(class_21682, collection, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final int register$lambda$3(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        Collection collection = class_2186.method_9312((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.remove(class_21682, collection, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final int register$lambda$4(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        class_2168 class_21682 = (class_2168)object;
        Collection collection = class_2186.method_9312((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.set(class_21682, collection, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final int register$lambda$5(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.reload((class_2168)object);
    }

    private static final int register$lambda$6(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return CobbleDollarsCommand.displayLeaderboard$default(INSTANCE, (class_2168)object, 0, 2, null);
    }

    private static final int register$lambda$7(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.updateLeaderboard((class_2168)object);
    }

    private static final class_2561 pay$lambda$8(BigInteger $amount, class_3222 $target) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.red((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)$target.method_5476());
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("pay.success", objectArray);
    }

    private static final class_2561 query$lambda$9(class_1657 $target, BigInteger $cobbleDollars) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$cobbleDollars, (String)"$cobbleDollars");
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)$target.method_5476());
        objectArray[1] = TextKt.green((class_5250)BigIntegerExtensionsKt.format$default($cobbleDollars, false, 1, null));
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("query.success", objectArray);
    }

    private static final class_2561 give$lambda$10(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.green((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((class_3222)$targets.iterator().next()).method_5476());
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("give.success.single", objectArray);
    }

    private static final class_2561 give$lambda$11(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.green((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("give.success.multiple", objectArray);
    }

    private static final class_2561 remove$lambda$12(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.red((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((class_3222)$targets.iterator().next()).method_5476());
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("remove.success.single", objectArray);
    }

    private static final class_2561 remove$lambda$13(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.red((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("remove.success.multiple", objectArray);
    }

    private static final class_2561 set$lambda$14(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.green((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((class_3222)$targets.iterator().next()).method_5476());
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("set.success.single", objectArray);
    }

    private static final class_2561 set$lambda$15(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.green((class_5250)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("set.success.multiple", objectArray);
    }

    private static final class_2561 reload$lambda$16() {
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("reload", new Object[0]);
    }

    private static final Unit displayLeaderboard$lambda$20(class_2168 $sourceStack, int $page, class_3222 it) {
        Intrinsics.checkNotNullParameter((Object)$sourceStack, (String)"$sourceStack");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.displayLeaderboard($sourceStack, $page - 1);
        return Unit.INSTANCE;
    }

    private static final Unit displayLeaderboard$lambda$21(class_2168 $sourceStack, int $page, class_3222 it) {
        Intrinsics.checkNotNullParameter((Object)$sourceStack, (String)"$sourceStack");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.displayLeaderboard($sourceStack, $page + 1);
        return Unit.INSTANCE;
    }

    private static final class_2561 updateLeaderboard$lambda$22() {
        return (class_2561)MiscUtilsKt.cobbleDollarsCommand("leaderboard.update", new Object[0]);
    }
}

