/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.network.handlers.server;

import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.network.CobbleDollarsNetwork;
import fr.harmex.cobbledollars.common.network.packets.c2s.BuyPacket;
import fr.harmex.cobbledollars.common.network.packets.s2c.UpdateStockPacket;
import fr.harmex.cobbledollars.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobbledollars.common.world.item.trading.CobbleDollarsShopHolder;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Category;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Offer;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Shop;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0011\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lfr/harmex/cobbledollars/common/network/handlers/server/BuyHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lfr/harmex/cobbledollars/common/network/packets/c2s/BuyPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_3222;", "player", "", "handle", "(Lfr/harmex/cobbledollars/common/network/packets/c2s/BuyPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;)V", "Lnet/minecraft/class_1799;", "items", "Ljava/math/BigInteger;", "price", "buy", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1799;Ljava/math/BigInteger;)V", "common"})
@SourceDebugExtension(value={"SMAP\nBuyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuyHandler.kt\nfr/harmex/cobbledollars/common/network/handlers/server/BuyHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1863#2,2:101\n*S KotlinDebug\n*F\n+ 1 BuyHandler.kt\nfr/harmex/cobbledollars/common/network/handlers/server/BuyHandler\n*L\n58#1:101,2\n*E\n"})
public final class BuyHandler
implements ServerNetworkPacketHandler<BuyPacket> {
    @NotNull
    public static final BuyHandler INSTANCE = new BuyHandler();

    private BuyHandler() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(@NotNull BuyPacket packet, @NotNull MinecraftServer server, @NotNull class_3222 player) {
        class_3218 level;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_5321 dimension = player.method_37908().method_27983();
        class_3218 class_32182 = level = server.method_3847(dimension);
        class_1297 class_12972 = class_32182 != null ? class_32182.method_14190(packet.getMerchantUUID()) : null;
        CobbleDollarsShopHolder cobbleMerchant = class_12972 instanceof CobbleDollarsShopHolder ? (CobbleDollarsShopHolder)class_12972 : null;
        int realAmount = packet.getAmount();
        int obtainableLimit = PlayerExtensionKt.getMaxAmountObtainable((class_1657)player, packet.getOffer().getItem());
        realAmount = RangesKt.coerceAtMost((int)realAmount, (int)obtainableLimit);
        if (packet.getHasMerchant()) {
            Offer offer;
            Object object;
            if (cobbleMerchant == null) return;
            Shop shop = cobbleMerchant.getShop();
            if (shop == null) return;
            if (shop.isEmpty()) {
                shop = CobbleDollars.INSTANCE.getShopConfig().getDefaultShop();
            }
            Offer offer2 = (object = (Category)CollectionsKt.getOrNull((List)shop, (int)packet.getCategoryIndex())) != null && (object = ((Category)object).getOffers()) != null ? (Offer)CollectionsKt.getOrNull((List)((List)object), (int)packet.getOfferIndex()) : (offer = null);
            if (!Intrinsics.areEqual(offer, (Object)packet.getOffer())) return;
            if (offer.getStock() == 0) {
                return;
            }
            if (offer.getStock() > 0) {
                realAmount = RangesKt.coerceAtMost((int)realAmount, (int)offer.getStock());
                offer.setStock(offer.getStock() - realAmount);
                Iterable $this$forEach$iv = cobbleMerchant.getTradingPlayers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_1657 player2 = (class_1657)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)player2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                    CobbleDollarsNetwork.INSTANCE.sendPacketToPlayer((class_3222)player2, new UpdateStockPacket(packet.getCategoryIndex(), packet.getOfferIndex(), offer.getStock(), packet.getMerchantUUID()));
                }
            }
        }
        class_1799 boughtStack = packet.getOffer().getItem().method_46651(realAmount);
        BigInteger bigInteger = packet.getOffer().getPrice();
        BigInteger bigInteger2 = BigInteger.valueOf(realAmount);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"multiply(...)");
        BigInteger totalPrice = bigInteger3;
        if (realAmount <= 0) return;
        Intrinsics.checkNotNull((Object)boughtStack);
        this.buy(player, boughtStack, totalPrice);
    }

    private final void buy(class_3222 player, class_1799 items, BigInteger price) {
        if (PlayerExtensionKt.getCobbleDollars((class_1657)player).compareTo(price) >= 0) {
            class_1657 class_16572 = (class_1657)player;
            BigInteger bigInteger = PlayerExtensionKt.getCobbleDollars((class_1657)player).subtract(price);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
            PlayerExtensionKt.setCobbleDollars(class_16572, bigInteger);
            player.method_7270(items);
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((player.method_59922().method_43057() - player.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f);
            player.field_7512.method_7623();
        }
    }
}

