/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.influence;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.fishing.FishingSpawnCause;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.effect.SaccharineLogBlockParticlesPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u0000 )2\u00020\u0001:\u0001)B\u0013\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\u000f\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J?\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"R\"\u0010#\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/api/spawning/influence/SaccharineLogSlatheredInfluence;", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "Lnet/minecraft/class_2338;", "pos", "<init>", "(Lnet/minecraft/class_2338;)V", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePosition", "", "affectSpawnablePosition", "(Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "action", "Lnet/minecraft/class_1297;", "entity", "affectSpawn", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;Lnet/minecraft/class_1297;)V", "Lnet/minecraft/class_3218;", "level", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "startPos", "Lnet/minecraft/class_2350;", "direction", "attemptSafeMove", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/class_2338;Lnet/minecraft/class_2350;)Lnet/minecraft/class_2338;", "centerPos", "", "searchRadius", "", "allowWater", "searchInHalfCircle", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/class_2338;Lnet/minecraft/class_2350;IZ)Lnet/minecraft/class_2338;", "Lnet/minecraft/class_2338;", "getPos", "()Lnet/minecraft/class_2338;", "activated", "Z", "getActivated", "()Z", "setActivated", "(Z)V", "Companion", "common"})
public final class SaccharineLogSlatheredInfluence
implements SpawningInfluence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final class_2338 pos;
    private boolean activated;
    @NotNull
    public static final String HONEY_DRENCHED_ASPECT = "honey_drenched";
    @NotNull
    public static final String SACCHARINE_LOG_SLATHERED_MARKER = "saccharine_log_slathered";
    public static final double HIDDEN_ABILITY_CHANCE = 0.05;
    public static final int SAFE_BLOCK_SEARCH_DISTANCE = 10;

    public SaccharineLogSlatheredInfluence(@Nullable class_2338 pos) {
        this.pos = pos;
    }

    public /* synthetic */ SaccharineLogSlatheredInfluence(class_2338 class_23382, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            class_23382 = null;
        }
        this(class_23382);
    }

    @Nullable
    public final class_2338 getPos() {
        return this.pos;
    }

    public final boolean getActivated() {
        return this.activated;
    }

    public final void setActivated(boolean bl) {
        this.activated = bl;
    }

    @Override
    public void affectSpawnablePosition(@NotNull SpawnablePosition spawnablePosition) {
        Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
        spawnablePosition.getMarkers().add(SACCHARINE_LOG_SLATHERED_MARKER);
    }

    @Override
    public void affectSpawn(@NotNull SpawnAction<?> action, @NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof PokemonEntity) {
            if (((PokemonEntity)entity).getPokemon().getForcedAspects().contains(HONEY_DRENCHED_ASPECT) || ((PokemonEntity)entity).getPokemon().getAbility().getPriority() != Priority.LOWEST) {
                return;
            }
            if (Math.random() <= 0.05) {
                FishingSpawnCause.Companion.alterHAAttempt((PokemonEntity)entity);
            }
            if (!this.activated) {
                class_2680 blockState;
                class_2338 logPos = this.pos;
                class_3218 level = action.getSpawnablePosition().getWorld().method_8410();
                if (logPos != null && Intrinsics.areEqual((Object)(blockState = level.method_8320(logPos)).method_26204(), (Object)((Object)CobblemonBlocks.SACCHARINE_LOG_SLATHERED))) {
                    class_2350 direction = (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
                    Intrinsics.checkNotNull((Object)level);
                    PokemonEntity pokemonEntity = (PokemonEntity)entity;
                    Intrinsics.checkNotNull((Object)direction);
                    class_2338 safePos = this.attemptSafeMove(level, pokemonEntity, logPos, direction);
                    if (safePos != null) {
                        entity.method_29495(BlockPosExtensionsKt.toVec3d(safePos));
                    }
                    NetworkPacket networkPacket = new SaccharineLogBlockParticlesPacket(logPos, safePos);
                    double d = logPos.method_10263();
                    double d2 = logPos.method_10264();
                    double d3 = logPos.method_10260();
                    class_5321 class_53212 = level.method_27983();
                    Intrinsics.checkNotNullExpressionValue((Object)class_53212, (String)"dimension(...)");
                    NetworkPacket.sendToPlayersAround$default(networkPacket, d, d2, d3, 64.0, class_53212, null, 32, null);
                    level.method_45447(null, logPos, class_3417.field_19149, class_3419.field_15254);
                    class_2350.class_2351 axis = (class_2350.class_2351)blockState.method_11654((class_2769)class_2465.field_11459);
                    class_2680 newState = (class_2680)CobblemonBlocks.SACCHARINE_LOG.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)axis);
                    level.method_8652(logPos, newState, 3);
                }
                Pokemon pokemon = ((PokemonEntity)entity).getPokemon();
                pokemon.setForcedAspects(SetsKt.plus(pokemon.getForcedAspects(), (Object)HONEY_DRENCHED_ASPECT));
                this.activated = true;
            }
        }
    }

    @Nullable
    public final class_2338 attemptSafeMove(@NotNull class_3218 level, @NotNull PokemonEntity entity, @NotNull class_2338 startPos, @NotNull class_2350 direction) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        boolean inWater = entity.method_5799();
        class_2338 originalPos = startPos.method_10093(direction);
        int maxRadius = 10;
        int radius = 0;
        while (true) {
            class_2338 currentPos = null;
            currentPos = originalPos;
            int n = 10;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                class_2338 class_23382 = currentPos;
                Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"element");
                class_2338 safeSpot = this.searchInHalfCircle(level, entity, class_23382, direction, radius, inWater);
                if (safeSpot != null) {
                    return safeSpot;
                }
                currentPos = currentPos.method_10074();
            }
            if (radius == maxRadius) break;
            ++radius;
        }
        return null;
    }

    @Nullable
    public final class_2338 searchInHalfCircle(@NotNull class_3218 level, @NotNull PokemonEntity entity, @NotNull class_2338 centerPos, @NotNull class_2350 direction, int searchRadius, boolean allowWater) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)centerPos, (String)"centerPos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        int dx = -searchRadius;
        if (dx <= searchRadius) {
            while (true) {
                int dz;
                if ((dz = -searchRadius) <= searchRadius) {
                    while (true) {
                        if (dx * dx + dz * dz <= searchRadius * searchRadius) {
                            class_238 currentBox;
                            class_2338 candidatePos = centerPos.method_10069(dx, 0, dz);
                            Vector3d candidateVec = new Vector3d((double)dx, 0.0, (double)dz);
                            Vector3d directionVec = new Vector3d((double)direction.method_10148(), (double)direction.method_10164(), (double)direction.method_10165());
                            double dot = candidateVec.dot((Vector3dc)directionVec);
                            if (dot >= 0.0 && level.method_8587((class_1297)entity, currentBox = entity.method_5829().method_989((double)candidatePos.method_10263() - entity.method_23317(), (double)candidatePos.method_10264() - entity.method_23318(), (double)candidatePos.method_10260() - entity.method_23321()))) {
                                class_2338 blockBelowPos = candidatePos.method_10074();
                                class_2680 blockState = level.method_8320(blockBelowPos);
                                boolean isWater = Intrinsics.areEqual((Object)blockState.method_26204(), (Object)class_2246.field_10382);
                                if (allowWater ? isWater : !blockState.method_26215()) {
                                    return candidatePos;
                                }
                            }
                        }
                        if (dz == searchRadius) break;
                        ++dz;
                    }
                }
                if (dx == searchRadius) break;
                ++dx;
            }
        }
        return null;
    }

    public SaccharineLogSlatheredInfluence() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\t\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/api/spawning/influence/SaccharineLogSlatheredInfluence$Companion;", "", "<init>", "()V", "", "HONEY_DRENCHED_ASPECT", "Ljava/lang/String;", "SACCHARINE_LOG_SLATHERED_MARKER", "", "HIDDEN_ABILITY_CHANCE", "D", "", "SAFE_BLOCK_SEARCH_DISTANCE", "I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

