/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0014\u001a\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00168\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/command/PcSearchCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lnet/minecraft/class_5250;", "label", "value", "formatField", "(Lnet/minecraft/class_5250;Lnet/minecraft/class_5250;)Lnet/minecraft/class_5250;", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/class_3222;", "player", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_3222;)I", "", "NAME", "Ljava/lang/String;", "PROPERTIES", "OTHER", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "IN_BATTLE_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "common"})
@SourceDebugExtension(value={"SMAP\nPcSearchCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PcSearchCommand.kt\ncom/cobblemon/mod/common/command/PcSearchCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1878#2,3:121\n1869#2,2:124\n*S KotlinDebug\n*F\n+ 1 PcSearchCommand.kt\ncom/cobblemon/mod/common/command/PcSearchCommand\n*L\n70#1:121,3\n113#1:124,2\n*E\n"})
public final class PcSearchCommand {
    @NotNull
    public static final PcSearchCommand INSTANCE = new PcSearchCommand();
    @NotNull
    private static final String NAME = "pcsearch";
    @NotNull
    private static final String PROPERTIES = "properties";
    @NotNull
    private static final String OTHER = "other";
    @NotNull
    private static final SimpleCommandExceptionType IN_BATTLE_EXCEPTION;

    private PcSearchCommand() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = class_2170.method_9247((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getPC_SEARCH(), false, 2, null)).then(class_2170.method_9244((String)PROPERTIES, (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(PcSearchCommand::register$lambda$0))).then(class_2170.method_9247((String)OTHER).then(class_2170.method_9244((String)OTHER, (ArgumentType)((ArgumentType)class_2186.method_9305())).then(class_2170.method_9244((String)PROPERTIES, (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(PcSearchCommand::register$lambda$1)))));
    }

    private final class_5250 formatField(class_5250 label, class_5250 value) {
        return TextKt.add(TextKt.aqua(TextKt.add(label, ": ")), (class_2561)TextKt.yellow(value));
    }

    /*
     * WARNING - void declaration
     */
    private final int execute(CommandContext<class_2168> context, class_3222 player) {
        if (PlayerExtensionsKt.isInBattle(player)) {
            CommandSyntaxException commandSyntaxException = IN_BATTLE_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        PokemonProperties pokemonProperties = PokemonPropertiesArgumentType.Companion.getPokemonProperties(context, PROPERTIES);
        PCStore pc = PlayerExtensionsKt.pc(player);
        List matchingPokemon = new ArrayList();
        Object[] $this$forEachIndexed$iv = (Object[])pc.getBoxes();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object t : $this$forEachIndexed$iv) {
            void box;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PCBox pCBox = (PCBox)t;
            int boxIndex = n;
            boolean bl = false;
            Map<Integer, Pokemon> nonEmptySlots = box.getNonEmptySlots();
            for (Map.Entry<Integer, Pokemon> entry : nonEmptySlots.entrySet()) {
                int slotIndex = ((Number)entry.getKey()).intValue();
                Pokemon pokemon = entry.getValue();
                if (!pokemonProperties.matches(pokemon)) continue;
                int boxNumber = boxIndex + 1;
                class_5250 displayName = pokemon.getSpecies().getTranslatedName();
                int level = pokemon.getLevel();
                Object[] objectArray = new Object[2];
                objectArray[0] = displayName;
                Object[] objectArray2 = new Object[]{level};
                Intrinsics.checkNotNullExpressionValue((Object)LocalizationUtilsKt.lang("label.lv", objectArray2), (String)"lang(...)");
                class_5250 class_52502 = LocalizationUtilsKt.commandLang("pcsearch.entry", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"commandLang(...)");
                class_5250 baseText = TextKt.yellow(class_52502);
                class_5250 class_52503 = class_2561.method_43470((String)"");
                Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
                class_5250 class_52504 = LocalizationUtilsKt.lang("ui.info.species", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"lang(...)");
                class_5250 class_52505 = TextKt.add(TextKt.add(class_52503, (class_2561)INSTANCE.formatField(class_52504, displayName)), " ");
                Object[] objectArray3 = new Object[]{level};
                class_5250 class_52506 = LocalizationUtilsKt.lang("label.lv", objectArray3);
                Intrinsics.checkNotNullExpressionValue((Object)class_52506, (String)"lang(...)");
                class_5250 class_52507 = TextKt.add(TextKt.add(class_52505, (class_2561)class_52506), "\n");
                class_5250 class_52508 = LocalizationUtilsKt.lang("ui.info.gender", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52508, (String)"lang(...)");
                String string = pokemon.getGender().name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                class_5250 class_52509 = LocalizationUtilsKt.lang("gender." + string, new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52509, (String)"lang(...)");
                class_5250 class_525010 = TextKt.add(TextKt.add(class_52507, (class_2561)INSTANCE.formatField(class_52508, class_52509)), "\n");
                class_5250 class_525011 = LocalizationUtilsKt.lang("ui.info.nature", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_525011, (String)"lang(...)");
                class_5250 class_525012 = MiscUtilsKt.asTranslated(pokemon.getNature().getDisplayName());
                Intrinsics.checkNotNullExpressionValue((Object)class_525012, (String)"asTranslated(...)");
                class_5250 class_525013 = TextKt.add(TextKt.add(class_525010, (class_2561)INSTANCE.formatField(class_525011, class_525012)), "\n");
                class_5250 class_525014 = LocalizationUtilsKt.lang("ui.info.ability", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_525014, (String)"lang(...)");
                class_5250 class_525015 = MiscUtilsKt.asTranslated(pokemon.getAbility().getDisplayName());
                Intrinsics.checkNotNullExpressionValue((Object)class_525015, (String)"asTranslated(...)");
                class_5250 class_525016 = TextKt.add(TextKt.add(class_525013, (class_2561)INSTANCE.formatField(class_525014, class_525015)), "\n");
                class_5250 class_525017 = LocalizationUtilsKt.lang("ui.stats.ivs", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_525017, (String)"lang(...)");
                class_5250 class_525018 = TextKt.add(TextKt.add(class_525016, (class_2561)TextKt.add(TextKt.aqua(TextKt.add(class_525017, ": ")), (class_2561)TextKt.yellow(pokemon.getIvs().get(Stats.HP) + "/" + pokemon.getIvs().get(Stats.ATTACK) + "/" + pokemon.getIvs().get(Stats.DEFENCE) + "/" + pokemon.getIvs().get(Stats.SPEED) + "/" + pokemon.getIvs().get(Stats.SPECIAL_ATTACK) + "/" + pokemon.getIvs().get(Stats.SPECIAL_DEFENCE)))), "\n");
                class_5250 class_525019 = LocalizationUtilsKt.lang("ui.stats.evs", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_525019, (String)"lang(...)");
                class_5250 hoverText = TextKt.add(class_525018, (class_2561)TextKt.add(TextKt.aqua(TextKt.add(class_525019, ": ")), (class_2561)TextKt.yellow(pokemon.getEvs().get(Stats.HP) + "/" + pokemon.getEvs().get(Stats.ATTACK) + "/" + pokemon.getEvs().get(Stats.DEFENCE) + "/" + pokemon.getEvs().get(Stats.SPEED) + "/" + pokemon.getEvs().get(Stats.SPECIAL_ATTACK) + "/" + pokemon.getEvs().get(Stats.SPECIAL_DEFENCE))));
                if (pokemon.getShiny()) {
                    class_5250 class_525020 = TextKt.add(hoverText, "\n");
                    class_5250 class_525021 = LocalizationUtilsKt.commandLang("pcsearch.tooltip.shiny", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)class_525021, (String)"commandLang(...)");
                    TextKt.add(class_525020, (class_2561)TextKt.gold(class_525021));
                }
                TextKt.onHover(baseText, hoverText);
                objectArray2 = new Object[]{boxNumber, slotIndex + 1};
                class_5250 class_525022 = LocalizationUtilsKt.commandLang("pcsearch.location", objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)class_525022, (String)"commandLang(...)");
                class_5250 class_525023 = TextKt.green(class_525022);
                class_5250 class_525024 = LocalizationUtilsKt.commandLang("pcsearch.takepokemon", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_525024, (String)"commandLang(...)");
                class_5250 locationText = TextKt.suggest(TextKt.onHover(class_525023, class_525024), "/pctake " + player.method_5477().getString() + " " + boxNumber + " " + (slotIndex + 1));
                matchingPokemon.add(TextKt.add(baseText, (class_2561)locationText));
            }
        }
        if (matchingPokemon.isEmpty()) {
            class_2168 class_21682 = (class_2168)context.getSource();
            $this$forEachIndexed$iv = new Object[2];
            $this$forEachIndexed$iv[0] = pokemonProperties.getOriginalString();
            Intrinsics.checkNotNullExpressionValue((Object)player.method_5477().getString(), (String)"getString(...)");
            class_21682.method_45068((class_2561)LocalizationUtilsKt.commandLang("pcsearch.nomatch", $this$forEachIndexed$iv));
        } else {
            class_2168 class_21683 = (class_2168)context.getSource();
            $this$forEachIndexed$iv = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)player.method_5477().getString(), (String)"getString(...)");
            class_21683.method_45068((class_2561)LocalizationUtilsKt.commandLang("pcsearch.found", $this$forEachIndexed$iv));
            Iterable $this$forEach$iv = matchingPokemon;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_5250 class_525025 = (class_5250)element$iv;
                boolean bl = false;
                ((class_2168)context.getSource()).method_45068((class_2561)class_525025);
            }
        }
        return 1;
    }

    private static final int register$lambda$0(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        class_3222 class_32222 = ((class_2168)it.getSource()).method_9207();
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayerOrException(...)");
        return INSTANCE.execute((CommandContext<class_2168>)it, class_32222);
    }

    private static final int register$lambda$1(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        class_3222 class_32222 = class_2186.method_9315((CommandContext)it, (String)OTHER);
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
        return INSTANCE.execute((CommandContext<class_2168>)it, class_32222);
    }

    static {
        class_5250 class_52502 = LocalizationUtilsKt.lang("pc.inbattle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
        IN_BATTLE_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(class_52502));
    }
}

