/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.sensors;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.ai.sensors.BeeHiveSensor;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4153;
import net.minecraft.class_4482;
import net.minecraft.class_6880;
import net.minecraft.class_7473;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u001f\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/sensors/BeeHiveSensor;", "Lnet/minecraft/class_4148;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "()V", "", "Lnet/minecraft/class_4140;", "", "requires", "()Ljava/util/Set;", "Lnet/minecraft/class_3218;", "world", "entity", "", "doTick", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lnet/minecraft/class_2680;", "state", "", "isValidHive", "(Lnet/minecraft/class_2680;)Z", "isHiveBlock", "Lnet/minecraft/class_2338;", "pos", "hasReachableAdjacentSide", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Z", "", "findNearbyHivesWithSpace", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Ljava/util/List;", "hivePos", "Lnet/minecraft/class_1937;", "doesHiveHaveSpace", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_1937;)Z", "common"})
public final class BeeHiveSensor
extends class_4148<PokemonEntity> {
    public BeeHiveSensor() {
        super(300);
    }

    @NotNull
    public Set<class_4140<? extends Object>> method_19099() {
        Object[] objectArray = new class_4140[]{CobblemonMemories.HIVE_LOCATION, CobblemonMemories.HIVE_BLACKLIST};
        return SetsKt.setOf((Object[])objectArray);
    }

    protected void doTick(@NotNull class_3218 world, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        class_4095<PokemonEntity> brain = entity.method_18868();
        class_2338 currentHive = brain.method_18904(CobblemonMemories.HIVE_LOCATION).orElse(null);
        if (currentHive != null) {
            class_2680 state = world.method_8320(currentHive);
            Intrinsics.checkNotNull((Object)state);
            if (!this.isValidHive(state) || !this.hasReachableAdjacentSide(world, currentHive)) {
                brain.method_18875(CobblemonMemories.HIVE_LOCATION);
            } else {
                return;
            }
        }
        class_2338 closestHivePos = null;
        List<class_2338> list = this.findNearbyHivesWithSpace(entity);
        if (!list.isEmpty()) {
            List blackList = brain.method_18904(CobblemonMemories.HIVE_BLACKLIST).orElse(CollectionsKt.emptyList());
            for (class_2338 blockPos : list) {
                if (blackList.contains(blockPos) || !this.hasReachableAdjacentSide(world, blockPos)) continue;
                closestHivePos = blockPos;
                break;
            }
            if (closestHivePos == null) {
                brain.method_18875(CobblemonMemories.HIVE_BLACKLIST);
                closestHivePos = (class_2338)CollectionsKt.first(list);
            }
        }
        if (closestHivePos != null) {
            brain.method_18878(CobblemonMemories.HIVE_LOCATION, closestHivePos);
        }
    }

    private final boolean isValidHive(class_2680 state) {
        return this.isHiveBlock(state);
    }

    private final boolean isHiveBlock(class_2680 state) {
        return state.method_27852(class_2246.field_20422) || state.method_27852(class_2246.field_20421);
    }

    private final boolean hasReachableAdjacentSide(class_3218 world, class_2338 pos) {
        for (class_2350 dir : EntriesMappings.entries$0) {
            class_2338 adjacentPos = pos.method_10093(dir);
            if (!world.method_22347(adjacentPos)) continue;
            return true;
        }
        return false;
    }

    private final List<class_2338> findNearbyHivesWithSpace(PokemonEntity entity) {
        class_2338 blockPos = entity.method_24515();
        class_1937 class_19372 = entity.method_37908();
        Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        class_4153 poiManager = ((class_3218)class_19372).method_19494();
        Stream stream = poiManager.method_19125(BeeHiveSensor::findNearbyHivesWithSpace$lambda$0, blockPos, 20, class_4153.class_4155.field_18489);
        List<Object> list = stream.map(arg_0 -> BeeHiveSensor.findNearbyHivesWithSpace$lambda$1(findNearbyHivesWithSpace.1.INSTANCE, arg_0)).filter(arg_0 -> BeeHiveSensor.findNearbyHivesWithSpace$lambda$3(arg_0 -> BeeHiveSensor.findNearbyHivesWithSpace$lambda$2(this, entity, arg_0), arg_0)).sorted((arg_0, arg_1) -> BeeHiveSensor.findNearbyHivesWithSpace$lambda$5((arg_0, arg_1) -> BeeHiveSensor.findNearbyHivesWithSpace$lambda$4(blockPos, arg_0, arg_1), arg_0, arg_1)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    private final boolean doesHiveHaveSpace(class_2338 hivePos, class_1937 world) {
        class_2586 blockEntity = world.method_8321(hivePos);
        if (blockEntity instanceof class_4482) {
            return !((class_4482)blockEntity).method_21856();
        }
        return false;
    }

    private static final boolean findNearbyHivesWithSpace$lambda$0(class_6880 holder) {
        return holder.method_40220(class_7473.field_39264);
    }

    private static final class_2338 findNearbyHivesWithSpace$lambda$1(Function1 $tmp0, Object p0) {
        return (class_2338)$tmp0.invoke(p0);
    }

    private static final boolean findNearbyHivesWithSpace$lambda$2(BeeHiveSensor this$0, PokemonEntity $entity, class_2338 pos) {
        Intrinsics.checkNotNull((Object)pos);
        class_1937 class_19372 = $entity.method_37908();
        Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"level(...)");
        return this$0.doesHiveHaveSpace(pos, class_19372);
    }

    private static final boolean findNearbyHivesWithSpace$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int findNearbyHivesWithSpace$lambda$4(class_2338 $blockPos, class_2338 pos1, class_2338 pos2) {
        return (int)pos1.method_10262((class_2382)$blockPos) - (int)pos2.method_10262((class_2382)$blockPos);
    }

    private static final int findNearbyHivesWithSpace$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<class_2350> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])class_2350.values()));
        }
    }
}

