/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.stat;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.StatProvider;
import com.cobblemon.mod.common.api.pokemon.stats.StatTypeAdapter;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.net.IntSize;
import com.cobblemon.mod.common.pokemon.EVs;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.adapters.CobblemonStatTypeAdapter;
import com.cobblemon.mod.common.util.NetExtensionsKt;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0013J!\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\"\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0019\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u00052\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b(\u0010'J\u0017\u0010+\u001a\u00020\u00052\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b+\u0010,J\u001f\u0010-\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020)2\u0006\u0010!\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b-\u0010.J#\u00101\u001a\u00020\u000e2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0/H\u0002\u00a2\u0006\u0004\b1\u00102J\u0017\u00104\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b4\u00105J\u0017\u00106\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b6\u00107R\u001a\u00109\u001a\u0002088\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<R \u0010?\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020>0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R \u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020>0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010@R \u0010B\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001a0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010@\u00a8\u0006C"}, d2={"Lcom/cobblemon/mod/common/pokemon/stat/CobblemonStatProvider;", "Lcom/cobblemon/mod/common/api/pokemon/stats/StatProvider;", "<init>", "()V", "", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "all", "()Ljava/util/Collection;", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat$Type;", "type", "ofType", "(Lcom/cobblemon/mod/common/api/pokemon/stats/Stat$Type;)Ljava/util/Collection;", "Lcom/cobblemon/mod/common/pokemon/Species;", "species", "", "provide", "(Lcom/cobblemon/mod/common/pokemon/Species;)V", "Lcom/cobblemon/mod/common/pokemon/FormData;", "form", "(Lcom/cobblemon/mod/common/pokemon/FormData;)V", "", "toShowdown", "(Lcom/cobblemon/mod/common/pokemon/Species;Lcom/cobblemon/mod/common/pokemon/FormData;)Ljava/lang/String;", "Lcom/cobblemon/mod/common/pokemon/EVs;", "createEmptyEVs", "()Lcom/cobblemon/mod/common/pokemon/EVs;", "", "minPerfectIVs", "Lcom/cobblemon/mod/common/pokemon/IVs;", "createEmptyIVs", "(I)Lcom/cobblemon/mod/common/pokemon/IVs;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "stat", "getStatForPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;)I", "Lnet/minecraft/class_2960;", "identifier", "fromIdentifier", "(Lnet/minecraft/class_2960;)Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "fromIdentifierOrThrow", "Lnet/minecraft/class_9129;", "buffer", "decode", "(Lnet/minecraft/class_9129;)Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "encode", "(Lnet/minecraft/class_9129;Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;)V", "", "map", "allocate", "(Ljava/util/Map;)V", "ordinal", "ordinalLookup", "(I)Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "identifierLookup", "(Lnet/minecraft/class_2960;)I", "Lcom/cobblemon/mod/common/api/pokemon/stats/StatTypeAdapter;", "typeAdapter", "Lcom/cobblemon/mod/common/api/pokemon/stats/StatTypeAdapter;", "getTypeAdapter", "()Lcom/cobblemon/mod/common/api/pokemon/stats/StatTypeAdapter;", "", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stats;", "stats", "Ljava/util/Map;", "ordinalToStat", "identifierToOrdinal", "common"})
@SourceDebugExtension(value={"SMAP\nCobblemonStatProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblemonStatProvider.kt\ncom/cobblemon/mod/common/pokemon/stat/CobblemonStatProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1#2:137\n1869#3,2:138\n1869#3,2:140\n1208#3,2:142\n1236#3,4:144\n1208#3,2:148\n1236#3,4:150\n1193#3,2:154\n1267#3,4:156\n*S KotlinDebug\n*F\n+ 1 CobblemonStatProvider.kt\ncom/cobblemon/mod/common/pokemon/stat/CobblemonStatProvider\n*L\n64#1:138,2\n121#1:140,2\n38#1:142,2\n38#1:144,4\n39#1:148,2\n39#1:150,4\n40#1:154,2\n40#1:156,4\n*E\n"})
public final class CobblemonStatProvider
implements StatProvider {
    @NotNull
    public static final CobblemonStatProvider INSTANCE;
    @NotNull
    private static final StatTypeAdapter typeAdapter;
    @NotNull
    private static final Map<class_2960, Stats> stats;
    @NotNull
    private static final Map<Integer, Stats> ordinalToStat;
    @NotNull
    private static final Map<class_2960, Integer> identifierToOrdinal;

    private CobblemonStatProvider() {
    }

    @Override
    @NotNull
    public StatTypeAdapter getTypeAdapter() {
        return typeAdapter;
    }

    @Override
    @NotNull
    public Collection<Stat> all() {
        return Stats.Companion.getALL();
    }

    @Override
    @NotNull
    public Collection<Stat> ofType(@NotNull Stat.Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> Stats.Companion.getBATTLE_ONLY();
            case 2 -> Stats.Companion.getPERMANENT();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public void provide(@NotNull Species species) {
        Intrinsics.checkNotNullParameter((Object)species, (String)"species");
        this.allocate((Map<Stat, Integer>)species.getBaseStats());
    }

    @Override
    public void provide(@NotNull FormData form) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)form, (String)"form");
            Map<Stat, Integer> map = form.get_baseStats$common();
            if (map == null) break block0;
            Map<Stat, Integer> it = map;
            boolean bl = false;
            INSTANCE.allocate(it);
        }
    }

    @Override
    @NotNull
    public String toShowdown(@NotNull Species species, @Nullable FormData form) {
        Intrinsics.checkNotNullParameter((Object)species, (String)"species");
        Object object = form;
        if (object == null || (object = ((FormData)object).getBaseStats()) == null) {
            object = species.getBaseStats();
        }
        Object baseStats = object;
        return "baseStats: { hp: " + baseStats.get(Stats.HP) + ", atk: " + baseStats.get(Stats.ATTACK) + ", def: " + baseStats.get(Stats.DEFENCE) + ", spa: " + baseStats.get(Stats.SPECIAL_ATTACK) + ", spd: " + baseStats.get(Stats.SPECIAL_DEFENCE) + ", spe: " + baseStats.get(Stats.SPEED) + " }";
    }

    @Override
    @NotNull
    public EVs createEmptyEVs() {
        EVs evs = new EVs();
        Iterable $this$forEach$iv = this.ofType(Stat.Type.PERMANENT);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stat stat = (Stat)element$iv;
            boolean bl = false;
            evs.set(stat, evs.getDefaultValue());
        }
        return evs;
    }

    @Override
    @NotNull
    public IVs createEmptyIVs(int minPerfectIVs) {
        IVs ivs = new IVs();
        for (Stat stat : this.ofType(Stat.Type.PERMANENT)) {
            ivs.set(stat, Random.Default.nextInt(32));
        }
        if (minPerfectIVs > 0) {
            List perfectStats = CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)this.ofType(Stat.Type.PERMANENT)), (int)minPerfectIVs);
            for (Stat stat : perfectStats) {
                ivs.set(stat, 31);
            }
        }
        return ivs;
    }

    @Override
    public int getStatForPokemon(@NotNull Pokemon pokemon, @NotNull Stat stat) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        int iv = pokemon.getIvs().getEffectiveBattleIV(stat);
        Integer n = pokemon.getForm().getBaseStats().get(stat);
        Intrinsics.checkNotNull((Object)n);
        int base = ((Number)n).intValue();
        int ev = pokemon.getEvs().getOrDefault(stat);
        int level = pokemon.getLevel();
        return stat == Stats.HP ? (Intrinsics.areEqual((Object)pokemon.getSpecies().getResourceIdentifier(), (Object)Pokemon.Companion.getSHEDINJA$common()) ? 1 : (int)MathKt.truncate((double)(MathKt.truncate((double)(2.0 * (double)base + (double)iv + MathKt.truncate((double)((double)ev / 4.0)) + (double)100)) * (double)level / 100.0 + (double)10))) : pokemon.getEffectiveNature().modifyStat(stat, (2 * base + iv + ev / 4) * level / 100 + 5);
    }

    @Override
    @Nullable
    public Stat fromIdentifier(@NotNull class_2960 identifier2) {
        Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
        return stats.get(identifier2);
    }

    @Override
    @NotNull
    public Stat fromIdentifierOrThrow(@NotNull class_2960 identifier2) {
        Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
        Stat stat = this.fromIdentifier(identifier2);
        if (stat == null) {
            throw new IllegalArgumentException("No stat was found with the identifier " + identifier2);
        }
        return stat;
    }

    @Override
    @NotNull
    public Stat decode(@NotNull class_9129 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int ordinal = NetExtensionsKt.readSizedInt((ByteBuf)buffer, IntSize.U_BYTE);
        return this.ordinalLookup(ordinal);
    }

    @Override
    public void encode(@NotNull class_9129 buffer, @NotNull Stat stat) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        int ordinal = this.identifierLookup(stat.getIdentifier());
        NetExtensionsKt.writeSizedInt((ByteBuf)buffer, IntSize.U_BYTE, ordinal);
    }

    private final void allocate(Map<Stat, Integer> map) {
        Iterable $this$forEach$iv = Stats.Companion.getPERMANENT();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stat stat = (Stat)element$iv;
            boolean bl = false;
            map.putIfAbsent(stat, 1);
        }
    }

    private final Stat ordinalLookup(int ordinal) {
        Stats stats = ordinalToStat.get(ordinal);
        if (stats == null) {
            throw new IllegalArgumentException("Cannot find the stat with the ordinal " + ordinal + ", this should only happen if there is a custom Stat implementation but no StatProvider to go alongside it");
        }
        return stats;
    }

    private final int identifierLookup(class_2960 identifier2) {
        Integer n = identifierToOrdinal.get(identifier2);
        if (n == null) {
            throw new IllegalArgumentException("Cannot find the stat to encode, this should only happen if there is a custom Stat implementation but no StatProvider to go alongside it on the server side");
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateTo$iv$iv;
        Stats it;
        Map map;
        Object object;
        Iterable $this$associateByTo$iv$iv;
        INSTANCE = new CobblemonStatProvider();
        typeAdapter = CobblemonStatTypeAdapter.INSTANCE;
        Iterable $this$associateBy$iv = (Iterable)Stats.getEntries();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            object = (Stats)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getIdentifier(), element$iv$iv);
        }
        stats = destination$iv$iv;
        $this$associateBy$iv = (Iterable)Stats.getEntries();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it = (Stats)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.ordinal(), element$iv$iv);
        }
        ordinalToStat = destination$iv$iv;
        Iterable $this$associate$iv = (Iterable)Stats.getEntries();
        boolean $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv;
            Stats it2 = (Stats)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it2.getIdentifier(), (Object)it2.ordinal());
            object.put(pair.getFirst(), pair.getSecond());
        }
        identifierToOrdinal = destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Stat.Type.values().length];
            try {
                nArray[Stat.Type.BATTLE_ONLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stat.Type.PERMANENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

