/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.client.internal;

import com.cobblemon.mod.relocations.mongodb.AutoEncryptionSettings;
import com.cobblemon.mod.relocations.mongodb.ClientEncryptionSettings;
import com.cobblemon.mod.relocations.mongodb.MongoClientSettings;
import com.cobblemon.mod.relocations.mongodb.MongoNamespace;
import com.cobblemon.mod.relocations.mongodb.client.MongoClient;
import com.cobblemon.mod.relocations.mongodb.client.MongoClients;
import com.cobblemon.mod.relocations.mongodb.client.internal.CollectionInfoRetriever;
import com.cobblemon.mod.relocations.mongodb.client.internal.CommandMarker;
import com.cobblemon.mod.relocations.mongodb.client.internal.Crypt;
import com.cobblemon.mod.relocations.mongodb.client.internal.KeyManagementService;
import com.cobblemon.mod.relocations.mongodb.client.internal.KeyRetriever;
import com.cobblemon.mod.relocations.mongodb.client.internal.MongoClientImpl;
import com.cobblemon.mod.relocations.mongodb.crypt.capi.MongoCrypt;
import com.cobblemon.mod.relocations.mongodb.crypt.capi.MongoCryptOptions;
import com.cobblemon.mod.relocations.mongodb.crypt.capi.MongoCrypts;
import com.cobblemon.mod.relocations.mongodb.internal.capi.MongoCryptHelper;
import java.util.Map;
import javax.net.ssl.SSLContext;

public final class Crypts {
    public static Crypt createCrypt(MongoClientImpl client, AutoEncryptionSettings settings) {
        MongoClient sharedInternalClient = null;
        MongoClientSettings keyVaultMongoClientSettings = settings.getKeyVaultMongoClientSettings();
        if (keyVaultMongoClientSettings == null || !settings.isBypassAutoEncryption()) {
            MongoClientSettings defaultInternalMongoClientSettings = MongoClientSettings.builder(client.getSettings()).applyToConnectionPoolSettings(builder -> builder.minSize(0)).autoEncryptionSettings(null).build();
            sharedInternalClient = MongoClients.create(defaultInternalMongoClientSettings);
        }
        MongoClient keyVaultClient = keyVaultMongoClientSettings == null ? sharedInternalClient : MongoClients.create(keyVaultMongoClientSettings);
        MongoCrypt mongoCrypt = MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings));
        return new Crypt(mongoCrypt, Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers(), settings.isBypassAutoEncryption(), settings.isBypassAutoEncryption() ? null : new CollectionInfoRetriever(sharedInternalClient), new CommandMarker(mongoCrypt, settings), sharedInternalClient, keyVaultClient);
    }

    static Crypt create(MongoClient keyVaultClient, ClientEncryptionSettings settings) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings)), Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers());
    }

    private static KeyRetriever createKeyRetriever(MongoClient keyVaultClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService(Map<String, SSLContext> kmsProviderSslContextMap) {
        return new KeyManagementService(kmsProviderSslContextMap, 10000);
    }

    private Crypts() {
    }
}

