/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.connection;

import com.cobblemon.mod.relocations.mongodb.LoggerSettings;
import com.cobblemon.mod.relocations.mongodb.MongoCompressor;
import com.cobblemon.mod.relocations.mongodb.MongoDriverInformation;
import com.cobblemon.mod.relocations.mongodb.ServerApi;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.connection.ClusterConnectionMode;
import com.cobblemon.mod.relocations.mongodb.connection.ServerId;
import com.cobblemon.mod.relocations.mongodb.connection.StreamFactory;
import com.cobblemon.mod.relocations.mongodb.event.CommandListener;
import com.cobblemon.mod.relocations.mongodb.internal.connection.Authenticator;
import com.cobblemon.mod.relocations.mongodb.internal.connection.AwsAuthenticator;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ClientMetadataHelper;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ConnectionGenerationSupplier;
import com.cobblemon.mod.relocations.mongodb.internal.connection.DefaultAuthenticator;
import com.cobblemon.mod.relocations.mongodb.internal.connection.GSSAPIAuthenticator;
import com.cobblemon.mod.relocations.mongodb.internal.connection.InternalConnection;
import com.cobblemon.mod.relocations.mongodb.internal.connection.InternalConnectionFactory;
import com.cobblemon.mod.relocations.mongodb.internal.connection.InternalStreamConnection;
import com.cobblemon.mod.relocations.mongodb.internal.connection.InternalStreamConnectionInitializer;
import com.cobblemon.mod.relocations.mongodb.internal.connection.MongoCredentialWithCache;
import com.cobblemon.mod.relocations.mongodb.internal.connection.PlainAuthenticator;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ScramShaAuthenticator;
import com.cobblemon.mod.relocations.mongodb.internal.connection.X509Authenticator;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import com.cobblemon.mod.relocations.mongodb.spi.dns.InetAddressResolver;
import java.util.List;
import org.bson.BsonDocument;

class InternalStreamConnectionFactory
implements InternalConnectionFactory {
    private final ClusterConnectionMode clusterConnectionMode;
    private final boolean isMonitoringConnection;
    private final StreamFactory streamFactory;
    private final BsonDocument clientMetadataDocument;
    private final List<MongoCompressor> compressorList;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    @Nullable
    private final ServerApi serverApi;
    private final InetAddressResolver inetAddressResolver;
    private final MongoCredentialWithCache credential;

    InternalStreamConnectionFactory(ClusterConnectionMode clusterConnectionMode, StreamFactory streamFactory, @Nullable MongoCredentialWithCache credential, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable ServerApi serverApi, @Nullable InetAddressResolver inetAddressResolver) {
        this(clusterConnectionMode, false, streamFactory, credential, applicationName, mongoDriverInformation, compressorList, loggerSettings, commandListener, serverApi, inetAddressResolver);
    }

    InternalStreamConnectionFactory(ClusterConnectionMode clusterConnectionMode, boolean isMonitoringConnection, StreamFactory streamFactory, @Nullable MongoCredentialWithCache credential, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable ServerApi serverApi, @Nullable InetAddressResolver inetAddressResolver) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.isMonitoringConnection = isMonitoringConnection;
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.compressorList = Assertions.notNull("compressorList", compressorList);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.serverApi = serverApi;
        this.inetAddressResolver = inetAddressResolver;
        this.clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(applicationName, mongoDriverInformation);
        this.credential = credential;
    }

    @Override
    public InternalConnection create(ServerId serverId, ConnectionGenerationSupplier connectionGenerationSupplier) {
        Authenticator authenticator = this.credential == null ? null : this.createAuthenticator(this.credential);
        return new InternalStreamConnection(this.clusterConnectionMode, this.isMonitoringConnection, serverId, connectionGenerationSupplier, this.streamFactory, this.compressorList, this.loggerSettings, this.commandListener, new InternalStreamConnectionInitializer(this.clusterConnectionMode, authenticator, this.clientMetadataDocument, this.compressorList, this.serverApi), this.inetAddressResolver);
    }

    private Authenticator createAuthenticator(MongoCredentialWithCache credential) {
        if (credential.getAuthenticationMechanism() == null) {
            return new DefaultAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
        }
        switch (Assertions.assertNotNull(credential.getAuthenticationMechanism())) {
            case GSSAPI: {
                return new GSSAPIAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case PLAIN: {
                return new PlainAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_X509: {
                return new X509Authenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case SCRAM_SHA_1: 
            case SCRAM_SHA_256: {
                return new ScramShaAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_AWS: {
                return new AwsAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
        }
        throw new IllegalArgumentException("Unsupported authentication mechanism " + (Object)((Object)credential.getAuthenticationMechanism()));
    }
}

