/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.operation;

import com.cobblemon.mod.relocations.mongodb.WriteConcern;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.client.model.Collation;
import com.cobblemon.mod.relocations.mongodb.internal.async.ErrorHandlingResultCallback;
import com.cobblemon.mod.relocations.mongodb.internal.async.SingleResultCallback;
import com.cobblemon.mod.relocations.mongodb.internal.binding.AsyncWriteBinding;
import com.cobblemon.mod.relocations.mongodb.internal.binding.WriteBinding;
import com.cobblemon.mod.relocations.mongodb.internal.operation.AsyncWriteOperation;
import com.cobblemon.mod.relocations.mongodb.internal.operation.CommandOperationHelper;
import com.cobblemon.mod.relocations.mongodb.internal.operation.OperationHelper;
import com.cobblemon.mod.relocations.mongodb.internal.operation.WriteConcernHelper;
import com.cobblemon.mod.relocations.mongodb.internal.operation.WriteOperation;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.codecs.BsonDocumentCodec;

public class CreateViewOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final String databaseName;
    private final String viewName;
    private final String viewOn;
    private final List<BsonDocument> pipeline;
    private final WriteConcern writeConcern;
    private Collation collation;

    public CreateViewOperation(String databaseName, String viewName, String viewOn, List<BsonDocument> pipeline, WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.viewName = Assertions.notNull("viewName", viewName);
        this.viewOn = Assertions.notNull("viewOn", viewOn);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getViewOn() {
        return this.viewOn;
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CreateViewOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, connection -> {
            CommandOperationHelper.executeCommand(binding, this.databaseName, this.getCommand(), new BsonDocumentCodec(), CommandOperationHelper.writeConcernErrorTransformer());
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        OperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                CommandOperationHelper.executeCommandAsync(binding, this.databaseName, this.getCommand(), connection, CommandOperationHelper.writeConcernErrorWriteTransformer(), wrappedCallback);
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("create", new BsonString(this.viewName)).append("viewOn", new BsonString(this.viewOn)).append("pipeline", new BsonArray(this.pipeline));
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        return commandDocument;
    }
}

