/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.operation;

import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ReadConcernHelper;
import com.cobblemon.mod.relocations.mongodb.internal.session.SessionContext;
import org.bson.BsonDocument;

final class OperationReadConcernHelper {
    static void appendReadConcernToCommand(SessionContext sessionContext, int maxWireVersion, BsonDocument commandDocument) {
        Assertions.notNull("commandDocument", commandDocument);
        Assertions.notNull("sessionContext", sessionContext);
        if (sessionContext.hasActiveTransaction()) {
            return;
        }
        if (sessionContext.isSnapshot()) {
            return;
        }
        BsonDocument readConcernDocument = ReadConcernHelper.getReadConcernDocument(sessionContext, maxWireVersion);
        if (!readConcernDocument.isEmpty()) {
            commandDocument.append("readConcern", readConcernDocument);
        }
    }

    private OperationReadConcernHelper() {
    }
}

