/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.interop;

import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.GenerateUncached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.ImportStatic;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.InteropLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.api.library.CachedLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSConfig;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSRealm;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSDynamicObject;

@GenerateUncached
@ImportStatic(value={JSConfig.class})
public abstract class ForeignObjectPrototypeNode
extends JavaScriptBaseNode {
    public abstract JSDynamicObject execute(Object var1);

    @Specialization(limit="InteropLibraryLimit")
    public JSDynamicObject doTruffleObject(Object truffleObject, @CachedLibrary(value="truffleObject") InteropLibrary interop) {
        JSRealm realm = this.getRealm();
        if (interop.hasArrayElements(truffleObject)) {
            return realm.getForeignArrayPrototype();
        }
        if (interop.isInstant(truffleObject)) {
            return realm.getForeignDatePrototype();
        }
        if (interop.hasHashEntries(truffleObject)) {
            return realm.getForeignMapPrototype();
        }
        if (interop.hasIterator(truffleObject)) {
            return realm.getForeignIterablePrototype();
        }
        if (interop.isString(truffleObject)) {
            return realm.getForeignStringPrototype();
        }
        if (interop.isNumber(truffleObject)) {
            return realm.getForeignNumberPrototype();
        }
        if (interop.isBoolean(truffleObject)) {
            return realm.getForeignBooleanPrototype();
        }
        if (interop.isExecutable(truffleObject) || interop.isInstantiable(truffleObject)) {
            return realm.getForeignFunctionPrototype();
        }
        return realm.getForeignObjectPrototype();
    }

    public static ForeignObjectPrototypeNode create() {
        return ForeignObjectPrototypeNodeGen.create();
    }

    public static ForeignObjectPrototypeNode getUncached() {
        return ForeignObjectPrototypeNodeGen.getUncached();
    }
}

