/*
 * Decompiled with CFR 0.152.
 */
package org.stellarvan.itemcleaner;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import org.stellarvan.itemcleaner.CleanupConfig;
import org.stellarvan.itemcleaner.I18n;
import org.stellarvan.itemcleaner.InteractiveCleanupHandler;
import org.stellarvan.itemcleaner.ItemCleaner;

public class CleanupCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cleandrops").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.help_guide"), false);
            return 1;
        })).then(class_2170.method_9247((String)"help").executes(CleanupCommands::showHelp))).then(class_2170.method_9247((String)"clean").executes(CleanupCommands::executeCleanup))).then(class_2170.method_9247((String)"add").executes(CleanupCommands::addHeldItem))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"itemId", (ArgumentType)StringArgumentType.string()).executes(CleanupCommands::removeItem)))).then(class_2170.method_9247((String)"setinterval").then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)200)).executes(CleanupCommands::setInterval)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(CleanupCommands::listItems)).then(class_2170.method_9244((String)"listName", (ArgumentType)StringArgumentType.string()).executes(CleanupCommands::listSpecificList)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"toggle").then(class_2170.method_9247((String)"auto").executes(CleanupCommands::toggleAutoCleanup))).then(class_2170.method_9247((String)"threshold").executes(CleanupCommands::toggleThresholdCheck)))).then(class_2170.method_9247((String)"confirm").then(class_2170.method_9244((String)"requestId", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"choice", (ArgumentType)StringArgumentType.string()).executes(context -> InteractiveCleanupHandler.handleConfirmation((CommandContext<class_2168>)context)))))).then(class_2170.method_9247((String)"language").then(class_2170.method_9244((String)"langCode", (ArgumentType)StringArgumentType.string()).executes(CleanupCommands::setLanguage)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"listmanager").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"switch").executes(CleanupCommands::showAvailableLists)).then(class_2170.method_9244((String)"listName", (ArgumentType)StringArgumentType.string()).executes(CleanupCommands::switchCleanupList)))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"listName", (ArgumentType)StringArgumentType.string()).executes(CleanupCommands::createCleanupList)))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"listName", (ArgumentType)StringArgumentType.string()).executes(CleanupCommands::deleteCleanupList)))).then(class_2170.method_9247((String)"current").executes(CleanupCommands::showCurrentList))).then(class_2170.method_9247((String)"all").executes(CleanupCommands::listAllLists))).then(class_2170.method_9247((String)"list").executes(CleanupCommands::listAllListsWithItems))));
    }

    private static int setLanguage(CommandContext<class_2168> context) {
        String langCode;
        ItemCleaner.config.language = langCode = StringArgumentType.getString(context, (String)"langCode");
        ItemCleaner.saveConfig();
        I18n.setLanguage(langCode);
        ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.language_updated", langCode), false);
        return 1;
    }

    private static int listAllListsWithItems(CommandContext<class_2168> context) {
        Map<String, List<String>> allLists = ItemCleaner.config.cleanupLists;
        if (allLists.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.no_lists_found"), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> I18n.text("itemcleaner.all_lists_with_items_title"), false);
        for (Map.Entry<String, List<String>> entry : allLists.entrySet()) {
            String listName = entry.getKey();
            List<String> items = entry.getValue();
            String titlePrefix = ItemCleaner.config.currentCleanupList.equals(listName) ? "\u00a7a* " : "\u00a76";
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(titlePrefix + "===== " + listName + " =====")), false);
            if (items.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77  \u8be5\u5217\u8868\u4e3a\u7a7a\u00a7r"), false);
                continue;
            }
            for (String itemId : items) {
                String itemName = "\u672a\u77e5\u7269\u54c1";
                try {
                    class_2960 id = class_2960.method_60655((String)"itemcleaner", (String)itemId);
                    if (class_7923.field_41178.method_10250(id)) {
                        itemName = ((class_1792)class_7923.field_41178.method_10223(id)).method_7848().getString();
                    }
                }
                catch (Exception id) {
                    // empty catch block
                }
                String finalItemName = itemName;
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a77- " + finalItemName + " \u00a78(" + itemId + ")\u00a7r")), false);
            }
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77* \u8868\u793a\u5f53\u524d\u4f7f\u7528\u7684\u5217\u8868\u00a7r"), false);
        return 1;
    }

    private static int showAvailableLists(CommandContext<class_2168> context) {
        Set<String> listNames = ItemCleaner.config.cleanupLists.keySet();
        if (listNames.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.no_lists_found"), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"itemcleaner.available_lists_prompt"), false);
        for (String listName : listNames) {
            String currentListName = listName;
            String prefix = ItemCleaner.config.currentCleanupList.equals(currentListName) ? "\u00a7a* " : "\u00a77- ";
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(prefix + currentListName + " \u00a77(" + ItemCleaner.config.cleanupLists.get(currentListName).size() + "\u4e2a\u7269\u54c1)")), false);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77\u4f7f\u7528 /cleandrops listmanager switch <\u5217\u8868\u540d> \u5207\u6362\u00a7r"), false);
        return 1;
    }

    private static int showHelp(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_title"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_help"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_clean"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_add"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_remove"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_setinterval"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_list"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_toggle_auto"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_toggle_threshold"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_language"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_listmanager_switch"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_listmanager_create"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_listmanager_delete"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_listmanager_current"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_listmanager_all"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_command_listmanager_list"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_note"), false);
        source.method_9226(() -> class_2561.method_43471((String)"itemcleaner.help_title"), false);
        return 1;
    }

    private static int executeCleanup(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.cleanup_start"), true);
        ItemCleaner.cleanupTimer.performCleanup(true);
        return 1;
    }

    private static int addHeldItem(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 heldStack = player.method_6047();
        if (heldStack.method_7960()) {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.no_item_held"), false);
            return 0;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)heldStack.method_7909());
        String itemIdStr = itemId.toString();
        List<String> activeList = ItemCleaner.config.getActiveCleanupList();
        if (!activeList.contains(itemIdStr)) {
            ItemCleaner.config.addItemToActiveList(itemIdStr);
            CleanupConfig.saveConfig(ItemCleaner.config);
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.item_added", itemIdStr), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.item_already_present", itemIdStr), false);
        }
        return 1;
    }

    private static int removeItem(CommandContext<class_2168> context) {
        String itemId = StringArgumentType.getString(context, (String)"itemId");
        if (ItemCleaner.config.removeItemFromActiveList(itemId)) {
            CleanupConfig.saveConfig(ItemCleaner.config);
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.item_removed", itemId), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.item_not_found", itemId), false);
        }
        return 1;
    }

    private static int setInterval(CommandContext<class_2168> context) {
        int ticks;
        ItemCleaner.config.cleanupInterval = ticks = IntegerArgumentType.getInteger(context, (String)"ticks");
        CleanupConfig.saveConfig(ItemCleaner.config);
        ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.interval_updated", ticks), false);
        return 1;
    }

    private static int listItems(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"itemcleaner.list_title_current", (Object[])new Object[]{ItemCleaner.config.currentCleanupList}), false);
        List<String> activeList = ItemCleaner.config.getActiveCleanupList();
        if (activeList.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"itemcleaner.list_empty"), false);
            return 1;
        }
        for (String itemId : activeList) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a77- " + itemId)), false);
        }
        return 1;
    }

    private static int listSpecificList(CommandContext<class_2168> context) {
        String listName = StringArgumentType.getString(context, (String)"listName");
        List<String> targetList = ItemCleaner.config.cleanupLists.get(listName);
        if (targetList == null) {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.list_not_found", listName), false);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"itemcleaner.list_title_specific", (Object[])new Object[]{listName}), false);
        if (targetList.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"itemcleaner.list_empty"), false);
            return 1;
        }
        for (String itemId : targetList) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a77- " + itemId)), false);
        }
        return 1;
    }

    private static int toggleAutoCleanup(CommandContext<class_2168> context) {
        ItemCleaner.config.enableAutoCleanup = !ItemCleaner.config.enableAutoCleanup;
        CleanupConfig.saveConfig(ItemCleaner.config);
        String messageKey = ItemCleaner.config.enableAutoCleanup ? "itemcleaner.toggle_auto_enabled" : "itemcleaner.toggle_auto_disabled";
        ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText(messageKey), true);
        return 1;
    }

    private static int toggleThresholdCheck(CommandContext<class_2168> context) {
        ItemCleaner.config.enableThresholdCheck = !ItemCleaner.config.enableThresholdCheck;
        CleanupConfig.saveConfig(ItemCleaner.config);
        String messageKey = ItemCleaner.config.enableThresholdCheck ? "itemcleaner.toggle_threshold_enabled" : "itemcleaner.toggle_threshold_disabled";
        ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText(messageKey), true);
        return 1;
    }

    private static int switchCleanupList(CommandContext<class_2168> context) {
        String listName = StringArgumentType.getString(context, (String)"listName");
        if (ItemCleaner.config.switchCleanupList(listName)) {
            CleanupConfig.saveConfig(ItemCleaner.config);
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.list_switched", listName), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.list_not_found", listName), false);
        }
        return 1;
    }

    private static int createCleanupList(CommandContext<class_2168> context) {
        String listName = StringArgumentType.getString(context, (String)"listName");
        if (listName.contains(" ") || listName.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.invalid_list_name"), false);
            return 0;
        }
        if (ItemCleaner.config.createCleanupList(listName)) {
            CleanupConfig.saveConfig(ItemCleaner.config);
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.list_created", listName), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a77\u4f7f\u7528 /cleandrops listmanager switch " + listName + " \u5207\u6362\u5230\u8be5\u5217\u8868\u00a7r")), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.list_already_exists", listName), false);
        }
        return 1;
    }

    private static int deleteCleanupList(CommandContext<class_2168> context) {
        String listName = StringArgumentType.getString(context, (String)"listName");
        if (ItemCleaner.config.cleanupLists.size() <= 1) {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.cannot_delete_last_list"), false);
            return 0;
        }
        if (ItemCleaner.config.deleteCleanupList(listName)) {
            CleanupConfig.saveConfig(ItemCleaner.config);
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.list_deleted", listName), false);
        } else if (ItemCleaner.config.currentCleanupList.equals(listName)) {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.list_cannot_delete_current", listName), false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77\u8bf7\u5148\u5207\u6362\u5230\u5176\u4ed6\u5217\u8868\u518d\u5220\u9664\u5f53\u524d\u5217\u8868\u00a7r"), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.list_not_found", listName), false);
        }
        return 1;
    }

    private static int showCurrentList(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.current_list", ItemCleaner.config.currentCleanupList), false);
        return 1;
    }

    private static int listAllLists(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"itemcleaner.all_lists_title"), false);
        Map<String, List<String>> allLists = ItemCleaner.config.cleanupLists;
        if (allLists.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"itemcleaner.no_lists_found"), false);
            return 1;
        }
        for (String listName : allLists.keySet()) {
            String prefix = ItemCleaner.config.currentCleanupList.equals(listName) ? "\u00a7a* " : "\u00a77- ";
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(prefix + listName + " \u00a77(" + ((List)allLists.get(listName)).size() + " \u4e2a\u7269\u54c1)")), false);
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77* \u8868\u793a\u5f53\u524d\u4f7f\u7528\u7684\u5217\u8868\u00a7r"), false);
        return 1;
    }
}

