/*
 * Decompiled with CFR 0.152.
 */
package org.stellarvan.itemcleaner;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.stellarvan.itemcleaner.ItemCleaner;

public class CleanupConfig {
    public boolean enableAutoCleanup = true;
    public boolean enableThresholdCheck = true;
    public int cleanupInterval = 12000;
    public int thresholdCheckInterval = 100;
    public int warningCooldown = 1200;
    public int cleanRadius = 48;
    public int yMin = -64;
    public int yMax = 320;
    public int itemThreshold = 100;
    public String language = "zh_cn";
    public String currentCleanupList = "default";
    public Map<String, List<String>> cleanupLists = new HashMap<String, List<String>>();

    public static CleanupConfig loadConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "itemcleaner.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (configFile.exists()) {
            CleanupConfig cleanupConfig;
            FileReader reader = new FileReader(configFile, StandardCharsets.UTF_8);
            try {
                cleanupConfig = (CleanupConfig)gson.fromJson((Reader)reader, CleanupConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ItemCleaner.LOGGER.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e", (Throwable)e);
                }
            }
            reader.close();
            return cleanupConfig;
        }
        CleanupConfig defaultConfig = new CleanupConfig();
        ArrayList<String> defaultList = new ArrayList<String>();
        defaultList.add("minecraft:cobblestone");
        defaultList.add("minecraft:dirt");
        defaultList.add("minecraft:bone");
        defaultList.add("minecraft:rotten_flesh");
        defaultList.add("minecraft:spider_eye");
        defaultList.add("minecraft:string");
        defaultList.add("minecraft:feather");
        defaultList.add("minecraft:gunpowder");
        defaultList.add("minecraft:flint");
        defaultList.add("minecraft:gravel");
        defaultList.add("minecraft:sand");
        defaultList.add("minecraft:clay_ball");
        defaultList.add("minecraft:snowball");
        defaultList.add("minecraft:egg");
        defaultList.add("minecraft:cod");
        defaultList.add("minecraft:salmon");
        defaultList.add("minecraft:pufferfish");
        defaultList.add("minecraft:tropical_fish");
        defaultList.add("minecraft:beef");
        defaultList.add("minecraft:porkchop");
        defaultList.add("minecraft:chicken");
        defaultList.add("minecraft:rabbit");
        defaultList.add("minecraft:mutton");
        defaultList.add("minecraft:leather");
        defaultList.add("minecraft:wool");
        defaultList.add("minecraft:stick");
        defaultList.add("minecraft:stone");
        defaultList.add("minecraft:cobblestone");
        defaultList.add("minecraft:grass_block");
        defaultList.add("minecraft:dead_bush");
        defaultList.add("minecraft:brown_mushroom");
        defaultList.add("minecraft:red_mushroom");
        defaultList.add("minecraft:lily_pad");
        defaultList.add("minecraft:seagrass");
        defaultList.add("minecraft:kelp");
        defaultConfig.cleanupLists.put("default", defaultList);
        ArrayList<String> nowCleanList = new ArrayList<String>();
        nowCleanList.add("minecraft:gravel");
        nowCleanList.add("minecraft:sand");
        defaultConfig.cleanupLists.put("NowClean", nowCleanList);
        CleanupConfig.saveConfig(defaultConfig);
        return defaultConfig;
    }

    public static void saveConfig(CleanupConfig config) {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "itemcleaner.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(configFile, StandardCharsets.UTF_8);){
            gson.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            ItemCleaner.LOGGER.error("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public List<String> getActiveCleanupList() {
        return this.cleanupLists.getOrDefault(this.currentCleanupList, new ArrayList());
    }

    public boolean switchCleanupList(String listName) {
        if (this.cleanupLists.containsKey(listName)) {
            this.currentCleanupList = listName;
            return true;
        }
        return false;
    }

    public boolean createCleanupList(String listName) {
        if (!this.cleanupLists.containsKey(listName)) {
            this.cleanupLists.put(listName, new ArrayList());
            return true;
        }
        return false;
    }

    public boolean deleteCleanupList(String listName) {
        if (!this.currentCleanupList.equals(listName) && this.cleanupLists.containsKey(listName)) {
            this.cleanupLists.remove(listName);
            return true;
        }
        return false;
    }

    public void addItemToActiveList(String itemId) {
        List<String> activeList = this.getActiveCleanupList();
        if (!activeList.contains(itemId)) {
            activeList.add(itemId);
        }
    }

    public boolean removeItemFromActiveList(String itemId) {
        List<String> activeList = this.getActiveCleanupList();
        return activeList.remove(itemId);
    }
}

