/*
 * Decompiled with CFR 0.152.
 */
package org.stellarvan.itemcleaner;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.stellarvan.itemcleaner.I18n;
import org.stellarvan.itemcleaner.InteractiveCleanupHandler;
import org.stellarvan.itemcleaner.ItemCleaner;

public class CleanupTimer {
    public MinecraftServer server;
    public int tickCounter = 0;
    public boolean cleanupAnnounced = false;
    private int thresholdCheckCounter = 0;
    private int warningCooldown = 0;

    public void setServer(MinecraftServer server) {
        this.server = server;
        ItemCleaner.LOGGER.info("\u670d\u52a1\u5668\u5b9e\u4f8b\u5df2\u8bbe\u7f6e");
        if (server != null) {
            int cooldownSeconds = ItemCleaner.config.warningCooldown / 20;
            ItemCleaner.LOGGER.info("\u5f53\u524d\u6e05\u7406\u914d\u7f6e - \u63d0\u793a\u51b7\u5374\u65f6\u95f4: " + cooldownSeconds + "\u79d2 (" + ItemCleaner.config.warningCooldown + "ticks)");
            ItemCleaner.LOGGER.info("\u9608\u503c\u68c0\u6d4b\u914d\u7f6e - \u542f\u7528: " + ItemCleaner.config.enableThresholdCheck + ", \u68c0\u6d4b\u95f4\u9694: " + ItemCleaner.config.thresholdCheckInterval + "ticks, \u89e6\u53d1\u9608\u503c: " + ItemCleaner.config.itemThreshold);
        }
    }

    public void tick() {
        if (this.server == null) {
            return;
        }
        if (!ItemCleaner.config.enableAutoCleanup && !ItemCleaner.config.enableThresholdCheck) {
            return;
        }
        ++this.tickCounter;
        ++this.thresholdCheckCounter;
        int interval = ItemCleaner.config.cleanupInterval;
        int checkInterval = ItemCleaner.config.thresholdCheckInterval;
        if (this.warningCooldown > 0) {
            --this.warningCooldown;
        }
        if (ItemCleaner.config.enableThresholdCheck) {
            if (checkInterval <= 0) {
                checkInterval = 200;
                ItemCleaner.LOGGER.warn("\u9608\u503c\u68c0\u6d4b\u95f4\u9694\u914d\u7f6e\u65e0\u6548\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c: " + checkInterval + "ticks");
            }
            if (this.thresholdCheckCounter % 100 == 0) {
                ItemCleaner.LOGGER.debug("\u9608\u503c\u68c0\u6d4b\u8ba1\u6570\u5668 - \u5f53\u524d: " + this.thresholdCheckCounter + ", \u95f4\u9694: " + checkInterval);
            }
            if (this.thresholdCheckCounter >= checkInterval) {
                ItemCleaner.LOGGER.debug("\u8fbe\u5230\u9608\u503c\u68c0\u6d4b\u95f4\u9694\uff0c\u6267\u884c\u68c0\u6d4b");
                this.checkItemThreshold();
                this.thresholdCheckCounter = 0;
            }
        }
        if (ItemCleaner.config.enableAutoCleanup && this.tickCounter >= interval) {
            ItemCleaner.LOGGER.info("\u8fbe\u5230\u6e05\u7406\u95f4\u9694\uff0c\u6267\u884c\u5b9a\u65f6\u6e05\u7406");
            this.performCleanup(true);
            this.tickCounter = 0;
            this.cleanupAnnounced = false;
            return;
        }
        if (ItemCleaner.config.enableAutoCleanup && !this.cleanupAnnounced) {
            int remainingTicks = interval - this.tickCounter;
            if (remainingTicks == 1200) {
                this.sendCleanupWarning("itemcleaner.warning_1min");
            } else if (remainingTicks == 600) {
                this.sendCleanupWarning("itemcleaner.warning_30s");
            } else if (remainingTicks == 100) {
                this.sendCleanupWarning("itemcleaner.warning_5s");
                this.cleanupAnnounced = true;
            }
        }
    }

    private void checkItemThreshold() {
        if (this.server == null) {
            ItemCleaner.LOGGER.warn("\u8df3\u8fc7\u9608\u503c\u68c0\u6d4b\uff1a\u670d\u52a1\u5668\u5b9e\u4f8b\u4e3a\u7a7a");
            return;
        }
        int cleanRadius = ItemCleaner.config.cleanRadius;
        int yMin = ItemCleaner.config.yMin;
        int yMax = ItemCleaner.config.yMax;
        int threshold = ItemCleaner.config.itemThreshold;
        int cooldownTicks = ItemCleaner.config.warningCooldown;
        if (threshold <= 0) {
            threshold = 100;
            ItemCleaner.LOGGER.warn("\u9608\u503c\u914d\u7f6e\u65e0\u6548(" + threshold + ")\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c: 100");
        }
        if (cleanRadius <= 0) {
            cleanRadius = 48;
            ItemCleaner.LOGGER.debug("\u6e05\u7406\u534a\u5f84\u65e0\u6548\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c: " + cleanRadius);
        }
        if (yMin >= yMax) {
            yMin = -64;
            yMax = 320;
            ItemCleaner.LOGGER.debug("Y\u8f74\u8303\u56f4\u65e0\u6548\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c: " + yMin + "~" + yMax);
        }
        if (cooldownTicks <= 0) {
            cooldownTicks = 1200;
            ItemCleaner.LOGGER.debug("\u8b66\u544a\u51b7\u5374\u65e0\u6548\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c: " + cooldownTicks + "ticks");
        }
        int finalRadius = cleanRadius;
        int finalYMin = yMin;
        int finalYMax = yMax;
        int finalThreshold = threshold;
        int finalCooldown = cooldownTicks;
        this.server.execute(() -> {
            AtomicInteger totalCount = new AtomicInteger(0);
            HashSet countedEntities = new HashSet();
            HashSet detectedItems = new HashSet();
            this.server.method_3738().forEach(world -> {
                if (world == null) {
                    ItemCleaner.LOGGER.debug("\u8df3\u8fc7\u7a7a\u4e16\u754c\u7684\u7269\u54c1\u68c0\u6d4b");
                    return;
                }
                for (class_1657 player : world.method_18456()) {
                    class_243 playerPos = player.method_19538();
                    class_238 playerRange = new class_238(playerPos.field_1352 - (double)finalRadius, (double)finalYMin, playerPos.field_1350 - (double)finalRadius, playerPos.field_1352 + (double)finalRadius, (double)finalYMax, playerPos.field_1350 + (double)finalRadius);
                    if (totalCount.get() == 0) {
                        ItemCleaner.LOGGER.debug("\u68c0\u6d4b\u8303\u56f4 - \u73a9\u5bb6: " + player.method_5477().getString() + ", \u4f4d\u7f6e: (" + (int)playerPos.field_1352 + "," + (int)playerPos.field_1351 + "," + (int)playerPos.field_1350 + "), \u534a\u5f84: " + finalRadius + ", Y\u8303\u56f4: " + finalYMin + "~" + finalYMax);
                    }
                    for (class_1542 item : world.method_8390(class_1542.class, playerRange, entity -> true)) {
                        if (countedEntities.contains(item)) continue;
                        String itemId = class_7923.field_41178.method_10221((Object)item.method_6983().method_7909()).toString();
                        if (!ItemCleaner.config.getActiveCleanupList().contains(itemId)) continue;
                        int count = item.method_6983().method_7947();
                        totalCount.addAndGet(count);
                        countedEntities.add(item);
                        detectedItems.add(itemId);
                        ItemCleaner.LOGGER.debug("\u68c0\u6d4b\u5230\u6e05\u7406\u5217\u8868\u7269\u54c1: " + itemId + " x" + count);
                    }
                }
            });
            ItemCleaner.LOGGER.debug("\u9608\u503c\u68c0\u6d4b\u7ed3\u679c - \u603b\u6570\u91cf: " + totalCount.get() + ", \u9608\u503c: " + finalThreshold + ", \u68c0\u6d4b\u5230\u7684\u7269\u54c1\u7c7b\u578b: " + detectedItems.size() + ", \u51b7\u5374\u72b6\u6001: " + (String)(this.warningCooldown > 0 ? "\u5269\u4f59" + this.warningCooldown / 20 + "\u79d2" : "\u5c31\u7eea"));
            if (totalCount.get() >= finalThreshold && this.warningCooldown <= 0) {
                ItemCleaner.LOGGER.info("\u6570\u91cf\u8fbe\u6807\u4e14\u51b7\u5374\u7ed3\u675f\uff0c\u53d1\u9001\u6e05\u7406\u63d0\u793a (\u6570\u91cf: " + totalCount.get() + ")");
                InteractiveCleanupHandler.sendCleanupPrompt(this.server, totalCount.get());
                this.warningCooldown = finalCooldown;
            } else if (totalCount.get() >= finalThreshold) {
                ItemCleaner.LOGGER.debug("\u6570\u91cf\u8fbe\u6807\u4f46\u51b7\u5374\u4e2d\uff0c\u4e0d\u53d1\u9001\u63d0\u793a");
            } else if (this.warningCooldown <= 0) {
                ItemCleaner.LOGGER.debug("\u672a\u8fbe\u9608\u503c\uff0c\u4e0d\u53d1\u9001\u63d0\u793a");
            }
        });
    }

    public void performCleanup(boolean forceNotify) {
        if (this.server == null) {
            ItemCleaner.LOGGER.error("\u6267\u884c\u6e05\u7406\u5931\u8d25\uff1a\u670d\u52a1\u5668\u5b9e\u4f8b\u4e3a\u7a7a");
            return;
        }
        int cleanRadius = ItemCleaner.config.cleanRadius;
        int yMin = ItemCleaner.config.yMin;
        int yMax = ItemCleaner.config.yMax;
        if (cleanRadius <= 0) {
            cleanRadius = 48;
        }
        if (yMin >= yMax) {
            yMin = -64;
            yMax = 320;
        }
        int finalRadius = cleanRadius;
        int finalYMin = yMin;
        int finalYMax = yMax;
        this.server.execute(() -> {
            HashMap<String, Object[]> cleanedItems = new HashMap<String, Object[]>();
            AtomicInteger totalCleaned = new AtomicInteger(0);
            HashSet cleanedEntities = new HashSet();
            boolean doEntityDrops = this.server.method_3767().method_8355(class_1928.field_19393);
            if (!doEntityDrops) {
                ItemCleaner.LOGGER.info("\u7531\u4e8e\u6e38\u620f\u89c4\u5219\u8bbe\u7f6e\uff0c\u8df3\u8fc7\u6e05\u7406");
                if (forceNotify) {
                    this.server.method_3760().method_43514((class_2561)I18n.prefixedText("itemcleaner.cleanup_none"), false);
                }
                return;
            }
            this.server.method_3738().forEach(world -> {
                for (class_1657 player : world.method_18456()) {
                    class_243 playerPos = player.method_19538();
                    class_238 playerRange = new class_238(playerPos.field_1352 - (double)finalRadius, (double)finalYMin, playerPos.field_1350 - (double)finalRadius, playerPos.field_1352 + (double)finalRadius, (double)finalYMax, playerPos.field_1350 + (double)finalRadius);
                    for (class_1542 item : world.method_8390(class_1542.class, playerRange, entity -> true)) {
                        if (cleanedEntities.contains(item)) continue;
                        String itemId = class_7923.field_41178.method_10221((Object)item.method_6983().method_7909()).toString();
                        if (!ItemCleaner.config.getActiveCleanupList().contains(itemId)) continue;
                        int count = item.method_6983().method_7947();
                        String itemName = item.method_6983().method_7964().getString();
                        totalCleaned.addAndGet(count);
                        cleanedEntities.add(item);
                        if (cleanedItems.containsKey(itemId)) {
                            Object[] data = (Object[])cleanedItems.get(itemId);
                            cleanedItems.put(itemId, new Object[]{data[0], (Integer)data[1] + count});
                        } else {
                            cleanedItems.put(itemId, new Object[]{itemName, count});
                        }
                        item.method_31472();
                    }
                }
            });
            this.sendCleanupStats(cleanedItems, totalCleaned.get(), forceNotify);
            ItemCleaner.LOGGER.info("\u6e05\u7406\u5b8c\u6210\uff0c\u5171\u6e05\u7406 " + totalCleaned.get() + " \u4e2a\u7269\u54c1");
            this.warningCooldown = 0;
        });
    }

    private void sendCleanupWarning(String messageKey) {
        this.server.method_3760().method_43514((class_2561)I18n.prefixedText(messageKey), false);
    }

    private void sendCleanupStats(Map<String, Object[]> cleanedItems, int total, boolean forceNotify) {
        if (this.server == null) {
            return;
        }
        if (total > 0) {
            this.server.method_3760().method_43514((class_2561)I18n.prefixedText("itemcleaner.cleanup_completed", total), false);
            for (Map.Entry<String, Object[]> entry : cleanedItems.entrySet()) {
                String itemId = entry.getKey();
                String itemName = (String)entry.getValue()[0];
                int count = (Integer)entry.getValue()[1];
                this.server.method_3760().method_43514((class_2561)class_2561.method_43470((String)("\u00a7b- " + itemName + " \u00a77(" + itemId + ")\u00a7a: " + count + " \u4e2a\u00a7r")), false);
            }
        } else if (forceNotify) {
            this.server.method_3760().method_43514((class_2561)I18n.prefixedText("itemcleaner.cleanup_none"), false);
        }
    }
}

