/*
 * Decompiled with CFR 0.152.
 */
package org.stellarvan.itemcleaner;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.stellarvan.itemcleaner.ItemCleaner;

public class I18n {
    private static final Map<String, String> serverTranslations = new HashMap<String, String>();
    private static String currentLang = "zh_cn";
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(\\d+\\$)?[sdf]");

    public static void init() {
        if (ItemCleaner.config != null && ItemCleaner.config.language != null) {
            currentLang = ItemCleaner.config.language;
        }
        I18n.reloadTranslations();
    }

    public static void reloadTranslations() {
        serverTranslations.clear();
        try {
            String langCode = currentLang;
            if ("en_us".equals(langCode)) {
                I18n.loadEnglishTranslations();
            } else {
                I18n.loadChineseTranslations();
            }
            ItemCleaner.LOGGER.info("[ItemCleaner]{}", (Object)String.format(I18n.translate("itemcleaner.log.loading_language"), langCode));
            if (!serverTranslations.containsKey("itemcleaner.prefix")) {
                ItemCleaner.LOGGER.warn("\u8b66\u544a\uff1a\u672a\u627e\u5230\u524d\u7f00\u7ffb\u8bd1\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c");
                serverTranslations.put("itemcleaner.prefix", "\u00a7b[Server]\u00a7r ");
            }
            ItemCleaner.LOGGER.info("[ItemCleaner]{}", (Object)String.format(I18n.translate("itemcleaner.log.language_loaded"), langCode));
        }
        catch (Exception e) {
            ItemCleaner.LOGGER.error("[ItemCleaner]\u8bed\u8a00\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
            serverTranslations.put("itemcleaner.prefix", "\u00a7b[Server]\u00a7r ");
        }
    }

    private static void loadEnglishTranslations() {
        serverTranslations.put("itemcleaner.prefix", "\u00a7b[Server]\u00a7r ");
        serverTranslations.put("itemcleaner.config_saved", "\u00a7aConfig saved\u00a7r");
        serverTranslations.put("itemcleaner.no_permission", "\u00a7cYou don't have permission\u00a7r");
        serverTranslations.put("itemcleaner.no_item_held", "\u00a7cPlease hold an item\u00a7r");
        serverTranslations.put("itemcleaner.item_already_present", "\u00a7e%s is already in list\u00a7r");
        serverTranslations.put("itemcleaner.language_updated", "\u00a7aLanguage updated to %s\u00a7r");
        serverTranslations.put("itemcleaner.help_guide", "\u00a7eUse /cleandrops help\u00a7r");
        serverTranslations.put("itemcleaner.help_title", "\u00a7a===== Item Cleanup Help =====");
        serverTranslations.put("itemcleaner.help_command_help", "\u00a7b/cleandrops help \u00a77- Show help");
        serverTranslations.put("itemcleaner.help_command_clean", "\u00a7b/cleandrops clean \u00a77- Clean items now");
        serverTranslations.put("itemcleaner.help_command_add", "\u00a7b/cleandrops add \u00a77- Add held item");
        serverTranslations.put("itemcleaner.help_command_remove", "\u00a7b/cleandrops remove <ID> \u00a77- Remove item");
        serverTranslations.put("itemcleaner.help_command_setinterval", "\u00a7b/cleandrops setinterval <ticks> \u00a77- Set interval");
        serverTranslations.put("itemcleaner.help_command_list", "\u00a7b/cleandrops list \u00a77- Show list");
        serverTranslations.put("itemcleaner.help_command_toggle_auto", "\u00a7b/cleandrops toggle auto \u00a77- Toggle auto-clean");
        serverTranslations.put("itemcleaner.help_command_toggle_threshold", "\u00a7b/cleandrops toggle threshold \u00a77- Toggle prompts");
        serverTranslations.put("itemcleaner.help_command_language", "\u00a7b/cleandrops language <code> \u00a77- Change language");
        serverTranslations.put("itemcleaner.help_note", "\u00a771s = 20ticks, config: itemcleaner.json\u00a7r");
        serverTranslations.put("itemcleaner.cleanup_start", "\u00a7aStarting cleanup...\u00a7r");
        serverTranslations.put("itemcleaner.cleanup_completed", "\u00a7aCleaned %d items\u00a7r");
        serverTranslations.put("itemcleaner.cleanup_none", "\u00a7aNo items to clean\u00a7r");
        serverTranslations.put("itemcleaner.threshold_prompt", "\u00a7eFound %d items. Clean now? ");
        serverTranslations.put("itemcleaner.button_yes", "[Yes]");
        serverTranslations.put("itemcleaner.button_no", "[No]");
        serverTranslations.put("itemcleaner.choice_yes_feedback", "\u00a7aCleanup executed\u00a7r");
        serverTranslations.put("itemcleaner.choice_no_feedback", "\u00a7eScheduled cleanup remains\u00a7r");
        serverTranslations.put("itemcleaner.warning_1min", "\u00a7eCleanup in 1 minute\u00a7r");
        serverTranslations.put("itemcleaner.warning_30s", "\u00a7eCleanup in 30 seconds\u00a7r");
        serverTranslations.put("itemcleaner.warning_5s", "\u00a7eCleanup in 5 seconds\u00a7r");
        serverTranslations.put("itemcleaner.toggle_auto_enabled", "\u00a7aAuto-clean enabled\u00a7r");
        serverTranslations.put("itemcleaner.toggle_auto_disabled", "\u00a7cAuto-clean disabled\u00a7r");
        serverTranslations.put("itemcleaner.toggle_threshold_enabled", "\u00a7aThreshold enabled\u00a7r");
        serverTranslations.put("itemcleaner.toggle_threshold_disabled", "\u00a7cThreshold disabled\u00a7r");
        serverTranslations.put("itemcleaner.item_added", "\u00a7aAdded %s to list\u00a7r");
        serverTranslations.put("itemcleaner.item_removed", "\u00a7aRemoved %s from list\u00a7r");
        serverTranslations.put("itemcleaner.item_not_found", "\u00a7c%s not in list\u00a7r");
        serverTranslations.put("itemcleaner.interval_updated", "\u00a7aInterval set to %d ticks\u00a7r");
        serverTranslations.put("itemcleaner.interval_invalid", "\u00a7cMinimum 200 ticks\u00a7r");
        serverTranslations.put("itemcleaner.list_title", "\u00a7a===== Cleanup List =====");
        serverTranslations.put("itemcleaner.list_empty", "\u00a7eList is empty\u00a7r");
        serverTranslations.put("itemcleaner.log.mod_loaded", "Mod loaded");
        serverTranslations.put("itemcleaner.log.server_instance_set", "Server instance set");
        serverTranslations.put("itemcleaner.log.cleanup_config", "Current cleanup config - Enabled: %b, Warning cooldown: %d seconds (%d ticks)");
        serverTranslations.put("itemcleaner.log.threshold_config", "Threshold check config - Enabled: %b, Check interval: %d ticks, Trigger threshold: %d, Prompt interval: %d");
        serverTranslations.put("itemcleaner.log.loading_language", "Loading language: %s");
        serverTranslations.put("itemcleaner.log.language_loaded", "Language loaded: %s");
        serverTranslations.put("item.itemcleaner.cleanup_hoe", "clenaup_hoe");
        serverTranslations.put("itemcleaner.log.cleanup_range", "Cleanup range - Detection radius: %d blocks");
        serverTranslations.put("itemcleaner.list_title_current", "\u00a7a===== Cleanup List: %s =====");
        serverTranslations.put("itemcleaner.list_title_specific", "\u00a7a===== List: %s =====");
        serverTranslations.put("itemcleaner.list_not_found", "\u00a7cList %s not found\u00a7r");
        serverTranslations.put("itemcleaner.list_switched", "\u00a7aSwitched to cleanup list: %s\u00a7r");
        serverTranslations.put("itemcleaner.list_created", "\u00a7aCreated new cleanup list: %s\u00a7r");
        serverTranslations.put("itemcleaner.list_already_exists", "\u00a7eCleanup list %s already exists\u00a7r");
        serverTranslations.put("itemcleaner.list_deleted", "\u00a7aDeleted cleanup list: %s\u00a7r");
        serverTranslations.put("itemcleaner.list_cannot_delete_current", "\u00a7cCannot delete current active list: %s\u00a7r");
        serverTranslations.put("itemcleaner.current_list", "\u00a7aCurrent active cleanup list: %s\u00a7r");
        serverTranslations.put("itemcleaner.all_lists_title", "\u00a7a===== All Cleanup Lists =====");
        serverTranslations.put("itemcleaner.no_lists_found", "\u00a7eNo cleanup lists found\u00a7r");
        serverTranslations.put("itemcleaner.help_command_listmanager_switch", "\u00a7b/cleandrops listmanager switch <name> \u00a77- Switch active cleanup list");
        serverTranslations.put("itemcleaner.help_command_listmanager_create", "\u00a7b/cleandrops listmanager create <name> \u00a77- Create new cleanup list");
        serverTranslations.put("itemcleaner.help_command_listmanager_delete", "\u00a7b/cleandrops listmanager delete <name> \u00a77- Delete cleanup list");
        serverTranslations.put("itemcleaner.help_command_listmanager_current", "\u00a7b/cleandrops listmanager current \u00a77- Show current active list");
        serverTranslations.put("itemcleaner.help_command_listmanager_all", "\u00a7b/cleandrops listmanager all \u00a77- Show all available lists");
        serverTranslations.put("itemcleaner.available_lists_prompt", "\u00a7aAvailable cleanup lists:");
        serverTranslations.put("itemcleaner.all_lists_with_items_title", "\u00a7a===== All Lists and Items =====");
        serverTranslations.put("itemcleaner.help_command_listmanager_list", "\u00a7b/cleandrops listmanager list \u00a77- View all lists and their items");
        serverTranslations.put("itemcleaner.invalid_list_name", "Invalid list name! Name cannot contain spaces or be empty.");
        serverTranslations.put("itemcleaner.cannot_delete_last_list", "Cannot delete the last list! At least one list must be kept.");
    }

    private static void loadChineseTranslations() {
        serverTranslations.put("itemcleaner.prefix", "\u00a7b[\u670d\u52a1\u5668\u5a18]\u00a7r ");
        serverTranslations.put("itemcleaner.config_saved", "\u00a7a\u914d\u7f6e\u5df2\u4fdd\u5b58\u00a7r");
        serverTranslations.put("itemcleaner.no_permission", "\u00a7c\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u547d\u4ee4\u00a7r");
        serverTranslations.put("itemcleaner.no_item_held", "\u00a7c\u8bf7\u624b\u6301\u7269\u54c1\u6267\u884c\u00a7r");
        serverTranslations.put("itemcleaner.item_already_present", "\u00a7e%s \u5df2\u5728\u6e05\u7406\u5217\u8868\u4e2d\u00a7r");
        serverTranslations.put("itemcleaner.language_updated", "\u00a7a\u8bed\u8a00\u5df2\u66f4\u65b0\u4e3a %s\u00a7r");
        serverTranslations.put("itemcleaner.help_guide", "\u00a7e\u4f7f\u7528 /cleandrops help \u67e5\u770b\u547d\u4ee4\u00a7r");
        serverTranslations.put("itemcleaner.help_title", "\u00a7a===== \u6389\u843d\u7269\u6e05\u7406\u547d\u4ee4\u5e2e\u52a9 =====");
        serverTranslations.put("itemcleaner.help_command_help", "\u00a7b/cleandrops help \u00a77- \u663e\u793a\u5e2e\u52a9");
        serverTranslations.put("itemcleaner.help_command_clean", "\u00a7b/cleandrops clean \u00a77- \u7acb\u5373\u6e05\u7406");
        serverTranslations.put("itemcleaner.help_command_add", "\u00a7b/cleandrops add \u00a77- \u6dfb\u52a0\u624b\u6301\u7269\u54c1");
        serverTranslations.put("itemcleaner.help_command_remove", "\u00a7b/cleandrops remove <ID> \u00a77- \u79fb\u9664\u7269\u54c1");
        serverTranslations.put("itemcleaner.help_command_setinterval", "\u00a7b/cleandrops setinterval <ticks> \u00a77- \u8bbe\u7f6e\u95f4\u9694");
        serverTranslations.put("itemcleaner.help_command_list", "\u00a7b/cleandrops list \u00a77- \u663e\u793a\u5217\u8868");
        serverTranslations.put("itemcleaner.help_command_toggle_auto", "\u00a7b/cleandrops toggle auto \u00a77- \u5f00\u5173\u81ea\u52a8\u6e05\u7406");
        serverTranslations.put("itemcleaner.help_command_toggle_threshold", "\u00a7b/cleandrops toggle threshold \u00a77- \u5f00\u5173\u63d0\u793a");
        serverTranslations.put("itemcleaner.help_command_language", "\u00a7b/cleandrops language <\u4ee3\u7801> \u00a77- \u5207\u6362\u8bed\u8a00");
        serverTranslations.put("itemcleaner.help_note", "\u00a771\u79d2=20\u6e38\u620f\u523b\uff0c\u914d\u7f6e\u6587\u4ef6: itemcleaner.json\u00a7r");
        serverTranslations.put("itemcleaner.cleanup_start", "\u00a7a\u5f00\u59cb\u6e05\u7406...\u00a7r");
        serverTranslations.put("itemcleaner.cleanup_completed", "\u00a7a\u5171\u6e05\u7406 %d \u4e2a\u7269\u54c1\u00a7r");
        serverTranslations.put("itemcleaner.cleanup_none", "\u00a7a\u6ca1\u6709\u53ef\u6e05\u7406\u7684\u7269\u54c1\u00a7r");
        serverTranslations.put("itemcleaner.threshold_prompt", "\u00a7e\u68c0\u6d4b\u5230 %d \u4e2a\u7269\u54c1\uff0c\u7acb\u5373\u6e05\u7406\uff1f ");
        serverTranslations.put("itemcleaner.button_yes", "[\u786e\u8ba4]");
        serverTranslations.put("itemcleaner.button_no", "[\u53d6\u6d88]");
        serverTranslations.put("itemcleaner.choice_yes_feedback", "\u00a7a\u5df2\u6267\u884c\u6e05\u7406\u00a7r");
        serverTranslations.put("itemcleaner.choice_no_feedback", "\u00a7e\u5c06\u6309\u8ba1\u5212\u6e05\u7406\u00a7r");
        serverTranslations.put("itemcleaner.warning_1min", "\u00a7e1\u5206\u949f\u540e\u6267\u884c\u6e05\u7406\u00a7r");
        serverTranslations.put("itemcleaner.warning_30s", "\u00a7e30\u79d2\u540e\u6267\u884c\u6e05\u7406\u00a7r");
        serverTranslations.put("itemcleaner.warning_5s", "\u00a7e5\u79d2\u540e\u6267\u884c\u6e05\u7406\u00a7r");
        serverTranslations.put("itemcleaner.toggle_auto_enabled", "\u00a7a\u81ea\u52a8\u6e05\u7406\u5df2\u5f00\u542f\u00a7r");
        serverTranslations.put("itemcleaner.toggle_auto_disabled", "\u00a7c\u81ea\u52a8\u6e05\u7406\u5df2\u5173\u95ed\u00a7r");
        serverTranslations.put("itemcleaner.toggle_threshold_enabled", "\u00a7a\u9608\u503c\u68c0\u6d4b\u5df2\u5f00\u542f\u00a7r");
        serverTranslations.put("itemcleaner.toggle_threshold_disabled", "\u00a7c\u9608\u503c\u68c0\u6d4b\u5df2\u5173\u95ed\u00a7r");
        serverTranslations.put("itemcleaner.item_added", "\u00a7a\u5df2\u6dfb\u52a0 %s \u5230\u5217\u8868\u00a7r");
        serverTranslations.put("itemcleaner.item_removed", "\u00a7a\u5df2\u4ece\u5217\u8868\u79fb\u9664 %s\u00a7r");
        serverTranslations.put("itemcleaner.item_not_found", "\u00a7c\u5217\u8868\u4e2d\u6ca1\u6709 %s\u00a7r");
        serverTranslations.put("itemcleaner.interval_updated", "\u00a7a\u95f4\u9694\u5df2\u8bbe\u4e3a %d \u6e38\u620f\u523b\u00a7r");
        serverTranslations.put("itemcleaner.interval_invalid", "\u00a7c\u6700\u4f4e200\u6e38\u620f\u523b\u00a7r");
        serverTranslations.put("itemcleaner.list_title", "\u00a7a===== \u6e05\u7406\u5217\u8868 =====");
        serverTranslations.put("itemcleaner.list_empty", "\u00a7e\u5217\u8868\u4e3a\u7a7a\u00a7r");
        serverTranslations.put("itemcleaner.log.mod_loaded", "\u6a21\u7ec4\u5df2\u52a0\u8f7d");
        serverTranslations.put("itemcleaner.log.server_instance_set", "\u670d\u52a1\u5668\u5b9e\u4f8b\u5df2\u8bbe\u7f6e");
        serverTranslations.put("itemcleaner.log.cleanup_config", "\u5f53\u524d\u6e05\u7406\u914d\u7f6e - \u662f\u5426\u542f\u7528: %b, \u63d0\u793a\u51b7\u5374\u65f6\u95f4: %d\u79d2 (%d ticks)");
        serverTranslations.put("itemcleaner.log.threshold_config", "\u9608\u503c\u68c0\u6d4b\u914d\u7f6e - \u662f\u5426\u542f\u7528: %b, \u68c0\u6d4b\u95f4\u9694: %d ticks, \u89e6\u53d1\u9608\u503c: %d, \u63d0\u793a\u95f4\u9694: %d");
        serverTranslations.put("itemcleaner.log.loading_language", "\u52a0\u8f7d\u8bed\u8a00: %s");
        serverTranslations.put("itemcleaner.log.language_loaded", "\u8bed\u8a00\u52a0\u8f7d\u5b8c\u6210: %s");
        serverTranslations.put("item.itemcleaner.cleanup_hoe", "\u6e05\u7406\u4e4b\u9504");
        serverTranslations.put("itemcleaner.log.cleanup_range", "\u6e05\u7406\u8303\u56f4 - \u68c0\u6d4b\u8303\u56f4: %d \u683c(\u534a\u5f84)");
        serverTranslations.put("itemcleaner.list_title_current", "\u00a7a===== \u6e05\u7406\u5217\u8868: %s =====");
        serverTranslations.put("itemcleaner.list_title_specific", "\u00a7a===== \u5217\u8868: %s =====");
        serverTranslations.put("itemcleaner.list_not_found", "\u00a7c\u672a\u627e\u5230\u5217\u8868 %s\u00a7r");
        serverTranslations.put("itemcleaner.list_switched", "\u00a7a\u5df2\u5207\u6362\u5230\u6e05\u7406\u5217\u8868: %s\u00a7r");
        serverTranslations.put("itemcleaner.list_created", "\u00a7a\u5df2\u521b\u5efa\u65b0\u6e05\u7406\u5217\u8868: %s\u00a7r");
        serverTranslations.put("itemcleaner.list_already_exists", "\u00a7e\u6e05\u7406\u5217\u8868 %s \u5df2\u5b58\u5728\u00a7r");
        serverTranslations.put("itemcleaner.list_deleted", "\u00a7a\u5df2\u5220\u9664\u6e05\u7406\u5217\u8868: %s\u00a7r");
        serverTranslations.put("itemcleaner.list_cannot_delete_current", "\u00a7c\u65e0\u6cd5\u5220\u9664\u5f53\u524d\u6b63\u5728\u4f7f\u7528\u7684\u5217\u8868: %s\u00a7r");
        serverTranslations.put("itemcleaner.current_list", "\u00a7a\u5f53\u524d\u6d3b\u8dc3\u7684\u6e05\u7406\u5217\u8868: %s\u00a7r");
        serverTranslations.put("itemcleaner.all_lists_title", "\u00a7a===== \u6240\u6709\u6e05\u7406\u5217\u8868 =====");
        serverTranslations.put("itemcleaner.no_lists_found", "\u00a7e\u672a\u627e\u5230\u4efb\u4f55\u6e05\u7406\u5217\u8868\u00a7r");
        serverTranslations.put("itemcleaner.help_command_listmanager_switch", "\u00a7b/cleandrops listmanager switch <\u540d\u79f0> \u00a77- \u5207\u6362\u6d3b\u8dc3\u7684\u6e05\u7406\u5217\u8868");
        serverTranslations.put("itemcleaner.help_command_listmanager_create", "\u00a7b/cleandrops listmanager create <\u540d\u79f0> \u00a77- \u521b\u5efa\u65b0\u7684\u6e05\u7406\u5217\u8868");
        serverTranslations.put("itemcleaner.help_command_listmanager_delete", "\u00a7b/cleandrops listmanager delete <\u540d\u79f0> \u00a77- \u5220\u9664\u6e05\u7406\u5217\u8868");
        serverTranslations.put("itemcleaner.help_command_listmanager_current", "\u00a7b/cleandrops listmanager current \u00a77- \u663e\u793a\u5f53\u524d\u6d3b\u8dc3\u7684\u5217\u8868");
        serverTranslations.put("itemcleaner.help_command_listmanager_all", "\u00a7b/cleandrops listmanager all \u00a77- \u663e\u793a\u6240\u6709\u53ef\u7528\u5217\u8868");
        serverTranslations.put("itemcleaner.available_lists_prompt", "\u00a7a\u53ef\u7528\u7684\u6e05\u7406\u5217\u8868\uff1a");
        serverTranslations.put("itemcleaner.all_lists_with_items_title", "\u00a7a===== \u6240\u6709\u5217\u8868\u53ca\u7269\u54c1 =====");
        serverTranslations.put("itemcleaner.help_command_listmanager_list", "\u00a7b/cleandrops listmanager list \u00a77- \u67e5\u770b\u6240\u6709\u5217\u8868\u53ca\u5305\u542b\u7684\u7269\u54c1");
        serverTranslations.put("itemcleaner.invalid_list_name", "\u65e0\u6548\u7684\u5217\u8868\u540d\u79f0\uff01\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7a7a\u683c\u6216\u4e3a\u7a7a\u3002");
        serverTranslations.put("itemcleaner.cannot_delete_last_list", "\u65e0\u6cd5\u5220\u9664\u6700\u540e\u4e00\u4e2a\u5217\u8868\uff01\u81f3\u5c11\u9700\u8981\u4fdd\u7559\u4e00\u4e2a\u5217\u8868\u3002");
    }

    public static String translate(String key) {
        if (I18n.isClientSide() && class_2477.method_10517().method_4678(key)) {
            return class_2477.method_10517().method_48307(key);
        }
        if (serverTranslations.containsKey(key)) {
            return serverTranslations.get(key);
        }
        if ("itemcleaner.prefix".equals(key)) {
            return "\u00a7b[Server]\u00a7r ";
        }
        ItemCleaner.LOGGER.warn("[ItemCleaner]\u7f3a\u5c11\u7ffb\u8bd1\u952e: " + key);
        return key;
    }

    public static String translate(String key, Object ... args) {
        String translation = I18n.translate(key);
        try {
            Matcher matcher = FORMAT_PATTERN.matcher(translation);
            StringBuffer result = new StringBuffer();
            int argIndex = 0;
            while (matcher.find() && argIndex < args.length) {
                matcher.appendReplacement(result, Matcher.quoteReplacement(args[argIndex++].toString()));
            }
            matcher.appendTail(result);
            return result.toString();
        }
        catch (Exception e) {
            return translation;
        }
    }

    public static class_5250 prefixedText(String key) {
        String prefix = I18n.translate("itemcleaner.prefix");
        String content = I18n.translate(key);
        return class_2561.method_43470((String)prefix).method_10852((class_2561)class_2561.method_43470((String)content));
    }

    public static class_5250 prefixedText(String key, Object ... args) {
        String prefix = I18n.translate("itemcleaner.prefix");
        String content = I18n.translate(key, args);
        return class_2561.method_43470((String)prefix).method_10852((class_2561)class_2561.method_43470((String)content));
    }

    public static class_5250 text(String key) {
        return class_2561.method_43470((String)I18n.translate(key));
    }

    public static class_5250 text(String key, Object ... args) {
        return class_2561.method_43470((String)I18n.translate(key, args));
    }

    private static boolean isClientSide() {
        try {
            Class.forName("net.minecraft.client.MinecraftClient");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void setLanguage(String langCode) {
        currentLang = langCode;
        I18n.reloadTranslations();
    }
}

