/*
 * Decompiled with CFR 0.152.
 */
package org.stellarvan.itemcleaner;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.stellarvan.itemcleaner.I18n;
import org.stellarvan.itemcleaner.ItemCleaner;

public class InteractiveCleanupHandler {
    private static int requestId = 0;

    public static synchronized int generateRequestId() {
        return requestId++;
    }

    public static void sendCleanupPrompt(MinecraftServer server, int itemCount) {
        if (server == null) {
            return;
        }
        int requestId = InteractiveCleanupHandler.generateRequestId();
        class_5250 message = class_2561.method_43470((String)(I18n.translate("itemcleaner.prefix") + I18n.translate("itemcleaner.threshold_prompt", itemCount))).method_10852((class_2561)class_2561.method_43470((String)I18n.translate("itemcleaner.button_yes")).method_27692(class_124.field_1060).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/cleandrops confirm " + requestId + " yes")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"\u70b9\u51fb\u7acb\u5373\u6e05\u7406"))))).method_10852((class_2561)class_2561.method_43470((String)"  ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)I18n.translate("itemcleaner.button_no")).method_27692(class_124.field_1061).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/cleandrops confirm " + requestId + " no")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"\u4e0d\u6e05\u7406\uff0c\u7b49\u5f85\u5b9a\u65f6\u6e05\u7406")))));
        server.method_3760().method_43514((class_2561)message, false);
        ItemCleaner.LOGGER.info("\u53d1\u9001\u6389\u843d\u7269\u4e0a\u9650\u63d0\u793a\uff0c\u8bf7\u6c42ID: " + requestId);
    }

    public static int handleConfirmation(CommandContext<class_2168> context) throws CommandSyntaxException {
        int requestId;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String requestIdStr = (String)context.getArgument("requestId", String.class);
        try {
            requestId = Integer.parseInt(requestIdStr);
        }
        catch (NumberFormatException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u65e0\u6548\u7684\u8bf7\u6c42ID"));
            return 0;
        }
        String choice = (String)context.getArgument("choice", String.class);
        if ("yes".equalsIgnoreCase(choice)) {
            ItemCleaner.cleanupTimer.performCleanup(true);
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.choice_yes_feedback"), true);
            ItemCleaner.LOGGER.info("\u73a9\u5bb6 " + player.method_5477().getString() + " \u786e\u8ba4\u7acb\u5373\u6e05\u7406\uff0c\u8bf7\u6c42ID: " + requestId);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> I18n.prefixedText("itemcleaner.choice_no_feedback"), false);
            ItemCleaner.LOGGER.info("\u73a9\u5bb6 " + player.method_5477().getString() + " \u9009\u62e9\u4e0d\u7acb\u5373\u6e05\u7406\uff0c\u8bf7\u6c42ID: " + requestId);
        }
        return 1;
    }
}

