/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.server;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mjson.Json;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.server.ServerHandler;
import net.fabricmc.installer.util.LauncherMeta;
import net.fabricmc.installer.util.Utils;

public class ServerPostInstallDialog
extends JDialog {
    private static final String launchCommand = "java -Xmx2G -jar fabric-server-launch.jar nogui";
    private static final int MB = 1000000;
    private final JPanel panel = new JPanel();
    private final ServerHandler serverHandler;
    private final String minecraftVersion;
    private final Path installDir;
    private final Path minecraftJar;
    private final Path minecraftJarTmp;
    private JLabel serverJarLabel;
    private JButton downloadButton;
    private JButton generateButton;

    private ServerPostInstallDialog(ServerHandler handler) throws HeadlessException {
        super((Frame)InstallerGui.instance, true);
        this.serverHandler = handler;
        this.minecraftVersion = (String)handler.gameVersionComboBox.getSelectedItem();
        this.installDir = Paths.get(handler.installLocation.getText(), new String[0]);
        this.minecraftJar = this.installDir.resolve("server.jar");
        this.minecraftJarTmp = this.installDir.resolve("server.jar.tmp");
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        this.initComponents();
        this.setContentPane(this.panel);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemClassLoader().getResource("icon.png")));
    }

    private void initComponents() {
        this.addRow(this.panel, panel -> panel.add(this.fontSize(new JLabel(Utils.BUNDLE.getString("progress.done.server")), 20)));
        this.addRow(this.panel, panel -> panel.add(this.fontSize(new JLabel(Utils.BUNDLE.getString("prompt.server.info.jar")), 15)));
        this.addRow(this.panel, panel -> {
            this.updateServerJarLabel();
            panel.add(this.serverJarLabel);
            this.downloadButton = new JButton(Utils.BUNDLE.getString("prompt.server.jar"));
            this.downloadButton.addActionListener(e -> this.doServerJarDownload());
            panel.add(this.downloadButton);
        });
        this.addRow(this.panel, panel -> panel.add(this.fontSize(new JLabel(Utils.BUNDLE.getString("prompt.server.info.command")), 15)));
        this.addRow(this.panel, panel -> {
            JTextField textField = new JTextField(launchCommand);
            textField.setHorizontalAlignment(0);
            panel.add(textField);
        });
        this.addRow(this.panel, panel -> {
            panel.add(new JLabel(Utils.BUNDLE.getString("prompt.server.info.scipt")));
            this.generateButton = new JButton(Utils.BUNDLE.getString("prompt.server.generate"));
            this.generateButton.addActionListener(e -> this.generateLaunchScripts());
            panel.add(this.generateButton);
        });
        this.addRow(this.panel, panel -> {
            JButton closeButton = new JButton(Utils.BUNDLE.getString("progress.done"));
            closeButton.addActionListener(e -> {
                this.setVisible(false);
                this.dispose();
            });
            panel.add(closeButton);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidJarPresent() {
        if (!Files.exists(this.minecraftJar, new LinkOption[0])) {
            return false;
        }
        try (JarFile jarFile = new JarFile(this.minecraftJar.toFile());){
            String text;
            JarEntry versionEntry = jarFile.getJarEntry("version.json");
            if (versionEntry == null) {
                boolean bl = false;
                return bl;
            }
            InputStream inputStream = jarFile.getInputStream(versionEntry);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                text = reader.lines().collect(Collectors.joining("\n"));
            }
            Json json = Json.read(text);
            String id = json.at("id").asString();
            String name = json.at("name").asString();
            boolean bl = this.minecraftVersion.equals(id) || this.minecraftVersion.equals(name);
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void updateServerJarLabel() {
        if (this.serverJarLabel == null) {
            this.serverJarLabel = new JLabel();
        }
        if (this.isValidJarPresent()) {
            this.serverJarLabel.setText(new MessageFormat(Utils.BUNDLE.getString("prompt.server.jar.valid")).format(new Object[]{this.minecraftVersion}));
            this.color(this.serverJarLabel, Color.GREEN.darker());
        } else {
            this.serverJarLabel.setText(new MessageFormat(Utils.BUNDLE.getString("prompt.server.jar.invalid")).format(new Object[]{this.minecraftVersion}));
            this.color(this.serverJarLabel, Color.RED);
        }
    }

    private void doServerJarDownload() {
        this.downloadButton.setEnabled(false);
        try {
            Files.deleteIfExists(this.minecraftJar);
            Files.deleteIfExists(this.minecraftJarTmp);
        }
        catch (IOException e) {
            this.color(this.serverJarLabel, Color.RED).setText(e.getMessage());
            this.serverHandler.error(e);
            return;
        }
        new Thread(() -> {
            try {
                URL url = new URL(LauncherMeta.getLauncherMeta().getVersion((String)this.minecraftVersion).getVersionMeta().downloads.get((Object)"server").url);
                HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
                int finalSize = httpConnection.getContentLength();
                try (BufferedInputStream inputStream = new BufferedInputStream(httpConnection.getInputStream());
                     OutputStream outputStream = Files.newOutputStream(this.minecraftJarTmp, new OpenOption[0]);){
                    int len;
                    byte[] buffer = new byte[4096];
                    long downloaded = 0L;
                    while ((len = inputStream.read(buffer, 0, buffer.length)) >= 0) {
                        String labelText = new MessageFormat(Utils.BUNDLE.getString("prompt.server.downloading")).format(new Object[]{(downloaded += (long)len) / 1000000L, finalSize / 1000000});
                        SwingUtilities.invokeLater(() -> this.color(this.serverJarLabel, Color.BLUE).setText(labelText));
                        outputStream.write(buffer, 0, len);
                    }
                }
                Files.move(this.minecraftJarTmp, this.minecraftJar, StandardCopyOption.REPLACE_EXISTING);
                this.updateServerJarLabel();
                this.downloadButton.setEnabled(true);
            }
            catch (IOException e) {
                this.color(this.serverJarLabel, Color.RED).setText(e.getMessage());
                this.serverHandler.error(e);
            }
        }).start();
    }

    private void generateLaunchScripts() {
        HashMap<Path, String> launchScripts = new HashMap<Path, String>();
        launchScripts.put(this.installDir.resolve("start.bat"), "java -Xmx2G -jar fabric-server-launch.jar nogui\npause");
        launchScripts.put(this.installDir.resolve("start.sh"), "#!/usr/bin/env bash\njava -Xmx2G -jar fabric-server-launch.jar nogui");
        boolean exists = launchScripts.entrySet().stream().anyMatch(entry -> Files.exists((Path)entry.getKey(), new LinkOption[0]));
        if (exists && JOptionPane.showConfirmDialog(this, Utils.BUNDLE.getString("prompt.server.overwrite"), "Warning", 0) == 1) {
            return;
        }
        launchScripts.forEach((path, s) -> {
            try {
                Utils.writeToFile(path, s);
                path.toFile().setExecutable(true, false);
            }
            catch (IOException e) {
                this.serverHandler.error(e);
            }
        });
    }

    private JLabel fontSize(JLabel label, int size) {
        label.setFont(new Font(label.getFont().getName(), 0, size));
        return label;
    }

    private JLabel color(JLabel label, Color color) {
        label.setForeground(color);
        return label;
    }

    private void addRow(Container parent, Consumer<JPanel> consumer) {
        JPanel panel = new JPanel(new FlowLayout());
        consumer.accept(panel);
        parent.add(panel);
    }

    public static void show(ServerHandler serverHandler) throws ClassNotFoundException, UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        ServerPostInstallDialog dialog = new ServerPostInstallDialog(serverHandler);
        dialog.pack();
        dialog.setTitle(Utils.BUNDLE.getString("installer.title"));
        dialog.setLocationRelativeTo(InstallerGui.instance);
        dialog.setVisible(true);
    }
}

